(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2686172,      52848]
NotebookOptionsPosition[   2627401,      51472]
NotebookOutlinePosition[   2629090,      51523]
CellTagsIndexPosition[   2629047,      51520]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["TR1.1",
   FontFamily->"Arial"]], "None"], "    ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.4965234353062396`*^9, {3.5193214825316973`*^9, 3.5193214852617016`*^9}, {
   3.523316399894187*^9, 3.5233164032341914`*^9}, {3.523318350558202*^9, 
   3.5233183516382036`*^9}, {3.536542725780803*^9, 3.536542725780803*^9}, {
   3.5367764878952584`*^9, 3.5367764886452594`*^9}, {3.544322815209103*^9, 
   3.5443228192963104`*^9}, {3.5450662624913826`*^9, 3.545066292141424*^9}, {
   3.545066402271579*^9, 3.5450664054415827`*^9}, {3.5450834884295015`*^9, 
   3.5450834895895033`*^9}, {3.5454961263762493`*^9, 
   3.5454961321462574`*^9}, {3.5454963863166127`*^9, 
   3.5454964580867133`*^9}, {3.545497046127537*^9, 3.545497046127537*^9}, {
   3.5454971130676303`*^9, 3.545497136257663*^9}, 3.545610399977621*^9, {
   3.546040778592962*^9, 3.546040778592962*^9}, {3.5461052065706367`*^9, 
   3.5461052249474688`*^9}, {3.546191339879622*^9, 3.5461913430596266`*^9}, {
   3.5462141824067917`*^9, 3.5462142145768366`*^9}, {3.5462145455473003`*^9, 
   3.5462145601073203`*^9}, {3.5463149785974817`*^9, 3.5463149794195285`*^9}},
 TextAlignment->Center,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["1.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", ">", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, 3.5485441477885075`*^9, {
   3.548544198208578*^9, 3.548544198208578*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, 
   3.5472297585730677`*^9, 3.547229903793271*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.01.5, CRC 290, A&S 4.3.113", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.508355661955892*^9, 3.508355663305894*^9}, {
   3.5104240724965897`*^9, 3.510424073176591*^9}, {3.513094859183631*^9, 
   3.513094859994833*^9}, 3.5130991663737097`*^9, {3.514149253800121*^9, 
   3.5141492542901216`*^9}, {3.51459628299404*^9, 3.5145962845940423`*^9}, {
   3.541729942271918*^9, 3.5417299426775184`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "d"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.5098474822889233`*^9, {
   3.509909292936032*^9, 3.5099092939812336`*^9}, {3.5099093650549583`*^9, 
   3.509909365476159*^9}, {3.5099094331022778`*^9, 3.509909433570279*^9}, 
   3.5151673335332727`*^9, {3.541729778830431*^9, 3.54172978410324*^9}, 
   3.541730096056988*^9, {3.5472297595430694`*^9, 3.5472297611130714`*^9}, {
   3.547229904793273*^9, 3.5472299057432737`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"sin", "[", 
     RowBox[{"c_.", "+", 
      RowBox[{"d_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "/", "d"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}, {
   3.5417298013412704`*^9, 3.5417298017780714`*^9}, {3.5417301333410535`*^9, 
   3.54173014270107*^9}, {3.5462976810838175`*^9, 3.54629768298382*^9}, 
   3.5467337010721283`*^9, {3.547229761893073*^9, 3.5472297668230796`*^9}, {
   3.5472299093232794`*^9, 3.5472299108232813`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"0", "<", "m", "<", "1"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, {3.5472257438874474`*^9, 
   3.547225761207472*^9}, 3.5485441494685097`*^9, {3.5485442183986063`*^9, 
   3.5485442183986063`*^9}, {3.549036085458572*^9, 3.5490360915893826`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, {
   3.541786614186118*^9, 3.541786628256138*^9}, {3.5462980033342686`*^9, 
   3.5462980035242686`*^9}, {3.546735095729898*^9, 3.54673511411395*^9}, {
   3.547225759157469*^9, 3.547225759377469*^9}, {3.5490360949745884`*^9, 
   3.549036097501793*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.508355661955892*^9, 3.508355663305894*^9}, {
   3.5104240724965897`*^9, 3.510424073176591*^9}, {3.513094859183631*^9, 
   3.513094859994833*^9}, 3.5130991663737097`*^9, {3.514149253800121*^9, 
   3.5141492542901216`*^9}, {3.51459628299404*^9, 3.5145962845940423`*^9}, {
   3.541729942271918*^9, 3.5417299426775184`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"EllipticE", "[", 
         RowBox[{
          RowBox[{
           FractionBox["\[Pi]", "4"], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], ")"}]}]}], ",", "2"}], "]"}]}], 
       "d"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.5098474822889233`*^9, {
   3.509909292936032*^9, 3.5099092939812336`*^9}, {3.5099093650549583`*^9, 
   3.509909365476159*^9}, {3.5099094331022778`*^9, 3.509909433570279*^9}, 
   3.5151673335332727`*^9, {3.541729778830431*^9, 3.54172978410324*^9}, 
   3.541730096056988*^9, 3.54178664403616*^9, 3.541786724876273*^9, {
   3.5467350966199493`*^9, 3.546735115707041*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"Pi", "/", "2"}], "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", "2"}], "]"}], 
     "/", "d"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}, {
   3.5417298013412704`*^9, 3.5417298017780714`*^9}, {3.5417301333410535`*^9, 
   3.54173014270107*^9}, {3.5417867688963346`*^9, 3.5417868178164034`*^9}, {
   3.54673486113348*^9, 3.546734861376494*^9}, {3.5467349070151043`*^9, 
   3.5467349315035048`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Pi", "/", "4"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}]}], ",", "2"}], "]"}], 
     "/", "d"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}, {
   3.5417298013412704`*^9, 3.5417298017780714`*^9}, {3.5417301333410535`*^9, 
   3.54173014270107*^9}, {3.5417867688963346`*^9, 3.541786776216345*^9}, 
   3.546297726693881*^9, {3.5467351017322416`*^9, 3.546735122234414*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"0", "<", "m", "<", "1"}], " ", "\[And]", " ", 
       RowBox[{"m", "\[NotEqual]", 
        FractionBox["1", "2"]}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193422443984776`*^9, 3.5193422447260776`*^9}, 
   3.5193424488212357`*^9, {3.5193434708254333`*^9, 3.519343473103037*^9}, {
   3.5193435097631016`*^9, 3.51934353169674*^9}, {3.519345739319023*^9, 
   3.519345739599823*^9}, 3.5193462601259375`*^9, {3.5193475061060295`*^9, 
   3.5193475233908596`*^9}, {3.519351391880224*^9, 3.5193513931402254`*^9}, {
   3.519403773021052*^9, 3.5194037798564425`*^9}, 3.5194106793250647`*^9, {
   3.519537578341393*^9, 3.5195375792305946`*^9}, {3.5195376277778797`*^9, 
   3.51953767927357*^9}, {3.5197586260636144`*^9, 3.5197586260636144`*^9}, {
   3.51978053295651*^9, 3.519780542862528*^9}, {3.5197806526087203`*^9, 
   3.5197806657595434`*^9}, {3.5197807490168896`*^9, 3.5197807642581167`*^9}, 
   3.5197809004619555`*^9, {3.519782653514635*^9, 3.5197826623286505`*^9}, {
   3.5200207810164795`*^9, 3.520020785046485*^9}, {3.5213126833374643`*^9, 
   3.5213126833374643`*^9}, {3.521328235411002*^9, 3.521328235411002*^9}, {
   3.523315567893022*^9, 3.523315567893022*^9}, {3.5233157569332867`*^9, 
   3.5233157613032923`*^9}, {3.5323023198133526`*^9, 3.532302355723403*^9}, {
   3.5323026417638035`*^9, 3.5323026417638035`*^9}, {3.5323026980138817`*^9, 
   3.5323026980138817`*^9}, {3.532636287104328*^9, 3.532636287104328*^9}, {
   3.5330803686035347`*^9, 3.533080368863535*^9}, {3.533248909289961*^9, 
   3.5332489110299635`*^9}, {3.534962469565694*^9, 3.5349624910757236`*^9}, {
   3.5349625224057674`*^9, 3.534962522655768*^9}, {3.534965265519608*^9, 
   3.534965265519608*^9}, {3.5349668288168063`*^9, 3.5349668292668066`*^9}, {
   3.5349747358481646`*^9, 3.5349747358481646`*^9}, {3.534975457949176*^9, 
   3.534975457949176*^9}, {3.5368633963532934`*^9, 3.536863396571694*^9}, {
   3.541644322511304*^9, 3.5416443577513533`*^9}, {3.5416458269234104`*^9, 
   3.541645839633428*^9}, {3.5416460312236967`*^9, 3.541646031483697*^9}, 
   3.541646227783972*^9, {3.541647080335165*^9, 3.5416471077052035`*^9}, {
   3.541648997607849*^9, 3.5416489978278494`*^9}, 3.541649088407976*^9, {
   3.5417848711596775`*^9, 3.541784902429721*^9}, {3.541786145331461*^9, 
   3.5417861455914617`*^9}, {3.5417870037166634`*^9, 3.5417870039366636`*^9}, 
   3.5462979620242105`*^9, {3.546298264094633*^9, 3.546298265344635*^9}, {
   3.546299000235664*^9, 3.546299001505666*^9}, {3.546315119909564*^9, 
   3.5463151267659564`*^9}, {3.547227356319705*^9, 3.547227356319705*^9}, 
   3.547918559331044*^9, {3.547918610170952*^9, 3.5479186304411116`*^9}, 
   3.548537755517557*^9, 3.5485441629685287`*^9, 3.5485517520154133`*^9, {
   3.549036110980217*^9, 3.54903612427144*^9}, {3.551480730291853*^9, 
   3.5514807350671263`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"0", "<", "m", "<", "1"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[NotEqual]", 
    FractionBox["1", "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 
   3.5473171298465743`*^9}, {3.548551779580662*^9, 3.548551779580662*^9}, {
   3.549036451185614*^9, 3.549036451185614*^9}, {3.5514807427035627`*^9, 
   3.5514807427035627`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "1"}]]}], 
       RowBox[{"d", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"], ")"}], 
         FractionBox[
          RowBox[{"m", "-", "1"}], "2"]]}]]}]}]}], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", "m"}], "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["3", "2"], ",", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}, {3.4954956850364604`*^9, 
   3.4954957088577023`*^9}, {3.495495865341577*^9, 3.4954958884920177`*^9}, {
   3.495496084225561*^9, 3.4954961029143944`*^9}, {3.495496211459385*^9, 
   3.4954962213810024`*^9}, 3.495496440218187*^9, {3.495497026732417*^9, 
   3.4954970596328745`*^9}, {3.495497256957621*^9, 3.495497302338101*^9}, 
   3.533151648818928*^9, 3.5331516797189713`*^9, 3.533151717349024*^9, {
   3.5331518776292486`*^9, 3.533151970249378*^9}, {3.5331520176994443`*^9, 
   3.5331520227894516`*^9}, {3.533152054329496*^9, 3.5331520626995077`*^9}, 
   3.533152270349798*^9, {3.533153065130911*^9, 3.5331530971109557`*^9}, 
   3.53315335008131*^9, {3.5331535194015465`*^9, 3.5331535356615696`*^9}, 
   3.5331536017616625`*^9, {3.533221927890974*^9, 3.533221930830978*^9}, {
   3.533222264011444*^9, 3.533222283731472*^9}, {3.5332223304615374`*^9, 
   3.5332223353515444`*^9}, 3.5363501604045196`*^9, {3.536361767566806*^9, 
   3.5363617697768087`*^9}, {3.5363666287016163`*^9, 
   3.5363666313816195`*^9}, {3.536366784271834*^9, 3.5363667868618374`*^9}, {
   3.536366923782029*^9, 3.5363669254320316`*^9}, {3.5365968786057057`*^9, 
   3.536596881944112*^9}, {3.5366940930205193`*^9, 3.53669410440917*^9}, {
   3.5366942507975435`*^9, 3.536694251403578*^9}, {3.536694493325415*^9, 
   3.536694495295528*^9}, 3.536980387788585*^9, 3.536980543328803*^9, {
   3.536980609078895*^9, 3.536980616128905*^9}, {3.541649113828012*^9, 
   3.5416491983381305`*^9}, {3.541784911249734*^9, 3.5417849123597355`*^9}, {
   3.5417850837099752`*^9, 3.541785086039978*^9}, 3.541785407620428*^9, {
   3.5462979670942173`*^9, 3.5462979721642246`*^9}, {3.546300486527745*^9, 
   3.5463004893777485`*^9}, 3.54630054724783*^9, 3.54854416359853*^9, {
   3.5485444249588957`*^9, 3.548544427518899*^9}, 3.549036276090907*^9, {
   3.5490363163857775`*^9, 3.5490363204729843`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}], "/", "2"}], ")"}]}]}], ")"}]}], 
    "*", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m"}], ")"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"3", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "1"}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.4983258972265496`*^9, 
   3.498327107991476*^9, {3.5144655337954865`*^9, 3.514465569098348*^9}, 
   3.514465744255456*^9, {3.5416469646850033`*^9, 3.5416469818250275`*^9}, 
   3.5416492697082305`*^9, {3.5416494755985184`*^9, 3.541649535918603*^9}, 
   3.541649648488761*^9, 3.5416496916688213`*^9, {3.541785098139995*^9, 
   3.5417850984799957`*^9}, 3.541785182770114*^9, 3.5417854688205137`*^9, 
   3.5462977398238993`*^9, {3.546297973554227*^9, 3.546297980984237*^9}, {
   3.5463004996277633`*^9, 3.5463005532478385`*^9}, {3.546300585177883*^9, 
   3.5463005906178904`*^9}, {3.546315104787699*^9, 3.546315106110775*^9}, {
   3.5472273633697147`*^9, 3.54722736743972*^9}, {3.5472662655699863`*^9, 
   3.547266266979988*^9}, 3.547918566054429*^9, {3.547918635926425*^9, 
   3.5479186411567245`*^9}, 3.5485289098501673`*^9, {3.5485377636975684`*^9, 
   3.548537774797584*^9}, 3.5485434454575243`*^9, {3.548544432458906*^9, 
   3.548544441878919*^9}, {3.5485517889250784`*^9, 3.54855179539909*^9}, 
   3.549036298336546*^9, {3.5490363292558002`*^9, 3.549036358225051*^9}, {
   3.549036409985942*^9, 3.549036443557201*^9}, {3.551480746636788*^9, 
   3.551480751439062*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["3.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", ">", "1"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, {3.5472257438874474`*^9, 
   3.547225761207472*^9}, 3.5485441494685097`*^9, {3.5485442183986063`*^9, 
   3.5485442183986063`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
       RowBox[{
        FractionBox[
         RowBox[{"m", "-", "1"}], "2"], "\[Element]", 
        "\[DoubleStruckCapitalZ]"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, {
   3.54173007448215*^9, 3.5417300747317505`*^9}, 3.541730224086413*^9, {
   3.5417303473110294`*^9, 3.5417303497914333`*^9}, 3.5417303800242867`*^9, {
   3.5417304398347917`*^9, 3.5417304523616133`*^9}, {3.541731844320859*^9, 
   3.541731844320859*^9}, {3.541785615460719*^9, 3.5417856169007215`*^9}, 
   3.5417859063311267`*^9, {3.5417860615813437`*^9, 3.541786068891354*^9}, {
   3.5417864158458405`*^9, 3.5417864160558405`*^9}, {3.5462978974541197`*^9, 
   3.546297898854122*^9}, {3.5462981037744093`*^9, 3.5462981040444098`*^9}, 
   3.547225830427569*^9, 3.547225942097725*^9, 3.547229780763099*^9, 
   3.5472299146732864`*^9, 3.5485441500685105`*^9, {3.548544231078624*^9, 
   3.548544231838625*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "d"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"m", "-", "1"}], "2"]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4975762570673447`*^9, 3.4975763239574385`*^9}, 3.4975764674176397`*^9, 
   3.5102501580436487`*^9, {3.510254519679755*^9, 3.5102545228597593`*^9}, {
   3.54173151495748*^9, 3.5417315168138833`*^9}, {3.5417857321808825`*^9, 
   3.5417857726609397`*^9}, {3.5462978996541233`*^9, 3.546297901144125*^9}, {
   3.5472297893331113`*^9, 3.5472297930531163`*^9}, {3.5472299207332954`*^9, 
   3.5472299224132977`*^9}, {3.5485441530985146`*^9, 
   3.5485441530985146`*^9}, {3.5485442383486342`*^9, 3.5485442428286405`*^9}}],

Cell[TextData[{
 "Note: Although not essential, this rule for odd ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]]],
 " requires fewer steps and produces simpler antiderivatives than the \
reduction rule for ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], "m"]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
    3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4975763844775233`*^9, 
    3.497576391597533*^9}, 3.509847486078929*^9, {3.5099093157276716`*^9, 
    3.509909318800877*^9}, {3.5099093924018064`*^9, 3.509909402370224*^9}, {
    3.509909454443115*^9, 3.5099094563775187`*^9}, {3.510254527619766*^9, 
    3.5102545284397674`*^9}, 3.515167425103401*^9, {3.5417315235998955`*^9, 
    3.541731524426697*^9}, {3.5417857114108534`*^9, 3.5417857159608603`*^9}, {
    3.546297909434137*^9, 3.546297910194138*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, {3.49757671762799*^9, 3.4975767846480837`*^9}, {
   3.4975768494507804`*^9, 3.4975769045208573`*^9}, {3.514059115062192*^9, 
   3.514059117572195*^9}, {3.514463868305361*^9, 3.5144638997862163`*^9}, {
   3.5150245181044073`*^9, 3.5150245197275*^9}, 3.515024656880345*^9, {
   3.5151943490841937`*^9, 3.5151943495241947`*^9}, {3.541731518202286*^9, 
   3.541731518202286*^9}, {3.541785569820656*^9, 3.5417855745206623`*^9}, {
   3.5462979024741273`*^9, 3.5462979024741273`*^9}, {3.5462981175644283`*^9, 
   3.54629811881443*^9}, {3.547226002027809*^9, 3.547226012777824*^9}, {
   3.5472265301385484`*^9, 3.547226557078586*^9}, {3.547229794183118*^9, 
   3.547229794183118*^9}, {3.547229930463309*^9, 3.547229930463309*^9}, {
   3.5485441547285175`*^9, 3.5485441547285175`*^9}, {3.5485442492486496`*^9, 
   3.5485442492486496`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "-", "1"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.497576396827541*^9, 3.4975764493076143`*^9}, 3.497576946310916*^9, {
   3.506712458158085*^9, 3.5067124653984957`*^9}, {3.506712506537651*^9, 
   3.5067125078695664`*^9}, {3.5067127618547792`*^9, 
   3.5067127622653694`*^9}, {3.5102492925924373`*^9, 
   3.5102493125924654`*^9}, {3.510254523809761*^9, 3.510254525009763*^9}, {
   3.510424098436626*^9, 3.5104240988966265`*^9}, {3.5150246497749386`*^9, 
   3.5150246514040318`*^9}, {3.5417315220710926`*^9, 
   3.5417315226950936`*^9}, {3.5417858612210636`*^9, 3.541785861691064*^9}, {
   3.541786043661319*^9, 3.5417860542013335`*^9}, {3.5462979080541353`*^9, 
   3.546297908714136*^9}, {3.548544260388665*^9, 3.548544261668667*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "d"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{"m", "-", "1"}], "2"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4975763844775233`*^9, 
   3.497576391597533*^9}, 3.509847486078929*^9, {3.5099093157276716`*^9, 
   3.509909318800877*^9}, {3.5099093924018064`*^9, 3.509909402370224*^9}, {
   3.509909454443115*^9, 3.5099094563775187`*^9}, {3.510254527619766*^9, 
   3.5102545284397674`*^9}, 3.515167425103401*^9, {3.5417315235998955`*^9, 
   3.541731524426697*^9}, {3.5417857114108534`*^9, 3.5417857159608603`*^9}, {
   3.546297909434137*^9, 3.546297910194138*^9}, {3.54722979531312*^9, 
   3.547229801253128*^9}, {3.54722993175331*^9, 3.547229932533312*^9}, 
   3.5485441563085194`*^9, 3.548544267268675*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "d"}], "*", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"m", "-", "1"}], ")"}], "/", "2"}], ")"}]}], ",", "x"}],
          "]"}], ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.497576340197461*^9, {3.5020443872559056`*^9, 3.5020443882231073`*^9}, 
   3.509847488328932*^9, {3.5099093200488796`*^9, 3.5099093252904882`*^9}, {
   3.509909412042241*^9, 3.5099094173774505`*^9}, {3.5099094584523225`*^9, 
   3.50990946269553*^9}, {3.510254532869774*^9, 3.510254538269781*^9}, {
   3.5417315289195046`*^9, 3.5417315344419146`*^9}, {3.5417315647371674`*^9, 
   3.5417315795727935`*^9}, {3.5417856389207525`*^9, 
   3.5417856393807526`*^9}, {3.541786000801259*^9, 3.541786005191265*^9}, 
   3.5462977282938833`*^9, {3.5462979111541395`*^9, 3.5462979168041472`*^9}, {
   3.5463014451790867`*^9, 3.5463014478090906`*^9}, {3.547229802383129*^9, 
   3.5472298110031414`*^9}, {3.5472299361933165`*^9, 
   3.5472299407833233`*^9}, {3.548544274508685*^9, 3.5485442854786997`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
       RowBox[{
        FractionBox[
         RowBox[{"m", "-", "1"}], "2"], "\[NotElement]", 
        "\[DoubleStruckCapitalZ]"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, {3.546298061184349*^9, 
   3.5462980943443956`*^9}, {3.546298957235604*^9, 3.5462989584756055`*^9}, {
   3.54722578855751*^9, 3.547225826937564*^9}, {3.5472259609177513`*^9, 
   3.5472259739277697`*^9}, 3.5472298121731434`*^9, 3.5472299464733315`*^9, 
   3.548544157528521*^9, {3.548544296598716*^9, 3.5485442971287165`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, {
   3.54173007448215*^9, 3.5417300747317505`*^9}, 3.541730224086413*^9, {
   3.5417864129858365`*^9, 3.541786414225838*^9}, {3.5462978662540765`*^9, 
   3.5462978678040786`*^9}, {3.5462980013342657`*^9, 3.546298001594266*^9}, {
   3.5472257848475046`*^9, 3.5472257851375055`*^9}, {3.547225828747566*^9, 
   3.5472258289375668`*^9}, 3.5472298131031446`*^9, 3.5472299473933325`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.513.5, CRC 296", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9}],

Cell["\<\
Note: Although this is just a special case of the following rule, it is \
simpler and saves a trivial step.\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.5130948677012463`*^9, 3.513094868777648*^9}, {3.5130985654428687`*^9, 
   3.5130985665528708`*^9}, {3.5130991696337147`*^9, 
   3.5130991703437157`*^9}, {3.514149257920127*^9, 3.514149258420127*^9}, {
   3.5145964170042276`*^9, 3.5145964181642294`*^9}, {3.5417300030496244`*^9, 
   3.541730003455225*^9}, {3.548530949543024*^9, 3.54853106087318*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.5130948677012463`*^9, 3.513094868777648*^9}, {3.5130985654428687`*^9, 
   3.5130985665528708`*^9}, {3.5130991696337147`*^9, 
   3.5130991703437157`*^9}, {3.514149257920127*^9, 3.514149258420127*^9}, {
   3.5145964170042276`*^9, 3.5145964181642294`*^9}, {3.5417300030496244`*^9, 
   3.541730003455225*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "2"]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"2", " ", "d"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.5104280288041296`*^9, 
   3.5104280295541306`*^9}, {3.5118052381591825`*^9, 3.5118052503691998`*^9}, 
   3.515167386363347*^9, {3.5417300856361694`*^9, 3.5417300912209797`*^9}, {
   3.547229814033146*^9, 3.547229815923148*^9}, {3.547229948333334*^9, 
   3.547229949813336*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "2"}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d"}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, {
   3.510428025654125*^9, 3.5104280263541265`*^9}, {3.5118052594092126`*^9, 
   3.5118052744592333`*^9}, {3.5417300081196337`*^9, 3.541730025264064*^9}, {
   3.541730185023944*^9, 3.5417301979719667`*^9}, 3.546297727523882*^9, 
   3.546733814462614*^9, {3.5472298174131503`*^9, 3.547229822643158*^9}, {
   3.5472299539133415`*^9, 3.5472299559133444`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
       RowBox[{
        FractionBox[
         RowBox[{"m", "-", "1"}], "2"], "\[NotElement]", 
        "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
       RowBox[{"m", "\[NotEqual]", "2"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, {
   3.54173007448215*^9, 3.5417300747317505`*^9}, 3.541730224086413*^9, {
   3.5417303872002993`*^9, 3.5417303962951155`*^9}, {3.5417304415507946`*^9, 
   3.541730453500416*^9}, {3.5417314856138287`*^9, 3.5417314856138287`*^9}, {
   3.541785619510725*^9, 3.541785621680728*^9}, {3.541786028341297*^9, 
   3.541786034311306*^9}, {3.5417864196958456`*^9, 3.541786419905846*^9}, {
   3.5462979182541494`*^9, 3.5462979197741513`*^9}, {3.54629812591444*^9, 
   3.5462981261344404`*^9}, 3.5472259863377867`*^9, {3.547226121417976*^9, 
   3.547226125687982*^9}, 3.547229823473159*^9, 3.5472299569633455`*^9, 
   3.548544158308522*^9, {3.5485443147187414`*^9, 3.5485443164187436`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.510.2, CRC 299", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9}],

Cell[TextData[{
 "Reference: G&R 2.552.3 inverted special case when ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, 3.497583103771538*^9, 
   3.49758316261162*^9, 3.497923625588915*^9, {3.4982410640439453`*^9, 
   3.498241080323968*^9}, {3.5053540835659466`*^9, 3.505354083875947*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "-", "1"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.497583245131736*^9, 3.4975832480817394`*^9}, {
   3.504471143260519*^9, 3.5044711443605204`*^9}, {3.504482109666358*^9, 
   3.50448211089636*^9}, 3.5049885403707232`*^9, {3.506712216921203*^9, 
   3.506712230961392*^9}, {3.5067123979715405`*^9, 3.5067124241692114`*^9}, 
   3.5067125107336845`*^9, {3.5067127658004527`*^9, 3.506712766261115*^9}, {
   3.510249931643332*^9, 3.510249940363344*^9}, {3.5102527005472083`*^9, 
   3.510252712257225*^9}, 3.510254739550063*^9, {3.5104241131166463`*^9, 
   3.510424113586647*^9}, {3.510427054232765*^9, 3.5104270592727723`*^9}, {
   3.5130947799198923`*^9, 3.513094781152294*^9}, 3.513098569812875*^9, {
   3.5130991132136354`*^9, 3.513099113923637*^9}, {3.5130992337838044`*^9, 
   3.513099234983806*^9}, 3.5141492899501715`*^9, 3.515024654061184*^9, {
   3.5417309893457565`*^9, 3.541731015600603*^9}, {3.541785875061083*^9, 
   3.5417858756410837`*^9}, {3.5417860402713137`*^9, 
   3.5417860402713137`*^9}, {3.546297923954157*^9, 3.546297924424158*^9}, {
   3.5472261324079914`*^9, 3.5472261324079914`*^9}, {3.5485443225687523`*^9, 
   3.548544323678754*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"m", "-", "1"}]]}], 
        RowBox[{"d", " ", "m"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], "m"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095014878340373`*^9, 3.5095014885516386`*^9}, {3.509501723296851*^9, 
   3.5095017455424905`*^9}, {3.510167018471958*^9, 3.5101670221519637`*^9}, {
   3.510167325332388*^9, 3.5101673371024046`*^9}, {3.5102509934548187`*^9, 
   3.5102511286150074`*^9}, {3.5102512230551395`*^9, 
   3.5102512252151427`*^9}, {3.510251266585201*^9, 3.510251502655531*^9}, {
   3.510251603195672*^9, 3.510251604205673*^9}, {3.5102519162461104`*^9, 
   3.5102519201161156`*^9}, {3.5102520180262527`*^9, 3.510252061526314*^9}, 
   3.5102540815591416`*^9, {3.5151674394434214`*^9, 3.5151674412534237`*^9}, {
   3.5417310165054045`*^9, 3.5417310206082115`*^9}, {3.54173117353528*^9, 
   3.5417312486182127`*^9}, 3.5417313831684484`*^9, {3.5462979252241592`*^9, 
   3.5462979280841627`*^9}, {3.54722982436316*^9, 3.5472298268431635`*^9}, {
   3.5472299887933903`*^9, 3.547229990293392*^9}, 3.548544158928523*^9, {
   3.548544330608763*^9, 3.5485443357087708`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.510252135446417*^9, 3.5102521410864253`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "m"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}], "/", "m"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, 3.4975831484616003`*^9, {3.4979216146049824`*^9, 
   3.4979216448222356`*^9}, 3.4979236340597296`*^9, {3.5067062863534656`*^9, 
   3.5067062877354527`*^9}, {3.5067123638124228`*^9, 3.506712370982733*^9}, {
   3.514464069311714*^9, 3.514464109434984*^9}, {3.51446563282446*^9, 
   3.5144656445712805`*^9}, 3.5144657311826324`*^9, {3.5417310746467066`*^9, 
   3.5417311266415977`*^9}, {3.5417859561311965`*^9, 
   3.5417859627212057`*^9}, {3.546297687203826*^9, 3.546297687833827*^9}, {
   3.546297929274165*^9, 3.5462979340541716`*^9}, {3.5463014548691006`*^9, 
   3.5463014570391035`*^9}, {3.5472261088979588`*^9, 
   3.5472261131279645`*^9}, {3.5472298280531654`*^9, 3.547229834173174*^9}, {
   3.547229994173398*^9, 3.5472299966534014`*^9}, {3.5485443409287777`*^9, 
   3.548544355488798*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "<", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, {3.546297534403612*^9, 3.546297545453627*^9}, {
   3.5462981954745374`*^9, 3.5462981956945376`*^9}, 3.548544160798526*^9, {
   3.548544366248813*^9, 3.548544366248813*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"-", "1"}], "<", "m", "<", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, {3.5472257438874474`*^9, 
   3.547225761207472*^9}, 3.5485441494685097`*^9, {3.5485442183986063`*^9, 
   3.5485442183986063`*^9}, {3.549036085458572*^9, 3.5490360915893826`*^9}, {
   3.549036523554141*^9, 3.549036533725359*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, {
   3.541786614186118*^9, 3.541786628256138*^9}, {3.541786846246443*^9, 
   3.541786854406454*^9}, {3.5462982075745544`*^9, 3.5462982078345547`*^9}, {
   3.546735019762553*^9, 3.5467350447699833`*^9}, {3.5472569246453185`*^9, 
   3.547256924785319*^9}, {3.5479184951733747`*^9, 3.547918495410388*^9}, 
   3.5490365255821447`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.508355661955892*^9, 3.508355663305894*^9}, {
   3.5104240724965897`*^9, 3.510424073176591*^9}, {3.513094859183631*^9, 
   3.513094859994833*^9}, 3.5130991663737097`*^9, {3.514149253800121*^9, 
   3.5141492542901216`*^9}, {3.51459628299404*^9, 3.5145962845940423`*^9}, {
   3.541729942271918*^9, 3.5417299426775184`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"EllipticF", "[", 
         RowBox[{
          RowBox[{
           FractionBox["\[Pi]", "4"], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], ")"}]}]}], ",", "2"}], "]"}]}], 
       "d"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.5098474822889233`*^9, {
   3.509909292936032*^9, 3.5099092939812336`*^9}, {3.5099093650549583`*^9, 
   3.509909365476159*^9}, {3.5099094331022778`*^9, 3.509909433570279*^9}, 
   3.5151673335332727`*^9, {3.541729778830431*^9, 3.54172978410324*^9}, 
   3.541730096056988*^9, 3.54178664403616*^9, 3.541786724876273*^9, 
   3.541786863216467*^9, 3.541786898366516*^9, {3.546735020828614*^9, 
   3.5467350474201345`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"Pi", "/", "2"}], "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"EllipticF", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", "2"}], "]"}], 
     "/", "d"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}, {
   3.5417298013412704`*^9, 3.5417298017780714`*^9}, {3.5417301333410535`*^9, 
   3.54173014270107*^9}, {3.5417867688963346`*^9, 3.5417868178164034`*^9}, {
   3.5417869391765733`*^9, 3.541786939876574*^9}, {3.5418046552633452`*^9, 
   3.5418046559333463`*^9}, {3.5467350050977144`*^9, 3.5467350519783955`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"EllipticF", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Pi", "/", "4"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}]}], ",", "2"}], "]"}], 
     "/", "d"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}, {
   3.5417298013412704`*^9, 3.5417298017780714`*^9}, {3.5417301333410535`*^9, 
   3.54173014270107*^9}, {3.5417867688963346`*^9, 3.541786776216345*^9}, 
   3.5417869350265675`*^9, {3.541804652133341*^9, 3.541804652303341*^9}, 
   3.546297730333886*^9, {3.5467350270739713`*^9, 3.5467350573537035`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"-", "1"}], "<", "m", "<", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193422443984776`*^9, 3.5193422447260776`*^9}, 
   3.5193424488212357`*^9, {3.5193434708254333`*^9, 3.519343473103037*^9}, {
   3.5193435097631016`*^9, 3.51934353169674*^9}, {3.519345739319023*^9, 
   3.519345739599823*^9}, 3.5193462601259375`*^9, {3.5193475061060295`*^9, 
   3.5193475233908596`*^9}, {3.519351391880224*^9, 3.5193513931402254`*^9}, {
   3.519403773021052*^9, 3.5194037798564425`*^9}, 3.5194106793250647`*^9, {
   3.519537578341393*^9, 3.5195375792305946`*^9}, {3.5195376277778797`*^9, 
   3.51953767927357*^9}, {3.5197586260636144`*^9, 3.5197586260636144`*^9}, {
   3.51978053295651*^9, 3.519780542862528*^9}, {3.5197806526087203`*^9, 
   3.5197806657595434`*^9}, {3.5197807490168896`*^9, 3.5197807642581167`*^9}, 
   3.5197809004619555`*^9, {3.519782653514635*^9, 3.5197826623286505`*^9}, {
   3.5200207810164795`*^9, 3.520020785046485*^9}, {3.5213126833374643`*^9, 
   3.5213126833374643`*^9}, {3.521328235411002*^9, 3.521328235411002*^9}, {
   3.523315567893022*^9, 3.523315567893022*^9}, {3.5233157569332867`*^9, 
   3.5233157613032923`*^9}, {3.5323023198133526`*^9, 3.532302355723403*^9}, {
   3.5323026417638035`*^9, 3.5323026417638035`*^9}, {3.5323026980138817`*^9, 
   3.5323026980138817`*^9}, {3.532636287104328*^9, 3.532636287104328*^9}, {
   3.5330803686035347`*^9, 3.533080368863535*^9}, {3.533248909289961*^9, 
   3.5332489110299635`*^9}, {3.534962469565694*^9, 3.5349624910757236`*^9}, {
   3.5349625224057674`*^9, 3.534962522655768*^9}, {3.534965265519608*^9, 
   3.534965265519608*^9}, {3.5349668288168063`*^9, 3.5349668292668066`*^9}, {
   3.5349747358481646`*^9, 3.5349747358481646`*^9}, {3.534975457949176*^9, 
   3.534975457949176*^9}, {3.5368633963532934`*^9, 3.536863396571694*^9}, {
   3.541644322511304*^9, 3.5416443577513533`*^9}, {3.5416458269234104`*^9, 
   3.541645839633428*^9}, {3.5416460312236967`*^9, 3.541646031483697*^9}, 
   3.541646227783972*^9, {3.541647080335165*^9, 3.5416471077052035`*^9}, {
   3.541648997607849*^9, 3.5416489978278494`*^9}, 3.541649088407976*^9, {
   3.5417848711596775`*^9, 3.541784902429721*^9}, {3.541786145331461*^9, 
   3.5417861455914617`*^9}, {3.5417870037166634`*^9, 3.5417870039366636`*^9}, 
   3.5462979620242105`*^9, {3.546298264094633*^9, 3.546298265344635*^9}, {
   3.546299000235664*^9, 3.546299001505666*^9}, {3.546315119909564*^9, 
   3.5463151267659564`*^9}, {3.547227356319705*^9, 3.547227356319705*^9}, 
   3.547918559331044*^9, {3.547918610170952*^9, 3.5479186304411116`*^9}, 
   3.548537755517557*^9, 3.5485441629685287`*^9, 3.5485517520154133`*^9, {
   3.549036110980217*^9, 3.54903612427144*^9}, {3.5490365773898363`*^9, 
   3.5490365773898363`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "<", "m", "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 
   3.5473171298465743`*^9}, {3.548551779580662*^9, 3.548551779580662*^9}, {
   3.549036451185614*^9, 3.549036451185614*^9}, {3.5490365816798434`*^9, 
   3.5490365816798434`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "1"}]]}], 
       RowBox[{"d", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"], ")"}], 
         FractionBox[
          RowBox[{"m", "+", "1"}], "2"]]}]]}]}]}], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", "m"}], "2"], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["3", "2"], ",", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}, {3.4954956850364604`*^9, 
   3.4954957088577023`*^9}, {3.495495865341577*^9, 3.4954958884920177`*^9}, {
   3.495496084225561*^9, 3.4954961029143944`*^9}, {3.495496211459385*^9, 
   3.4954962213810024`*^9}, 3.495496440218187*^9, {3.495497026732417*^9, 
   3.4954970596328745`*^9}, {3.495497256957621*^9, 3.495497302338101*^9}, 
   3.533151648818928*^9, 3.5331516797189713`*^9, 3.533151717349024*^9, {
   3.5331518776292486`*^9, 3.533151970249378*^9}, {3.5331520176994443`*^9, 
   3.5331520227894516`*^9}, {3.533152054329496*^9, 3.5331520626995077`*^9}, 
   3.533152270349798*^9, {3.533153065130911*^9, 3.5331530971109557`*^9}, 
   3.53315335008131*^9, {3.5331535194015465`*^9, 3.5331535356615696`*^9}, 
   3.5331536017616625`*^9, {3.533221927890974*^9, 3.533221930830978*^9}, {
   3.533222264011444*^9, 3.533222283731472*^9}, {3.5332223304615374`*^9, 
   3.5332223353515444`*^9}, 3.5363501604045196`*^9, {3.536361767566806*^9, 
   3.5363617697768087`*^9}, {3.5363666287016163`*^9, 
   3.5363666313816195`*^9}, {3.536366784271834*^9, 3.5363667868618374`*^9}, {
   3.536366923782029*^9, 3.5363669254320316`*^9}, {3.5365968786057057`*^9, 
   3.536596881944112*^9}, {3.5366940930205193`*^9, 3.53669410440917*^9}, {
   3.5366942507975435`*^9, 3.536694251403578*^9}, {3.536694493325415*^9, 
   3.536694495295528*^9}, 3.536980387788585*^9, 3.536980543328803*^9, {
   3.536980609078895*^9, 3.536980616128905*^9}, {3.541649113828012*^9, 
   3.5416491983381305`*^9}, {3.541784911249734*^9, 3.5417849123597355`*^9}, {
   3.5417850837099752`*^9, 3.541785086039978*^9}, 3.541785407620428*^9, {
   3.5462979670942173`*^9, 3.5462979721642246`*^9}, {3.546300486527745*^9, 
   3.5463004893777485`*^9}, 3.54630054724783*^9, 3.54854416359853*^9, {
   3.5485444249588957`*^9, 3.548544427518899*^9}, 3.549036276090907*^9, {
   3.5490363163857775`*^9, 3.5490363204729843`*^9}, 3.549036657901577*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", "2"}], ")"}]}]}], ")"}]}], 
    "*", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m"}], ")"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"3", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalQ", "[", "m", "]"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "m", "<", "0"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.4983258972265496`*^9, 
   3.498327107991476*^9, {3.5144655337954865`*^9, 3.514465569098348*^9}, 
   3.514465744255456*^9, {3.5416469646850033`*^9, 3.5416469818250275`*^9}, 
   3.5416492697082305`*^9, {3.5416494755985184`*^9, 3.541649535918603*^9}, 
   3.541649648488761*^9, 3.5416496916688213`*^9, {3.541785098139995*^9, 
   3.5417850984799957`*^9}, 3.541785182770114*^9, 3.5417854688205137`*^9, 
   3.5462977398238993`*^9, {3.546297973554227*^9, 3.546297980984237*^9}, {
   3.5463004996277633`*^9, 3.5463005532478385`*^9}, {3.546300585177883*^9, 
   3.5463005906178904`*^9}, {3.546315104787699*^9, 3.546315106110775*^9}, {
   3.5472273633697147`*^9, 3.54722736743972*^9}, {3.5472662655699863`*^9, 
   3.547266266979988*^9}, 3.547918566054429*^9, {3.547918635926425*^9, 
   3.5479186411567245`*^9}, 3.5485289098501673`*^9, {3.5485377636975684`*^9, 
   3.548537774797584*^9}, 3.5485434454575243`*^9, {3.548544432458906*^9, 
   3.548544441878919*^9}, {3.5485517889250784`*^9, 3.54855179539909*^9}, 
   3.549036298336546*^9, {3.5490363292558002`*^9, 3.549036358225051*^9}, {
   3.549036409985942*^9, 3.549036443557201*^9}, {3.549036583926247*^9, 
   3.549036607591489*^9}, {3.549036679710416*^9, 3.5490366873076286`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "<", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.5192504337891226`*^9, 3.5192504436696877`*^9}, {3.519320736057986*^9, 
   3.5193207456364026`*^9}, {3.5193282921909866`*^9, 
   3.5193283252786446`*^9}, {3.5193283634207115`*^9, 
   3.5193283676639194`*^9}, {3.5193286295571795`*^9, 
   3.5193286611160345`*^9}, {3.519341560355774*^9, 3.5193415713849936`*^9}, {
   3.5193514022902384`*^9, 3.5193514024302387`*^9}, {3.5194037903190413`*^9, 
   3.519403790599057*^9}, 3.51941073361316*^9, 3.5196771044605494`*^9, {
   3.5233155369029784`*^9, 3.5233155369029784`*^9}, 3.5239204146855583`*^9, 
   3.5239297857543354`*^9, 3.5239298325544176`*^9, {3.5295294635000772`*^9, 
   3.5295294742328963`*^9}, 3.5415539341135683`*^9, 3.5417297751644244`*^9, {
   3.54173007448215*^9, 3.5417300747317505`*^9}, 3.541730224086413*^9, 
   3.541730374954278*^9, {3.5417304378691883`*^9, 3.541730451425612*^9}, {
   3.541730489255678*^9, 3.541730489255678*^9}, {3.541730871222349*^9, 
   3.5417308721895514`*^9}, {3.541786142211457*^9, 3.541786167181492*^9}, {
   3.54178700129666*^9, 3.54178700153666*^9}, {3.546297949904194*^9, 
   3.5462979503841944`*^9}, {3.5462982384845977`*^9, 3.5462982537846193`*^9}, 
   3.5472298538432016`*^9, 3.5472300094434195`*^9, {3.5472569260353203`*^9, 
   3.547256926195321*^9}, {3.547257237915757*^9, 3.5472572388857584`*^9}, {
   3.5472575306661673`*^9, 3.5472575346861725`*^9}, {3.547264079880925*^9, 
   3.547264086060934*^9}, {3.5479184923032103`*^9, 3.5479185073180695`*^9}, 
   3.5485441615885267`*^9, {3.5485443799888325`*^9, 3.5485443799888325`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.510.3, CRC 309", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.4983254541701717`*^9, 
   3.49834776104484*^9}],

Cell[TextData[{
 "Reference: G&R 2.552.3 special case when ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, 
   3.4976416712695007`*^9, {3.4979240714220977`*^9, 3.497924071656098*^9}, {
   3.498241383594393*^9, 3.4982413927744055`*^9}, {3.505354077065938*^9, 
   3.505354077695939*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.504471038210372*^9, 
   3.504471041430376*^9}, 3.504482107256355*^9, 3.504988537290719*^9, {
   3.5083553588354673`*^9, 3.5083553595954685`*^9}, {3.5099090689040384`*^9, 
   3.509909077577654*^9}, 3.510250354103923*^9, {3.510250514474148*^9, 
   3.5102505279141665`*^9}, {3.510254606139876*^9, 3.5102546080298786`*^9}, {
   3.51025471607003*^9, 3.510254716890031*^9}, {3.5102547498400774`*^9, 
   3.510254756550087*^9}, {3.510261384357441*^9, 3.510261385037442*^9}, {
   3.5104241170266523`*^9, 3.510424117466653*^9}, {3.5130947759106855`*^9, 
   3.5130947772210875`*^9}, 3.513097560521462*^9, {3.513099308343909*^9, 
   3.51309930918391*^9}, {3.5130995693542747`*^9, 3.5130995696342745`*^9}, 
   3.514149286590167*^9, 3.5150246165200367`*^9, {3.5417304750752535`*^9, 
   3.5417305016109*^9}, {3.541730873343953*^9, 3.5417308740147543`*^9}, {
   3.5417861698614955`*^9, 3.5417861698614955`*^9}, {3.5462979534141984`*^9, 
   3.5462979534141984`*^9}, {3.5472640934009438`*^9, 
   3.5472640934009438`*^9}, {3.547918510567255*^9, 3.547918510567255*^9}, {
   3.548544386028841*^9, 3.548544386028841*^9}}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"m", "+", "1"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "2"}], 
     RowBox[{"m", "+", "1"}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "+", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095014878340373`*^9, 3.5095014885516386`*^9}, {3.509501723296851*^9, 
   3.5095017455424905`*^9}, {3.510167018471958*^9, 3.5101670221519637`*^9}, {
   3.510167325332388*^9, 3.5101673371024046`*^9}, {3.5102509934548187`*^9, 
   3.5102511286150074`*^9}, {3.5102512230551395`*^9, 
   3.5102512252151427`*^9}, {3.510251266585201*^9, 3.510251502655531*^9}, {
   3.510251603195672*^9, 3.510251604205673*^9}, {3.5102519162461104`*^9, 
   3.5102519201161156`*^9}, {3.5102520180262527`*^9, 3.510252061526314*^9}, {
   3.510253854598824*^9, 3.510253940268944*^9}, {3.510253978068997*^9, 
   3.510254075089133*^9}, {3.515167407833377*^9, 3.515167419883394*^9}, 
   3.5417306986704464`*^9, {3.5417307349873104`*^9, 3.5417308059362345`*^9}, {
   3.5462979542341995`*^9, 3.546297956594203*^9}, {3.5472298547232027`*^9, 
   3.547229859333209*^9}, {3.547230016453429*^9, 3.5472300182234316`*^9}, 
   3.5485441621985273`*^9, {3.5485443943488526`*^9, 3.548544398908859*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", "2"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, {3.4979216146205826`*^9, 
   3.4979216448378353`*^9}, 3.4979240644956856`*^9, {3.5067063135225325`*^9, 
   3.5067063148344193`*^9}, {3.5144641832699137`*^9, 
   3.5144642240483856`*^9}, {3.514465597022397*^9, 3.5144656097052193`*^9}, {
   3.541730525494542*^9, 3.541730546648179*^9}, {3.5417306032138786`*^9, 
   3.5417306203427086`*^9}, 3.546297735933894*^9, {3.546297957514204*^9, 
   3.5462979612042093`*^9}, {3.546301464039113*^9, 3.5463014664891167`*^9}, {
   3.547229860643211*^9, 3.54722986711322*^9}, {3.5472300233634386`*^9, 
   3.5472300270434437`*^9}, {3.547257186275685*^9, 3.5472571995957036`*^9}, {
   3.5472641029309573`*^9, 3.5472641122909703`*^9}, 3.547918513430419*^9, {
   3.5485444042388663`*^9, 3.5485444184288864`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["2.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.546297406753433*^9, 
   3.5462974070434337`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", ">", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, 3.5485441477885075`*^9, {
   3.548544198208578*^9, 3.548544198208578*^9}, {3.549036967655721*^9, 
   3.5490369727569304`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"0", "<", "n", "<", "1"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, 3.5485441477885075`*^9, {
   3.548544198208578*^9, 3.548544198208578*^9}, {3.549036967655721*^9, 
   3.5490369727569304`*^9}, {3.54903826028119*^9, 3.5490382662716007`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.5454973483879595`*^9, 
   3.545506097840209*^9, 3.5455157193990145`*^9, 3.5462951690403004`*^9, {
   3.5462964020120263`*^9, 3.5462964133720427`*^9}, 3.5462966455623674`*^9, {
   3.5472311188349724`*^9, 3.54723116715504*^9}, {3.5472318015599303`*^9, 
   3.5472318067199373`*^9}, 3.5472661069697638`*^9, {3.547266198189892*^9, 
   3.5472661985598927`*^9}, 3.54726636822013*^9, {3.5490369892461596`*^9, 
   3.5490370099629955`*^9}, {3.549038210860303*^9, 3.5490382178023157`*^9}, 
   3.5490382683932047`*^9, {3.549038336892925*^9, 3.5490383372673254`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"f", "[", "x", "]"}]}]], 
     SqrtBox[
      RowBox[{"f", "[", "x", "]"}]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 
   3.5118050348148956`*^9}, {3.5462953719105844`*^9, 
   3.5462953727405853`*^9}, {3.546295419610651*^9, 3.546295448940692*^9}, {
   3.546296444592086*^9, 3.5462964544221*^9}, {3.547231239455141*^9, 
   3.5472312497351556`*^9}, {3.548960814469925*^9, 3.5489608182295313`*^9}, {
   3.5490371289288044`*^9, 3.5490371330004115`*^9}, {3.549038317814091*^9, 
   3.549038324334903*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 
   3.5473171298465743`*^9}, {3.548551779580662*^9, 3.548551779580662*^9}, {
   3.549036451185614*^9, 3.549036451185614*^9}, {3.5490372839462767`*^9, 
   3.5490372839462767`*^9}, 3.5490383335545187`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"b", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]], 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}, 3.541101803256009*^9, {3.541115802450629*^9, 
   3.541115829936912*^9}, {3.5411170533806067`*^9, 3.541117065630624*^9}, {
   3.546296428072063*^9, 3.546296438832078*^9}, {3.546296483582141*^9, 
   3.5462964919121523`*^9}, {3.547231194825079*^9, 3.547231229775128*^9}, {
   3.5489607970914946`*^9, 3.5489608045015078`*^9}, 3.5490370965899477`*^9, {
   3.549038294772851*^9, 3.5490383061608706`*^9}, 3.549038479071574*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"b_", "*", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"b", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9, {
   3.5410976974308376`*^9, 3.5410977100668592`*^9}, {3.5411018263752494`*^9, 
   3.5411018402280736`*^9}, {3.541116030157608*^9, 3.541116035122864*^9}, {
   3.541117072180633*^9, 3.5411170753206377`*^9}, {3.5450643579287167`*^9, 
   3.5450643666987286`*^9}, {3.5450644187188015`*^9, 
   3.5450644238188086`*^9}, {3.5462953176805086`*^9, 3.546295320140512*^9}, {
   3.5462965514222355`*^9, 3.546296585122283*^9}, 3.5462967357824936`*^9, {
   3.547231380239341*^9, 3.5472314258094044`*^9}, 3.5472318122599454`*^9, {
   3.547232641271106*^9, 3.547232662001135*^9}, 3.5472663892101593`*^9, {
   3.548960903733282*^9, 3.5489609235453167`*^9}, {3.5490370623946877`*^9, 
   3.549037068821899*^9}, {3.5490371531556473`*^9, 3.5490371568216534`*^9}, 
   3.549037493985046*^9, {3.549037853494876*^9, 3.549037854228077*^9}, {
   3.549038345223339*^9, 3.5490383875150137`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"0", "<", "n", "<", "1"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", 
        FractionBox["1", "2"]}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.5454973483879595`*^9, 
   3.545506097840209*^9, 3.5455157193990145`*^9, 3.5462951690403004`*^9, {
   3.5462964020120263`*^9, 3.5462964133720427`*^9}, 3.5462966455623674`*^9, {
   3.5472311188349724`*^9, 3.54723116715504*^9}, {3.5472318015599303`*^9, 
   3.5472318067199373`*^9}, 3.5472661069697638`*^9, {3.547266198189892*^9, 
   3.5472661985598927`*^9}, 3.54726636822013*^9, {3.5490369892461596`*^9, 
   3.5490370099629955`*^9}, {3.5490382710296087`*^9, 3.549038273276013*^9}, {
   3.5514804900271106`*^9, 3.551480520693865*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "x", "]"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     SuperscriptBox[
      RowBox[{"f", "[", "x", "]"}], 
      RowBox[{"n", "-", "1"}]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 
   3.5118050348148956`*^9}, {3.5462953719105844`*^9, 
   3.5462953727405853`*^9}, {3.546295419610651*^9, 3.546295448940692*^9}, {
   3.546296444592086*^9, 3.5462964544221*^9}, {3.547231239455141*^9, 
   3.5472312497351556`*^9}, {3.548960814469925*^9, 3.5489608182295313`*^9}, {
   3.5490371289288044`*^9, 3.5490371330004115`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"0", "<", "n", "<", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    FractionBox["1", "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 
   3.5473171298465743`*^9}, {3.548551779580662*^9, 3.548551779580662*^9}, {
   3.549036451185614*^9, 3.549036451185614*^9}, {3.5490372839462767`*^9, 
   3.5490372839462767`*^9}, {3.551480526611203*^9, 3.551480526611203*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"b", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
        RowBox[{"n", "-", "1"}]]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "-", "1"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}, 3.541101803256009*^9, {3.541115802450629*^9, 
   3.541115829936912*^9}, {3.5411170533806067`*^9, 3.541117065630624*^9}, {
   3.546296428072063*^9, 3.546296438832078*^9}, {3.546296483582141*^9, 
   3.5462964919121523`*^9}, {3.547231194825079*^9, 3.547231229775128*^9}, {
   3.5489607970914946`*^9, 3.5489608045015078`*^9}, 3.5490370965899477`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"b", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "/", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9, {
   3.5410976974308376`*^9, 3.5410977100668592`*^9}, {3.5411018263752494`*^9, 
   3.5411018402280736`*^9}, {3.541116030157608*^9, 3.541116035122864*^9}, {
   3.541117072180633*^9, 3.5411170753206377`*^9}, {3.5450643579287167`*^9, 
   3.5450643666987286`*^9}, {3.5450644187188015`*^9, 
   3.5450644238188086`*^9}, {3.5462953176805086`*^9, 3.546295320140512*^9}, {
   3.5462965514222355`*^9, 3.546296585122283*^9}, 3.5462967357824936`*^9, {
   3.547231380239341*^9, 3.5472314258094044`*^9}, 3.5472318122599454`*^9, {
   3.547232641271106*^9, 3.547232662001135*^9}, 3.5472663892101593`*^9, {
   3.548960903733282*^9, 3.5489609235453167`*^9}, {3.5490370623946877`*^9, 
   3.549037068821899*^9}, {3.5490371531556473`*^9, 3.5490371568216534`*^9}, 
   3.549037493985046*^9, {3.549037853494876*^9, 3.549037854228077*^9}, {
   3.549054466100546*^9, 3.5490544663405466`*^9}, {3.5514805373698187`*^9, 
   3.551480544726239*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", ">", "1"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, 3.5450638651180267`*^9, {
   3.545064163248444*^9, 3.5450641908184824`*^9}, 3.5450645478389826`*^9, {
   3.5450649786895857`*^9, 3.545064986639597*^9}, {3.545066031121059*^9, 
   3.5450660335610623`*^9}, 3.5454973526179657`*^9, {3.545503990667259*^9, 
   3.5455039981972694`*^9}, 3.5455052729790545`*^9, 3.545505442339291*^9, {
   3.5455064354906816`*^9, 3.5455064379106855`*^9}, 3.545515726821439*^9, {
   3.545600330501642*^9, 3.5456003429616594`*^9}, {3.5456041289679403`*^9, 
   3.545604130941053*^9}, 3.5462956733410063`*^9, {3.5462968199126115`*^9, 
   3.5462968219026146`*^9}, {3.547266164689845*^9, 3.5472661774998627`*^9}, {
   3.5490369768753376`*^9, 3.5490369787785406`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 3 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "b"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.514253181887664*^9, {3.5455040345073204`*^9, 3.5455040366873236`*^9}, {
   3.545504158357494*^9, 3.545504246227617*^9}, {3.545505035248721*^9, 
   3.5455051376488647`*^9}, {3.5456005712019787`*^9, 
   3.5456005712019787`*^9}, {3.5480100113402867`*^9, 3.548010012360288*^9}, {
   3.548010302450694*^9, 3.548010302870695*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, 
   3.5142558168413525`*^9, {3.514598142866644*^9, 3.5145981469766493`*^9}, {
   3.5145981919067125`*^9, 3.5145981930867143`*^9}, {3.5146368879674587`*^9, 
   3.514636892241866*^9}, {3.5455039784272423`*^9, 3.545503983537249*^9}, {
   3.5456004709418383`*^9, 3.5456004717118397`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5142257979137073`*^9, 3.5142258077261243`*^9}, {
   3.5142526409569063`*^9, 3.5142526458869133`*^9}, {3.5142558354813786`*^9, 
   3.514255880171441*^9}, {3.5145980839965615`*^9, 3.5145980911865716`*^9}, {
   3.514636932599137*^9, 3.514636936046743*^9}, {3.515167673643749*^9, 
   3.515167683553763*^9}, {3.5455038508570633`*^9, 3.545503915727154*^9}, 
   3.545503966837226*^9, {3.54560049336187*^9, 3.545600523871913*^9}, {
   3.5456006112720346`*^9, 3.545600611502035*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}], "/", "n"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, 3.4975831484616003`*^9, 3.4975832895717974`*^9, {
   3.4979216146049824`*^9, 3.4979216448222356`*^9}, 3.4979236654001846`*^9, {
   3.4981987086091685`*^9, 3.4981987164091825`*^9}, {3.4981987562360525`*^9, 
   3.498198756563653*^9}, {3.4982411011539974`*^9, 3.498241103034*^9}, {
   3.5017330383946285`*^9, 3.501733038800229*^9}, {3.501733070701085*^9, 
   3.501733075100292*^9}, {3.5031145982909107`*^9, 3.5031146095385303`*^9}, {
   3.503883100784115*^9, 3.5038831023441176`*^9}, {3.5043676148075085`*^9, 
   3.504367618347513*^9}, 3.5053446400637827`*^9, {3.505344689333851*^9, 
   3.5053447136938853`*^9}, 3.5053456710052257`*^9, 3.508439032390652*^9, {
   3.509847523238981*^9, 3.5098475246289825`*^9}, 3.511459116976429*^9, 
   3.511805548999618*^9, {3.5120532760509987`*^9, 3.512053278951003*^9}, 
   3.512054082220134*^9, {3.5134422284957695`*^9, 3.5134422298957715`*^9}, {
   3.5141356760929937`*^9, 3.5141356805234013`*^9}, {3.514137621831835*^9, 
   3.514137631141848*^9}, {3.514147337857438*^9, 3.5141473571874657`*^9}, {
   3.514152750191185*^9, 3.5141527505311856`*^9}, 3.514177998879638*^9, 
   3.514583249914508*^9, 3.5146451165524626`*^9, 3.541090446501709*^9, 
   3.5410905255090475`*^9, 3.541090623071619*^9, {3.541090860660036*^9, 
   3.541090861689638*^9}, {3.5454912109410563`*^9, 3.5454912109510565`*^9}, {
   3.5455038224470234`*^9, 3.5455038387370462`*^9}, {3.5456005874820013`*^9, 
   3.545600622562051*^9}, 3.5456006541320953`*^9, 3.5456008731224017`*^9, 
   3.5462955775908723`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, 3.5485441477885075`*^9, {
   3.548544198208578*^9, 3.548544198208578*^9}, {3.549036967655721*^9, 
   3.5490369727569304`*^9}, {3.549037200798131*^9, 3.549037204261337*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"0", "<", "n", "<", "1"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462968426126432`*^9, 
   3.5462968519326563`*^9}, 3.546297534403612*^9, 3.5485441477885075`*^9, {
   3.548544198208578*^9, 3.548544198208578*^9}, {3.549036967655721*^9, 
   3.5490369727569304`*^9}, {3.54903826028119*^9, 3.5490382662716007`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.5454973483879595`*^9, 
   3.545506097840209*^9, 3.5455157193990145`*^9, 3.5462951690403004`*^9, {
   3.5462964020120263`*^9, 3.5462964133720427`*^9}, 3.5462966455623674`*^9, {
   3.5472311188349724`*^9, 3.54723116715504*^9}, {3.5472318015599303`*^9, 
   3.5472318067199373`*^9}, 3.5472661069697638`*^9, {3.547266198189892*^9, 
   3.5472661985598927`*^9}, 3.54726636822013*^9, {3.5490369892461596`*^9, 
   3.5490370099629955`*^9}, {3.549038210860303*^9, 3.5490382178023157`*^9}, 
   3.5490382683932047`*^9, {3.549038336892925*^9, 3.5490383372673254`*^9}, {
   3.5490384500711236`*^9, 3.5490384579335375`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"f", "[", "x", "]"}]], 
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"f", "[", "x", "]"}]}]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 
   3.5118050348148956`*^9}, {3.5462953719105844`*^9, 
   3.5462953727405853`*^9}, {3.546295419610651*^9, 3.546295448940692*^9}, {
   3.546296444592086*^9, 3.5462964544221*^9}, {3.547231239455141*^9, 
   3.5472312497351556`*^9}, {3.548960814469925*^9, 3.5489608182295313`*^9}, {
   3.5490371289288044`*^9, 3.5490371330004115`*^9}, {3.549038317814091*^9, 
   3.549038324334903*^9}, {3.549038536464075*^9, 3.5490385403640823`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 
   3.5473171298465743`*^9}, {3.548551779580662*^9, 3.548551779580662*^9}, {
   3.549036451185614*^9, 3.549036451185614*^9}, {3.5490372839462767`*^9, 
   3.5490372839462767`*^9}, 3.5490383335545187`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}, 3.541101803256009*^9, {3.541115802450629*^9, 
   3.541115829936912*^9}, {3.5411170533806067`*^9, 3.541117065630624*^9}, {
   3.546296428072063*^9, 3.546296438832078*^9}, {3.546296483582141*^9, 
   3.5462964919121523`*^9}, {3.547231194825079*^9, 3.547231229775128*^9}, {
   3.5489607970914946`*^9, 3.5489608045015078`*^9}, 3.5490370965899477`*^9, {
   3.549038294772851*^9, 3.5490383061608706`*^9}, {3.5490385030332165`*^9, 
   3.549038526277257*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"b_", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"b", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", "x"}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9, {
   3.5410976974308376`*^9, 3.5410977100668592`*^9}, {3.5411018263752494`*^9, 
   3.5411018402280736`*^9}, {3.541116030157608*^9, 3.541116035122864*^9}, {
   3.541117072180633*^9, 3.5411170753206377`*^9}, {3.5450643579287167`*^9, 
   3.5450643666987286`*^9}, {3.5450644187188015`*^9, 
   3.5450644238188086`*^9}, {3.5462953176805086`*^9, 3.546295320140512*^9}, {
   3.5462965514222355`*^9, 3.546296585122283*^9}, 3.5462967357824936`*^9, {
   3.547231380239341*^9, 3.5472314258094044`*^9}, 3.5472318122599454`*^9, {
   3.547232641271106*^9, 3.547232662001135*^9}, 3.5472663892101593`*^9, {
   3.548960903733282*^9, 3.5489609235453167`*^9}, {3.5490370623946877`*^9, 
   3.549037068821899*^9}, {3.5490371531556473`*^9, 3.5490371568216534`*^9}, 
   3.549037493985046*^9, {3.549037853494876*^9, 3.549037854228077*^9}, {
   3.549038345223339*^9, 3.5490383875150137`*^9}, {3.549038553390105*^9, 
   3.5490385639045234`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.5454973483879595`*^9, 
   3.545506097840209*^9, 3.5455157193990145`*^9, 3.5462951690403004`*^9, {
   3.5462964020120263`*^9, 3.5462964133720427`*^9}, 3.5462966455623674`*^9, {
   3.5472311188349724`*^9, 3.54723116715504*^9}, {3.5472318015599303`*^9, 
   3.5472318067199373`*^9}, 3.5472661069697638`*^9, {3.547266198189892*^9, 
   3.5472661985598927`*^9}, 3.54726636822013*^9, {3.5490369892461596`*^9, 
   3.5490370099629955`*^9}, {3.5490372273961773`*^9, 3.549037230640983*^9}, {
   3.5490384245026784`*^9, 3.5490384257974806`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "x", "]"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     SuperscriptBox[
      RowBox[{"f", "[", "x", "]"}], 
      RowBox[{"n", "-", "1"}]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 
   3.5118050348148956`*^9}, {3.5462953719105844`*^9, 
   3.5462953727405853`*^9}, {3.546295419610651*^9, 3.546295448940692*^9}, {
   3.546296444592086*^9, 3.5462964544221*^9}, {3.547231239455141*^9, 
   3.5472312497351556`*^9}, {3.548960814469925*^9, 3.5489608182295313`*^9}, {
   3.5490371289288044`*^9, 3.5490371330004115`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "<", "n", "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 
   3.5473171298465743`*^9}, {3.548551779580662*^9, 3.548551779580662*^9}, {
   3.549036451185614*^9, 3.549036451185614*^9}, {3.5490372839462767`*^9, 
   3.5490373045851135`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"n", "+", "1"}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}, 3.541101803256009*^9, {3.541115802450629*^9, 
   3.541115829936912*^9}, {3.5411170533806067`*^9, 3.541117065630624*^9}, {
   3.546296428072063*^9, 3.546296438832078*^9}, {3.546296483582141*^9, 
   3.5462964919121523`*^9}, {3.547231194825079*^9, 3.547231229775128*^9}, {
   3.5489607970914946`*^9, 3.5489608045015078`*^9}, 3.5490370965899477`*^9, {
   3.549037438292948*^9, 3.549037447964965*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalQ", "[", "n", "]"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<", "n", "<", "0"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9, {
   3.5410976974308376`*^9, 3.5410977100668592`*^9}, {3.5411018263752494`*^9, 
   3.5411018402280736`*^9}, {3.541116030157608*^9, 3.541116035122864*^9}, {
   3.541117072180633*^9, 3.5411170753206377`*^9}, {3.5450643579287167`*^9, 
   3.5450643666987286`*^9}, {3.5450644187188015`*^9, 
   3.5450644238188086`*^9}, {3.5462953176805086`*^9, 3.546295320140512*^9}, {
   3.5462965514222355`*^9, 3.546296585122283*^9}, 3.5462967357824936`*^9, {
   3.547231380239341*^9, 3.5472314258094044`*^9}, 3.5472318122599454`*^9, {
   3.547232641271106*^9, 3.547232662001135*^9}, 3.5472663892101593`*^9, {
   3.548960903733282*^9, 3.5489609235453167`*^9}, {3.5490370623946877`*^9, 
   3.549037068821899*^9}, {3.5490371531556473`*^9, 3.5490371568216534`*^9}, {
   3.5490373124787273`*^9, 3.5490373353327675`*^9}, {3.5490374665445976`*^9, 
   3.5490374714430065`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, 
   3.545496835607242*^9, {3.545505444879295*^9, 3.545505445119295*^9}, {
   3.545505639229567*^9, 3.5455056444395742`*^9}, {3.5455068311112356`*^9, 
   3.5455068403012486`*^9}, {3.5455157795484548`*^9, 3.545515785354787*^9}, {
   3.5456041640039434`*^9, 3.5456041642679586`*^9}, {3.5456043654454656`*^9, 
   3.54560436639952*^9}, 3.5462962197317715`*^9, {3.546296928652764*^9, 
   3.5462969303927665`*^9}, 3.5472661680398493`*^9, 3.549037208036544*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.552.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, 
   3.4976416712695007`*^9, 3.497641808362542*^9, 3.49764211453668*^9, {
   3.497924167175066*^9, 3.4979241674870663`*^9}, {3.5053542426761694`*^9, 
   3.50535424295617*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 1 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.502990148351678*^9, 3.5029901655429077`*^9}, 
   3.505345087524409*^9, 3.512064342062512*^9, {3.5454307013060207`*^9, 
   3.545430711346035*^9}, {3.54550558430949*^9, 3.5455056165795355`*^9}, {
   3.545604344880289*^9, 3.5456043540838156`*^9}, {3.5480100196202984`*^9, 
   3.5480100207602997`*^9}, {3.548010304980698*^9, 3.5480103053506985`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.497641822620967*^9, 
   3.4976418815034714`*^9}, {3.498241427414454*^9, 3.498241427414454*^9}, {
   3.504395896295714*^9, 3.50439590067572*^9}, 3.5044706093797717`*^9, 
   3.5044710537703934`*^9, {3.5044821550764217`*^9, 3.504482155386422*^9}, {
   3.504988576070773*^9, 3.5049885764507737`*^9}, {3.506213896034247*^9, 
   3.5062138967830486`*^9}, {3.5062141332678576`*^9, 
   3.5062141507378817`*^9}, {3.5105084879028864`*^9, 3.510508488090087*^9}, {
   3.5130944226480646`*^9, 3.5130944467345066`*^9}, 3.51309510891803*^9, 
   3.514147239737301*^9, {3.514487372506321*^9, 3.5144873727363214`*^9}, {
   3.5165576820821433`*^9, 3.5165576820821433`*^9}, {3.5165582083062663`*^9, 
   3.5165582086338673`*^9}, 3.5165908254196434`*^9, {3.5454161012016726`*^9, 
   3.5454161012016726`*^9}, {3.545430104665186*^9, 3.545430105025186*^9}, {
   3.545505660519597*^9, 3.545505660519597*^9}, {3.5456043699197216`*^9, 
   3.5456043707737703`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], 
    RowBox[{
     SuperscriptBox["b", "2"], 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.509829149023255*^9, 3.5098292074833364`*^9}, {
   3.510174642911626*^9, 3.51017464554803*^9}, {3.5101749019344807`*^9, 
   3.5101749115128975`*^9}, {3.5151682059644947`*^9, 
   3.5151682096244993`*^9}, {3.5165572858550477`*^9, 
   3.5165572982414694`*^9}, {3.5165573471007557`*^9, 3.51655734967476*^9}, {
   3.5165574453897276`*^9, 3.5165574940930133`*^9}, {3.516557561453932*^9, 
   3.5165575717343493`*^9}, {3.516557624244042*^9, 3.5165576267244463`*^9}, {
   3.545505496799368*^9, 3.545505530739415*^9}, {3.5456041761706395`*^9, 
   3.5456043045279813`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, 3.5114592311065884`*^9, 3.5118056919098177`*^9, 
   3.5141779771176*^9, 3.5145876116205716`*^9, 3.516558062505211*^9, 
   3.541090517116233*^9, 3.541090638890046*^9, {3.541090866307246*^9, 
   3.5410908672432475`*^9}, {3.54109091423053*^9, 3.541090921406543*^9}, {
   3.545491210931056*^9, 3.545491210931056*^9}, {3.545505469249329*^9, 
   3.54550547733934*^9}, {3.545505677859621*^9, 3.5455056788096223`*^9}, {
   3.5456043833954926`*^9, 3.545604453043476*^9}, 3.546295577650872*^9, 
   3.5462968894727087`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["3.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, 3.5462961408916607`*^9, {3.5462973285533237`*^9, 
   3.5462973314333277`*^9}, {3.5462974099434376`*^9, 3.546297410253438*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", ">", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, 
   3.5450660285410557`*^9, {3.5450660990311537`*^9, 3.5450661016011577`*^9}, {
   3.545066337891488*^9, 3.545066338141489*^9}, 3.545497351757964*^9, 
   3.545505795729786*^9, {3.5455059918600607`*^9, 3.5455059920500607`*^9}, {
   3.5455158779400826`*^9, 3.5455158779400826`*^9}, {3.5462949534499984`*^9, 
   3.5462949534499984`*^9}, {3.546295608680916*^9, 3.546295608880916*^9}, {
   3.5462973341233315`*^9, 3.546297336803335*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, {
   3.5450663330114813`*^9, 3.545066333181482*^9}, 3.5454973467679577`*^9, 
   3.5455060996602116`*^9, {3.545506368460588*^9, 3.5455063686605883`*^9}, {
   3.5455156688931255`*^9, 3.5455156932105165`*^9}, {3.5456041264867983`*^9, 
   3.5456041270568304`*^9}, 3.5462951666302967`*^9, {3.5462955433508244`*^9, 
   3.5462955475408306`*^9}, 3.546295672131005*^9, {3.546297343073344*^9, 
   3.54629735472336*^9}, {3.5500031247437434`*^9, 3.550003124945755*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, 
   3.5450645300089574`*^9, 3.545064588069039*^9, 3.5454973476679587`*^9, 
   3.54550609866021*^9, 3.545515717353897*^9, {3.5462951934803343`*^9, 
   3.5462951934803343`*^9}, {3.54629524743041*^9, 3.54629524743041*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   FractionBox["1", "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 
   3.5017335953768063`*^9}, {3.501733875319298*^9, 3.501733886769718*^9}, 
   3.5087868231739407`*^9, {3.513883533542144*^9, 3.5138835815022106`*^9}, {
   3.5138844630034447`*^9, 3.5138844634634457`*^9}, {3.5480100515403433`*^9, 
   3.5480100524403443`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4982407708135347`*^9, 3.4982407708135347`*^9}, {3.504588159968884*^9, 
   3.5045881608888855`*^9}, {3.5045900936916113`*^9, 3.504590093951612*^9}, {
   3.5136154813728604`*^9, 3.513615482761263*^9}, {3.546295202420347*^9, 
   3.5462952029403477`*^9}, {3.5462952405704*^9, 3.546295241780402*^9}, 
   3.5462965156621857`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], 
            "]"}]}]}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.497921614589382*^9, 
   3.497921644806636*^9}, 3.4979225240085793`*^9, {3.505355146147434*^9, 
   3.5053551625874577`*^9}, 3.5053551976475067`*^9, 3.505362928562543*^9, {
   3.513379464725625*^9, 3.5133794651656256`*^9}, 3.5151818333396654`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", "b", "*", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497922520046173*^9, {
   3.5053551461574345`*^9, 3.505355162597458*^9}, 3.505355197657507*^9, 
   3.50536293377255*^9, 3.513379506135683*^9, 3.541088902624998*^9, 
   3.5410889380058603`*^9, 3.5462952110303593`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, {
   3.5450663330114813`*^9, 3.545066333181482*^9}, 3.5454973467679577`*^9, 
   3.5455060996602116`*^9, {3.545506368460588*^9, 3.5455063686605883`*^9}, {
   3.5455156688931255`*^9, 3.5455156932105165`*^9}, {3.5456041264867983`*^9, 
   3.5456041270568304`*^9}, 3.5462951666302967`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"a", "+", "b"}], ">", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, 
   3.5450645300089574`*^9, 3.545064588069039*^9, 3.5454973476679587`*^9, 
   3.54550609866021*^9, 3.545515717353897*^9, 3.546295167980299*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"EllipticE", "[", 
     RowBox[{"z", ",", "n"}], "]"}]}], "=", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"n", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "2"]}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "2"]}]}], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{"a", "+", "b"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, {3.509893685281507*^9, 3.509893685281507*^9}, {
   3.5151263553521*^9, 3.5151263553521*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4982408115335917`*^9, 
   3.4982408115335917`*^9}, {3.504396309416292*^9, 3.5043963109862947`*^9}, {
   3.504413193550866*^9, 3.5044131942308674`*^9}, {3.5044133130510335`*^9, 
   3.504413313411034*^9}, {3.508348841306343*^9, 3.508348842436345*^9}, {
   3.513095047017943*^9, 3.5130950482379446`*^9}, {3.513377117822339*^9, 
   3.51337711822234*^9}, {3.514597917336328*^9, 3.5145979175763283`*^9}, {
   3.5145980146964645`*^9, 3.5145980151564655`*^9}, {3.5151812744218836`*^9, 
   3.5151812752174854`*^9}, {3.5450645020089183`*^9, 3.545064502608919*^9}, 
   3.5462965065121727`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"a", "+", "b"}]]}], "d"]}]}]}], 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4979216297526093`*^9, 3.497922801283467*^9, 
   3.500665297613958*^9, 3.505344687833849*^9, 3.505346451676318*^9, 
   3.5098471638084774`*^9, {3.5098934921012363`*^9, 3.50989350168125*^9}, {
   3.509893619231415*^9, 3.5098936260614243`*^9}, 3.5098937648316183`*^9, {
   3.5151262912359877`*^9, 3.515126312561225*^9}, 3.5151675961336403`*^9, {
   3.515711026402997*^9, 3.515711035997014*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"Pi", "/", "2"}], "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "/", "d"}], "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", 
      RowBox[{"2", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4979216297526093`*^9, 
   3.4979227505677776`*^9, {3.503114419966997*^9, 3.503114433570221*^9}, 
   3.505344687843849*^9, 3.505346458346328*^9, 3.505409319744323*^9, 
   3.5074317977549033`*^9, 3.50984716543848*^9, 3.5098939458618717`*^9, 
   3.5118053855293894`*^9, 3.5141774554954824`*^9, {3.5151261677929707`*^9, 
   3.515126186778204*^9}, {3.5156892546264534`*^9, 3.5156892662864695`*^9}, {
   3.5410967919740477`*^9, 3.5410968164348907`*^9}, 3.541096872470189*^9, {
   3.545064286118616*^9, 3.5450642902186213`*^9}, 3.5450653886701593`*^9, {
   3.5467379647819986`*^9, 3.546737972441437*^9}, 3.5473431884010725`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "/", "d"}], "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Pi", "/", "4"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"2", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4979216297526093`*^9, 
   3.4979227505677776`*^9, {3.503114419966997*^9, 3.503114433570221*^9}, 
   3.505344687843849*^9, 3.505346458346328*^9, 3.505409319744323*^9, 
   3.5074317977549033`*^9, 3.50984716543848*^9, 3.5098939458618717`*^9, 
   3.5118053855293894`*^9, 3.5141774554954824`*^9, {3.5151262434531035`*^9, 
   3.5151262526259193`*^9}, {3.5156892571864567`*^9, 
   3.5156892634864655`*^9}, {3.5157110412230234`*^9, 3.515711048617436*^9}, {
   3.541096819882497*^9, 3.541096862642172*^9}, {3.5450642748886003`*^9, 
   3.5450642756486015`*^9}, 3.5450653840801535`*^9, {3.5462952954604774`*^9, 
   3.546295295930478*^9}, 3.546297200653145*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "+", "b"}], ">", "0"}], ")"}]}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.5454973483879595`*^9, 
   3.545506097840209*^9, 3.5455157193990145`*^9, 3.5462951690403004`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "x", "]"}]}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"f", "[", "x", "]"}]}]}], 
       RowBox[{"a", "+", "b"}]]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 
   3.5118050348148956`*^9}, {3.5462953719105844`*^9, 
   3.5462953727405853`*^9}, {3.546295419610651*^9, 3.546295448940692*^9}}],

Cell[TextData[{
 "Note: Since ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox["b", 
     RowBox[{"a", "+", "b"}]]}], "\[Equal]", "1", ">", "0"}]]],
 ", the above rule applies to the resulting integrand."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.497582428440592*^9, 
   3.4975824695406494`*^9}, 3.4975829172612762`*^9, 3.4979216297682095`*^9, {
   3.497923045626696*^9, 3.4979230482631006`*^9}, {3.5067957598589277`*^9, 
   3.5067957686215277`*^9}, {3.5141774305510387`*^9, 
   3.5141774314090405`*^9}, {3.515025759901434*^9, 3.515025766066787*^9}, {
   3.5151944538143406`*^9, 3.515194454914342*^9}, {3.546295338580538*^9, 
   3.54629536882058*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4982408276436143`*^9, 
   3.4982408276436143`*^9}, {3.504396314346299*^9, 3.504396315826301*^9}, {
   3.504413197760872*^9, 3.504413198360873*^9}, {3.5044133170010395`*^9, 
   3.5044133173010397`*^9}, {3.5083488469763513`*^9, 
   3.5083488473063517`*^9}, {3.513095050507948*^9, 3.5130950522779503`*^9}, {
   3.513377121572345*^9, 3.5133771223323455`*^9}, {3.5145979213763337`*^9, 
   3.5145979216063337`*^9}, {3.5145980193364706`*^9, 
   3.5145980195364714`*^9}, {3.5151812787898912`*^9, 
   3.5151812795542927`*^9}, {3.5450644968489113`*^9, 3.545064497488912*^9}, 
   3.546296510982179*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
        RowBox[{"a", "+", "b"}]]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["a", 
        RowBox[{"a", "+", "b"}]], "+", 
       RowBox[{
        FractionBox["b", 
         RowBox[{"a", "+", "b"}]], 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}, 3.541101803256009*^9, {3.541115802450629*^9, 
   3.541115829936912*^9}, {3.5411170533806067`*^9, 3.541117065630624*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"b", "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9, {
   3.5410976974308376`*^9, 3.5410977100668592`*^9}, {3.5411018263752494`*^9, 
   3.5411018402280736`*^9}, {3.541116030157608*^9, 3.541116035122864*^9}, {
   3.541117072180633*^9, 3.5411170753206377`*^9}, {3.5450643579287167`*^9, 
   3.5450643666987286`*^9}, {3.5450644187188015`*^9, 
   3.5450644238188086`*^9}, {3.5462953176805086`*^9, 3.546295320140512*^9}, 
   3.54629632595192*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", ">", "1"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, 
   3.5450660285410557`*^9, {3.5450660990311537`*^9, 3.5450661016011577`*^9}, {
   3.545066337891488*^9, 3.545066338141489*^9}, 3.545497351757964*^9, 
   3.545505795729786*^9, {3.5455059918600607`*^9, 3.5455059920500607`*^9}, {
   3.5455158779400826`*^9, 3.5455158779400826`*^9}, {3.5462949534499984`*^9, 
   3.5462949534499984`*^9}, {3.5462949860700445`*^9, 
   3.5462949906100507`*^9}, {3.546295614880924*^9, 3.546295615080925*^9}, {
   3.5462973612333694`*^9, 3.5462973695733814`*^9}, {3.5462994976863604`*^9, 
   3.546299523796397*^9}, {3.546300239397399*^9, 3.546300240897401*^9}, {
   3.546300301207485*^9, 3.5463003047474904`*^9}, {3.550003126381837*^9, 
   3.550003155499502*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, 3.5450638651180267`*^9, {
   3.545064163248444*^9, 3.5450641908184824`*^9}, 3.5450645478389826`*^9, {
   3.5450663314814796`*^9, 3.5450663316414795`*^9}, 3.5454973458879566`*^9, 
   3.5455060521401453`*^9, {3.545506115790234*^9, 3.5455061198002396`*^9}, {
   3.5455063983806295`*^9, 3.545506431110676*^9}, 3.5455157244893055`*^9, 
   3.545604122578574*^9, 3.546295670321002*^9, 3.54629734027334*^9, 
   3.5500031338762655`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 12 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, {3.5102680075767136`*^9, 3.510268048246771*^9}, {
   3.510286142802781*^9, 3.5102861557352037`*^9}, {3.5102870731364155`*^9, 
   3.5102871063020735`*^9}, {3.5120545232307515`*^9, 3.512054526910756*^9}, {
   3.5141426032508097`*^9, 3.5141426115508213`*^9}, {3.5455061287802525`*^9, 
   3.545506135720262*^9}, {3.54801004206033*^9, 3.5480100452603345`*^9}}],

Cell[TextData[{
 "Note: Although not essential, this rule produces a simpler antiderivative \
than the rule for integrands of the form ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
    3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
    3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
    3.4975830009913936`*^9}, {3.497921614589382*^9, 3.497921644806636*^9}, 
    3.497923590660453*^9, {3.5053551461774344`*^9, 3.505355162597458*^9}, 
    3.5053551976675067`*^9, 3.505362939562558*^9, {3.513379512025691*^9, 
    3.513379515495696*^9}, {3.5151820485888433`*^9, 3.515182051927249*^9}, {
    3.5165785415965185`*^9, 3.516578588456584*^9}, 3.5463000771471715`*^9, {
    3.546301352338957*^9, 3.546301371018983*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 " when ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 "."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.5004296044446*^9, 3.5004296054856596`*^9}, {
   3.500564276738323*^9, 3.500564276738323*^9}, {3.500564478977479*^9, 
   3.500564478977479*^9}, {3.5012690944074793`*^9, 3.501269096907482*^9}, {
   3.502989419757598*^9, 3.5029894266684093`*^9}, {3.504382491914279*^9, 
   3.5043824931842804`*^9}, 3.5044145181527205`*^9, 3.5044145651527863`*^9, {
   3.5048326294605317`*^9, 3.5048326318105345`*^9}, {3.504832848270838*^9, 
   3.504832848820839*^9}, {3.5048395473922195`*^9, 3.504839551752225*^9}, {
   3.5048396769524*^9, 3.504839677692402*^9}, {3.508452034081811*^9, 
   3.508452034081811*^9}, 3.5098354484687543`*^9, 3.509911360347663*^9, {
   3.5101827988991985`*^9, 3.5101828019568033`*^9}, {3.5101832031707087`*^9, 
   3.5101832041847105`*^9}, {3.5117201893934717`*^9, 
   3.5117201893934717`*^9}, {3.513095241718216*^9, 3.513095242088216*^9}, 
   3.514142335340435*^9, {3.5141424490905943`*^9, 3.51414246048061*^9}, {
   3.514743996101736*^9, 3.5147439975317383`*^9}, {3.5147440486318097`*^9, 
   3.514744051131813*^9}, {3.5147478342170925`*^9, 3.5147478342170925`*^9}, {
   3.514750376522465*^9, 3.5147503771424665`*^9}, {3.514846444067275*^9, 
   3.514846444067275*^9}, {3.516667472845967*^9, 3.516667473703968*^9}, {
   3.51684679198973*^9, 3.516846798265088*^9}, {3.545415861632052*^9, 
   3.545415862724054*^9}, {3.545430100045179*^9, 3.54543010057518*^9}, {
   3.545596072835681*^9, 3.545596085505699*^9}, {3.545596126945757*^9, 
   3.5455962223758907`*^9}, {3.5462983818147984`*^9, 3.546298383654801*^9}, 
   3.546298452334897*^9, {3.5480125360188236`*^9, 3.548012547198839*^9}, {
   3.5480125819288883`*^9, 3.5480127290690937`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.497641822620967*^9, 
   3.4976418815034714`*^9}, {3.498241427414454*^9, 3.498241427414454*^9}, {
   3.504395896295714*^9, 3.50439590067572*^9}, 3.5044706093797717`*^9, 
   3.5044710537703934`*^9, {3.5044821550764217`*^9, 3.504482155386422*^9}, {
   3.504988576070773*^9, 3.5049885764507737`*^9}, {3.506213896034247*^9, 
   3.5062138967830486`*^9}, {3.5062141332678576`*^9, 
   3.5062141507378817`*^9}, {3.5105084879028864`*^9, 3.510508488090087*^9}, {
   3.5130944226480646`*^9, 3.5130944467345066`*^9}, 3.51309510891803*^9, {
   3.5141416582394867`*^9, 3.5141416778495145`*^9}, {3.514146583716383*^9, 
   3.514146584846384*^9}, {3.51414758915779*^9, 3.514147589647791*^9}, 
   3.5141476759479117`*^9, 3.514597994066436*^9, 3.5151812601010585`*^9, {
   3.545066159221238*^9, 3.5450661596212387`*^9}, 3.545506123330245*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SuperscriptBox["a", "2"]}], "+", 
          SuperscriptBox["b", "2"]}], ")"}], "x"}], "2"]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"2", "d"}]], "+", 
  RowBox[{"2", "a", " ", "b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5098355380753117`*^9, 3.509835661752329*^9}, {3.509835695323588*^9, 
   3.509835698927194*^9}, {3.50983577051572*^9, 3.5098358512614617`*^9}, {
   3.5101827368266892`*^9, 3.510182745344304*^9}, {3.5101829999523516`*^9, 
   3.510183019686386*^9}, {3.5141366663504972`*^9, 3.514136709830558*^9}, {
   3.5141367652306356`*^9, 3.5141367807606573`*^9}, {3.5141369190408506`*^9, 
   3.514137030991008*^9}, {3.5141375883017883`*^9, 3.5141375939117956`*^9}, {
   3.51414390318263*^9, 3.5141439034726305`*^9}, {3.5151675869436274`*^9, 
   3.5151675899036317`*^9}, {3.545506144970275*^9, 3.5455061553402896`*^9}, {
   3.545506471100732*^9, 3.5455065262408085`*^9}, {3.545506556690851*^9, 
   3.545506560730857*^9}, {3.5457114080705347`*^9, 3.5457114118105392`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"a", "^", "2"}]}], "+", 
       RowBox[{"b", "^", "2"}]}], ")"}], "*", 
     RowBox[{"x", "/", "2"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"b", "^", "2"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"2", "*", "a", "*", "b", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, {3.510267358245805*^9, 
   3.510267363695812*^9}, 3.5102674525359364`*^9, {3.51026851924743*^9, 
   3.510268522147434*^9}, 3.510268653627618*^9, {3.5102687229377155`*^9, 
   3.510268727847722*^9}, 3.510286783854707*^9, {3.510286855412032*^9, 
   3.5102868598424406`*^9}, {3.510286899944911*^9, 3.510286906169322*^9}, 
   3.512054537890772*^9, {3.5120545820108337`*^9, 3.512054602120862*^9}, {
   3.5141374185915504`*^9, 3.514137419971552*^9}, 3.514137457461605*^9, 
   3.5141375596417475`*^9, {3.514137613991824*^9, 3.514137617741829*^9}, {
   3.514141592499395*^9, 3.5141415948793983`*^9}, {3.5141439065226345`*^9, 
   3.5141439068526354`*^9}, 3.516821192057212*^9, {3.5450638743880396`*^9, 
   3.545063878378045*^9}, 3.5455066383309655`*^9, {3.545506709431065*^9, 
   3.545506722691084*^9}, {3.5457114181305485`*^9, 3.545711420790552*^9}, 
   3.5462955775708723`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, 
   3.5450660285410557`*^9, {3.5450660990311537`*^9, 3.5450661016011577`*^9}, {
   3.545066337891488*^9, 3.545066338141489*^9}, 3.545497351757964*^9, 
   3.545505795729786*^9, {3.5455059918600607`*^9, 3.5455059920500607`*^9}, {
   3.5455158779400826`*^9, 3.5455158779400826`*^9}, {3.5462949534499984`*^9, 
   3.5462949534499984`*^9}, {3.5462949860700445`*^9, 
   3.5462949906100507`*^9}, {3.546295614880924*^9, 3.546295615080925*^9}, {
   3.5462973612333694`*^9, 3.5462973695733814`*^9}, {3.5462994976863604`*^9, 
   3.546299523796397*^9}, {3.546300239397399*^9, 3.546300240897401*^9}, {
   3.546300301207485*^9, 3.5463003047474904`*^9}, {3.550003126381837*^9, 
   3.5500031265868487`*^9}, 3.550003167113167*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, 
   3.545496835607242*^9, {3.545505444879295*^9, 3.545505445119295*^9}, {
   3.545505639229567*^9, 3.5455056444395742`*^9}, {3.5455068311112356`*^9, 
   3.5455068403012486`*^9}, {3.5455157795484548`*^9, 3.545515785354787*^9}, {
   3.545604160836763*^9, 3.5456041610407743`*^9}, {3.546299449516293*^9, 
   3.5462994497762938`*^9}, {3.5462995291664047`*^9, 
   3.5462995755064697`*^9}, {3.546300060107148*^9, 3.546300060727149*^9}, {
   3.54630028306746*^9, 3.546300293027474*^9}, 3.5500031984559593`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.555.? inverted", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, 3.497583103771538*^9, 
   3.4979235780400314`*^9, {3.498240948743784*^9, 3.4982409612938013`*^9}, {
   3.5045896721978087`*^9, 3.5045896726178093`*^9}, {3.5165796775681086`*^9, 
   3.5165797222881713`*^9}}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 3.5017335953768063`*^9}, 
   3.508786823183941*^9, {3.5138842955432105`*^9, 3.513884350713288*^9}, {
   3.5138844713934565`*^9, 3.5138844716834574`*^9}, {3.516578653306675*^9, 
   3.516578656026678*^9}, {3.5463000855771837`*^9, 3.5463000855771837`*^9}, {
   3.546725933536254*^9, 3.546725934018282*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.49824098175383*^9, 3.4982410100538692`*^9}, {
   3.501806521764586*^9, 3.501806522825388*^9}, {3.5043673081970787`*^9, 
   3.5043673130770855`*^9}, {3.504589937681393*^9, 3.5045899401413965`*^9}, {
   3.504590096691616*^9, 3.5045900978716173`*^9}, {3.513618073827199*^9, 
   3.5136180745271997`*^9}, {3.514145798415283*^9, 3.514145798415283*^9}, {
   3.5141534525486174`*^9, 3.51415345975583*^9}, {3.5165786695766973`*^9, 
   3.5165786740467033`*^9}, {3.516579783398257*^9, 3.5165797839482574`*^9}, {
   3.516579949528489*^9, 3.5165799503584905`*^9}, 3.5165802603489246`*^9, {
   3.5168328599368615`*^9, 3.516832866074213*^9}, {3.5462999911670513`*^9, 
   3.5462999911670513`*^9}, {3.5463000992772026`*^9, 
   3.5463000992772026`*^9}, {3.546300359687567*^9, 3.546300359687567*^9}, {
   3.5463173395375195`*^9, 3.54631733970953*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "-", "1"}], ")"}]}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.497923590660453*^9, {3.5053551461774344`*^9, 3.505355162597458*^9}, 
   3.5053551976675067`*^9, 3.505362939562558*^9, {3.513379512025691*^9, 
   3.513379515495696*^9}, {3.5151820485888433`*^9, 3.515182051927249*^9}, {
   3.5165785415965185`*^9, 3.516578588456584*^9}, 3.5463000771471715`*^9, {
   3.546301352338957*^9, 3.546301371018983*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"a", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "/", "n"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.497923569444416*^9, {3.4982410296338973`*^9, 3.4982410322139006`*^9}, 
   3.501806517926979*^9, {3.504367290927055*^9, 3.5043672999870677`*^9}, {
   3.504589927381379*^9, 3.50458992787138*^9}, {3.505355146187434*^9, 
   3.5053551626074576`*^9}, 3.5053551976875067`*^9, 3.505362943012563*^9, {
   3.5133795214257045`*^9, 3.513379523885708*^9}, {3.514145770335244*^9, 
   3.514145770585244*^9}, 3.5141534394757943`*^9, {3.516578784936859*^9, 
   3.5165787866568613`*^9}, {3.5410884359969783`*^9, 3.541088452860608*^9}, 
   3.5455832533922076`*^9, {3.546300007347074*^9, 3.546300017197088*^9}, {
   3.5463003697575817`*^9, 3.5463003755675898`*^9}, {3.5463013825489993`*^9, 
   3.5463013928090134`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, 3.5450638651180267`*^9, {
   3.545064163248444*^9, 3.5450641908184824`*^9}, 3.5450645478389826`*^9, {
   3.5450649786895857`*^9, 3.545064986639597*^9}, {3.545066031121059*^9, 
   3.5450660335610623`*^9}, 3.5454973526179657`*^9, {3.545503990667259*^9, 
   3.5455039981972694`*^9}, 3.5455052729790545`*^9, 3.545505442339291*^9, {
   3.5455064354906816`*^9, 3.5455064379106855`*^9}, 3.545515726821439*^9, {
   3.5456003352216487`*^9, 3.545600355601677*^9}, {3.545600423321772*^9, 
   3.545600423321772*^9}, {3.545604133051173*^9, 3.5456041344842553`*^9}, 
   3.546295674541008*^9, {3.5462984333848705`*^9, 3.5462984358048735`*^9}, {
   3.5463002319973884`*^9, 3.5463002342273912`*^9}, {3.546300274577448*^9, 
   3.546300290957471*^9}, 3.5500031998000364`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 3 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "a"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "b"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.514253181887664*^9, {3.5455040345073204`*^9, 3.5455040366873236`*^9}, {
   3.545504158357494*^9, 3.545504246227617*^9}, {3.545505035248721*^9, 
   3.5455051376488647`*^9}, {3.548010066360364*^9, 3.548010067570366*^9}, {
   3.5480103064507*^9, 3.5480103068407*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, 
   3.5142558168413525`*^9, {3.514598142866644*^9, 3.5145981469766493`*^9}, {
   3.5145981919067125`*^9, 3.5145981930867143`*^9}, {3.5146368879674587`*^9, 
   3.514636892241866*^9}, {3.5455039784272423`*^9, 3.545503983537249*^9}, {
   3.5456003616016855`*^9, 3.5456003616016855`*^9}, {3.5456004253217745`*^9, 
   3.5456004253217745`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "n"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], "+", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5142257979137073`*^9, 3.5142258077261243`*^9}, {
   3.5142526409569063`*^9, 3.5142526458869133`*^9}, {3.5142558354813786`*^9, 
   3.514255880171441*^9}, {3.5145980839965615`*^9, 3.5145980911865716`*^9}, {
   3.514636932599137*^9, 3.514636936046743*^9}, {3.515167673643749*^9, 
   3.515167683553763*^9}, {3.5455038508570633`*^9, 3.545503915727154*^9}, 
   3.545503966837226*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"1", "/", "n"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", "n"}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "+", 
           RowBox[{"a", "*", "b", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "-", "1"}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, 3.4975831484616003`*^9, 3.4975832895717974`*^9, {
   3.4979216146049824`*^9, 3.4979216448222356`*^9}, 3.4979236654001846`*^9, {
   3.4981987086091685`*^9, 3.4981987164091825`*^9}, {3.4981987562360525`*^9, 
   3.498198756563653*^9}, {3.4982411011539974`*^9, 3.498241103034*^9}, {
   3.5017330383946285`*^9, 3.501733038800229*^9}, {3.501733070701085*^9, 
   3.501733075100292*^9}, {3.5031145982909107`*^9, 3.5031146095385303`*^9}, {
   3.503883100784115*^9, 3.5038831023441176`*^9}, {3.5043676148075085`*^9, 
   3.504367618347513*^9}, 3.5053446400637827`*^9, {3.505344689333851*^9, 
   3.5053447136938853`*^9}, 3.5053456710052257`*^9, 3.508439032390652*^9, {
   3.509847523238981*^9, 3.5098475246289825`*^9}, 3.511459116976429*^9, 
   3.511805548999618*^9, {3.5120532760509987`*^9, 3.512053278951003*^9}, 
   3.512054082220134*^9, {3.5134422284957695`*^9, 3.5134422298957715`*^9}, {
   3.5141356760929937`*^9, 3.5141356805234013`*^9}, {3.514137621831835*^9, 
   3.514137631141848*^9}, {3.514147337857438*^9, 3.5141473571874657`*^9}, {
   3.514152750191185*^9, 3.5141527505311856`*^9}, 3.514177998879638*^9, 
   3.514583249914508*^9, 3.5146451165524626`*^9, 3.541090446501709*^9, 
   3.5410905255090475`*^9, 3.541090623071619*^9, {3.541090860660036*^9, 
   3.541090861689638*^9}, {3.5454912109410563`*^9, 3.5454912109510565`*^9}, {
   3.5455038224470234`*^9, 3.5455038387370462`*^9}, {3.545600363381688*^9, 
   3.545600369891697*^9}, {3.5456004272817774`*^9, 3.545600452051812*^9}, 
   3.5462955776008725`*^9, {3.546300315777506*^9, 3.5463003171475077`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, 
   3.5450660285410557`*^9, {3.5450660990311537`*^9, 3.5450661016011577`*^9}, {
   3.545066337891488*^9, 3.545066338141489*^9}, 3.545497351757964*^9, 
   3.545505795729786*^9, {3.5455059918600607`*^9, 3.5455059920500607`*^9}, {
   3.5455158779400826`*^9, 3.5455158779400826`*^9}, {3.5462949534499984`*^9, 
   3.5462949534499984`*^9}, {3.5462949860700445`*^9, 
   3.5462949906100507`*^9}, {3.546295614880924*^9, 3.546295615080925*^9}, {
   3.5462973612333694`*^9, 3.5462973695733814`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, 3.545497342177951*^9, 
   3.545515777055312*^9, {3.5462990410957212`*^9, 3.5462990443057256`*^9}, 
   3.546299443516285*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, 3.5450606610380955`*^9, 3.545060729428616*^9, 
   3.5450609209813523`*^9, {3.545060951947407*^9, 3.545060952321808*^9}, 
   3.5454973441779537`*^9, 3.545515796981452*^9, {3.5462988636854725`*^9, 
   3.5462988636854725`*^9}, {3.5462990295257053`*^9, 3.5462990495457335`*^9}, 
   3.546315453644653*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.555.3', CRC 337', A&S 4.3.134'/5'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4979222572169113`*^9, {3.515603311397254*^9, 
   3.5156033183572636`*^9}, {3.5156034225574093`*^9, 3.5156034228274097`*^9}}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 
   3.5017335953768063`*^9}, {3.501733875319298*^9, 3.501733886769718*^9}, {
   3.5017340709904413`*^9, 3.501734096262486*^9}, 3.508786823163941*^9, {
   3.513882931481301*^9, 3.513882974681361*^9}, {3.513884456003435*^9, 
   3.5138844562234354`*^9}, {3.548010074540375*^9, 3.548010075430376*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.498240714363456*^9, 3.498240714363456*^9}, {
   3.504588147288866*^9, 3.504588147958867*^9}, 3.504590081521595*^9, 
   3.5136155872190466`*^9, 3.514736574158182*^9, {3.546298849535453*^9, 
   3.546298858115465*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
         ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4979216145737824`*^9, 3.4979216447910357`*^9}, 
   3.497922266920128*^9, {3.5053551460674343`*^9, 3.5053551625674577`*^9}, 
   3.5053551975975065`*^9, 3.505362823262396*^9, {3.513379457125614*^9, 
   3.513379457835615*^9}, 3.5151817786459694`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"d", "*", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, {3.4979216145737824`*^9, 
   3.4979216447910357`*^9}, 3.4979222491204967`*^9, {3.5053551460774345`*^9, 
   3.5053551625774574`*^9}, 3.5053551976075068`*^9, 3.5053628266724005`*^9, 
   3.513379480405647*^9, {3.5410889128430157`*^9, 3.5410889286458435`*^9}, 
   3.5463015033991685`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, 3.545497342177951*^9, 
   3.545515777055312*^9, {3.546299050905735*^9, 3.5462990510957355`*^9}, 
   3.546315454913725*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ">", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545060696949359*^9, 
   3.545060704889773*^9}, 3.545497343227953*^9, 3.5455157955793715`*^9, 
   3.5463154708816385`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ">", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, 3.545060656186487*^9, 3.545060708025378*^9, 
   3.545497366417985*^9, 3.545515801057685*^9, 3.546315487270576*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: Although this rule produces a more complicated antiderivative than \
the following rule, it is continuous provided  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.5150252809040365`*^9, 3.5150252853722925`*^9}, {3.5151811966413474`*^9, 
   3.515181199808153*^9}, {3.51519438221424*^9, 3.515194382634241*^9}, {
   3.54629853986502*^9, 3.5462985471050296`*^9}, {3.5462986427551637`*^9, 
   3.5462986558151817`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.5043963739063826`*^9, 
   3.504396376326386*^9}, {3.504413073930699*^9, 3.5044130746907*^9}, {
   3.5098947021629305`*^9, 3.5098947030329323`*^9}, {3.51309431747268*^9, 
   3.5130943178158803`*^9}, {3.513094997527874*^9, 3.5130949981778746`*^9}, {
   3.5133770949823074`*^9, 3.513377095502308*^9}, {3.5133782686539507`*^9, 
   3.513378269123951*^9}, {3.51459648291432*^9, 3.514596484034322*^9}, {
   3.5151812028969584`*^9, 3.5151812036301594`*^9}, {3.5450661406012125`*^9, 
   3.5450661413112135`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["2", 
    RowBox[{"d", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{"a", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.497921629705809*^9, 3.497922342845462*^9, 3.4980128262865524`*^9, 
   3.5053446395437813`*^9, {3.5053446876538486`*^9, 3.505344713213885*^9}, 
   3.5053459961156807`*^9, 3.5098471285884285`*^9, 3.515167507293516*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"Rt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"a", "^", "2"}], "-", 
             RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}], "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", " ", "+", " ", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], "]"}]}]}], " ", 
   "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, 
   3.4980130216868258`*^9, {3.4980208106228065`*^9, 3.498020814366813*^9}, {
   3.4980626680522194`*^9, 3.4980626702362237`*^9}, {3.498062841914525*^9, 
   3.49806284476933*^9}, 3.5053446395537815`*^9, {3.505344687663849*^9, 
   3.5053447132238846`*^9}, 3.5053459995156856`*^9, 3.5098471414484463`*^9, {
   3.513398117248828*^9, 3.513398157216098*^9}, {3.54109669082347*^9, 
   3.541096703334692*^9}, {3.5450597792933474`*^9, 3.545059780229349*^9}, 
   3.545065301200037*^9, 3.5462955776108723`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ">", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, 3.5450606589788923`*^9, 3.5450607104589825`*^9, {
   3.5450610621772003`*^9, 3.545061062473601*^9}, 3.5454973682579875`*^9, 
   3.545515802311757*^9, 3.546315488332637*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.551.3a, A&S 4.3.131a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9}],

Cell["Reference: G&R 2.553.3a, A&S 4.3.133a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.5043963804663916`*^9, 
   3.504396382116394*^9}, {3.5044130786807055`*^9, 3.5044130791307063`*^9}, {
   3.509893023890581*^9, 3.5098930241605816`*^9}, {3.509894710462942*^9, 
   3.509894710792943*^9}, {3.513094321341487*^9, 3.5130943216066875`*^9}, {
   3.513094999937877*^9, 3.513095002687881*^9}, {3.513377098152312*^9, 
   3.5133770986723127`*^9}, {3.51337850404428*^9, 3.5133785043542805`*^9}, {
   3.513378646324479*^9, 3.5133786471244802`*^9}, {3.514596520734373*^9, 
   3.5145965210743732`*^9}, 3.515181227779002*^9, {3.545066144721218*^9, 
   3.545066145381219*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.497921629705809*^9, 3.497922342845462*^9, 3.505344687683849*^9, {
   3.505346079315797*^9, 3.505346090775813*^9}, 3.509847143598449*^9, 
   3.515167542223565*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], "*", 
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, {
   3.4980123935259466`*^9, 3.4980123977059526`*^9}, {3.498020817549219*^9, 
   3.4980208202948236`*^9}, {3.5098926299200296`*^9, 
   3.5098926316600323`*^9}, {3.509892811650284*^9, 3.509892811780284*^9}, {
   3.541096762599196*^9, 3.5410967787920246`*^9}, {3.5450599892697163`*^9, 
   3.5450599947453256`*^9}, 3.5450653458700995`*^9, {3.5467368500652404`*^9, 
   3.5467368557635665`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, {
   3.4980123935259466`*^9, 3.4980123977059526`*^9}, {3.498020817549219*^9, 
   3.4980208202948236`*^9}, 3.505344687693849*^9, {3.5053461149158473`*^9, 
   3.5053461261058626`*^9}, 3.509847144988451*^9, {3.5450600136057587`*^9, 
   3.5450600145573606`*^9}, 3.5462955776108723`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"\[Not]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ">", "0"}], ")"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, 3.5450606610380955`*^9, 3.545060729428616*^9, 
   3.5450609209813523`*^9, {3.545060951947407*^9, 3.545060952321808*^9}, 
   3.5454973441779537`*^9, 3.545515796981452*^9, 3.546315472905754*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.551.3b', A&S 4.3.131b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9}],

Cell["Reference: G&R 2.553.3b', A&S 4.3.133b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4979223905815454`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.5043963859263997`*^9, 3.504396387816402*^9}, {3.5044130826407113`*^9, 
   3.504413083060712*^9}, {3.509893030860591*^9, 3.509893031120591*^9}, {
   3.5098947184829535`*^9, 3.509894718752954*^9}, {3.5130950087778893`*^9, 
   3.51309500927789*^9}, {3.5133771015723166`*^9, 3.5133771022023177`*^9}, {
   3.513378507704285*^9, 3.5133785079842854`*^9}, {3.514596527664383*^9, 
   3.5145965280543833`*^9}, 3.5151812308834076`*^9, {3.545066147711222*^9, 
   3.545066148301223*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["a", "2"]}]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["a", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, 3.497921629705809*^9, 3.4979224338404217`*^9, 
   3.505344687703849*^9, {3.5053462036959715`*^9, 3.505346204905973*^9}, 
   3.509847146268453*^9, 3.5136162220309615`*^9, {3.514226290593773*^9, 
   3.514226292138175*^9}, 3.515167558533588*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], "*", 
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497921629721409*^9, 
   3.497922399317561*^9, {3.4980131795470467`*^9, 3.4980131835270524`*^9}, {
   3.4980154763502626`*^9, 3.498015479210266*^9}, {3.509892709560141*^9, 
   3.509892711770144*^9}, {3.5098928069102774`*^9, 3.509892807060278*^9}, {
   3.5450601208403473`*^9, 3.545060125426755*^9}, {3.546736924256484*^9, 
   3.5467369323159447`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497921629721409*^9, 
   3.497922399317561*^9, {3.4980131795470467`*^9, 3.4980131835270524`*^9}, {
   3.4980154763502626`*^9, 3.498015479210266*^9}, 3.5053446877238493`*^9, {
   3.505346235096015*^9, 3.5053462441360283`*^9}, 3.509847147538455*^9, {
   3.545060166392427*^9, 3.5450601679212294`*^9}, 3.5462955776208725`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, {
   3.5450663345114837`*^9, 3.545066334651484*^9}, 3.545497349207961*^9, {
   3.5455060863601933`*^9, 3.5455060922202015`*^9}, {3.5455063729305944`*^9, 
   3.5455063731005945`*^9}, {3.5455157780793705`*^9, 3.545515783781697*^9}, {
   3.5462992775760527`*^9, 3.5462992873360662`*^9}, {3.5462993989062223`*^9, 
   3.5462994041562295`*^9}, 3.546299445946288*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, {
   3.5450663345114837`*^9, 3.545066334651484*^9}, 3.545497349207961*^9, {
   3.5455060863601933`*^9, 3.5455060922202015`*^9}, {3.5455063729305944`*^9, 
   3.5455063731005945`*^9}, {3.5455157780793705`*^9, 3.545515783781697*^9}, {
   3.5462992775760527`*^9, 3.5462992873360662`*^9}, {3.5462993989062223`*^9, 
   3.5462994041562295`*^9}, 3.546299445946288*^9, {3.546707186625992*^9, 
   3.5467071895701604`*^9}, 3.5467073787109785`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, {
   3.5450663345114837`*^9, 3.545066334651484*^9}, 3.545497349207961*^9, {
   3.5455060863601933`*^9, 3.5455060922202015`*^9}, {3.5455063729305944`*^9, 
   3.5455063731005945`*^9}, {3.5455157780793705`*^9, 3.545515783781697*^9}, {
   3.5462992775760527`*^9, 3.5462992873360662`*^9}, {3.5462993989062223`*^9, 
   3.5462994041562295`*^9}, 3.546299445946288*^9, {3.546707186625992*^9, 
   3.5467071895701604`*^9}, {3.5467073787109785`*^9, 3.5467074080986595`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, 
   3.5450645300089574`*^9, 3.545064588069039*^9, 3.5450647701792936`*^9, 
   3.5454973500579624`*^9, 3.545506094250204*^9, 3.5455158087971277`*^9, {
   3.546315535897357*^9, 3.5463155557754946`*^9}, 3.546707200966812*^9, {
   3.546707250536648*^9, 3.546707259091137*^9}, 3.5467073886095448`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: Although not essential, this rule produces a simpler antiderivative \
than the rule for ",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]],
  CellDingbat->None,
  CellChangeTimes->{
   3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
    3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
    3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
    3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
    3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
    3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
    3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
    3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
    3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
    3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
    3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
    3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
    3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
    3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
    3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
    3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
    3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
    3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
    3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
    3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
    3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
    3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
    3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
    3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
    3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
    3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
    3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
    3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
    3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
    3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
    3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
    3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
    3.5328460582169604`*^9, {3.5328745920833416`*^9, 
    3.5328746294142075`*^9}, {3.532875067275776*^9, 3.532875067650177*^9}, {
    3.532875139909504*^9, 3.532875150829523*^9}, {3.537656121233163*^9, 
    3.537656121443164*^9}, 3.540263906712819*^9, {3.5402639787229204`*^9, 
    3.5402639788829203`*^9}, {3.540319178473138*^9, 3.5403191846574917`*^9}, {
    3.540319223359705*^9, 3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
    3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
    3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
    3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
    3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, {
    3.5449729607242365`*^9, 3.5449729664182467`*^9}, 3.5449734059490185`*^9, 
    3.5449737340331945`*^9, 3.5449770099650764`*^9, 3.5450142181695447`*^9, 
    3.5454968189672184`*^9, 3.546191543479907*^9, 3.546196158346368*^9, 
    3.5461970146775665`*^9, 3.5461989030302105`*^9, 3.546315763107353*^9, {
    3.5463168908548565`*^9, 3.546316921936634*^9}, {3.546705921083607*^9, 
    3.546705921295619*^9}, 3.5467059830511513`*^9, 3.546706158641195*^9},
  FontSize->12,
  FontWeight->"Bold"],
 " when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.513378780694667*^9, 
   3.5133787854946737`*^9}, {3.5134525742622547`*^9, 3.513452574812256*^9}, {
   3.5134526934224215`*^9, 3.513452694252423*^9}, {3.5134527406824875`*^9, 
   3.5134527409424877`*^9}, {3.515190691093055*^9, 3.5151906945130596`*^9}, {
   3.5463165044197536`*^9, 3.54631653862671*^9}, {3.5467067398964405`*^9, 
   3.5467067649068713`*^9}, {3.5467068402471805`*^9, 
   3.5467068402471805`*^9}, {3.546707511830593*^9, 3.546707511830593*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, 3.4976400387242327`*^9, {
   3.504490585426359*^9, 3.5044905863663607`*^9}, {3.5046319134167933`*^9, 
   3.504631913666794*^9}, {3.5134526721023912`*^9, 3.5134526728323927`*^9}, 
   3.5136155063017044`*^9, {3.5462991911259313`*^9, 3.546299192365933*^9}, {
   3.546299343046144*^9, 3.546299343646145*^9}, 3.546707269914756*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "2"], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, 
   3.4976400727478924`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.4979232754930997`*^9, {3.499129231529621*^9, 3.4991292377396297`*^9}, {
   3.500665326343998*^9, 3.5006653286340013`*^9}, 3.513376911742051*^9, {
   3.515181974176713*^9, 3.5151819769691176`*^9}, {3.546707272405898*^9, 
   3.54670727383298*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, 
   3.4976400203630004`*^9, {3.497921614589382*^9, 3.497921644806636*^9}, 
   3.4979232490822535`*^9, {3.499129515580019*^9, 3.4991295254700327`*^9}, {
   3.5133788447747574`*^9, 3.5133788449447575`*^9}, 3.5133790045949807`*^9, 
   3.5410888914397783`*^9, 3.541088948223878*^9, {3.5463015109491787`*^9, 
   3.5463015167491875`*^9}, {3.546707279101281*^9, 3.5467072816874294`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "-", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, 
   3.5450645300089574`*^9, 3.545064588069039*^9, 3.5450647701792936`*^9, 
   3.5454973500579624`*^9, 3.545506094250204*^9, 3.5455158087971277`*^9, {
   3.546315535897357*^9, 3.5463155557754946`*^9}, 3.546707200966812*^9, {
   3.546707250536648*^9, 3.546707259091137*^9}, {3.546707334627457*^9, 
   3.5467073416338577`*^9}, 3.5467073871844635`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: Although not essential, this rule produces a simpler antiderivative \
than the rule for ",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]],
  CellDingbat->None,
  CellChangeTimes->{
   3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
    3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
    3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
    3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
    3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
    3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
    3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
    3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
    3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
    3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
    3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
    3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
    3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
    3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
    3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
    3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
    3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
    3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
    3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
    3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
    3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
    3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
    3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
    3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
    3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
    3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
    3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
    3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
    3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
    3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
    3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
    3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
    3.5328460582169604`*^9, {3.5328745920833416`*^9, 
    3.5328746294142075`*^9}, {3.532875067275776*^9, 3.532875067650177*^9}, {
    3.532875139909504*^9, 3.532875150829523*^9}, {3.537656121233163*^9, 
    3.537656121443164*^9}, 3.540263906712819*^9, {3.5402639787229204`*^9, 
    3.5402639788829203`*^9}, {3.540319178473138*^9, 3.5403191846574917`*^9}, {
    3.540319223359705*^9, 3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
    3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
    3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
    3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
    3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, {
    3.5449729607242365`*^9, 3.5449729664182467`*^9}, 3.5449734059490185`*^9, 
    3.5449737340331945`*^9, 3.5449770099650764`*^9, 3.5450142181695447`*^9, 
    3.5454968189672184`*^9, 3.546191543479907*^9, 3.546196158346368*^9, 
    3.5461970146775665`*^9, 3.5461989030302105`*^9, 3.546315763107353*^9, {
    3.5463168908548565`*^9, 3.546316921936634*^9}, {3.546705921083607*^9, 
    3.546705921295619*^9}, 3.5467059830511513`*^9, 3.546706158641195*^9},
  FontSize->12,
  FontWeight->"Bold"],
 " when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.513378780694667*^9, 
   3.5133787854946737`*^9}, {3.5134525742622547`*^9, 3.513452574812256*^9}, {
   3.5134526934224215`*^9, 3.513452694252423*^9}, {3.5134527406824875`*^9, 
   3.5134527409424877`*^9}, {3.515190691093055*^9, 3.5151906945130596`*^9}, {
   3.5463165044197536`*^9, 3.54631653862671*^9}, {3.5467067398964405`*^9, 
   3.5467067649068713`*^9}, {3.5467068402471805`*^9, 
   3.5467068402471805`*^9}, {3.546707511830593*^9, 3.546707511830593*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.5044905820363545`*^9, 
   3.5044905832563562`*^9}, {3.5046319107667894`*^9, 3.50463191104679*^9}, {
   3.5134526749623957`*^9, 3.5134526756323967`*^9}, {3.5136155083453083`*^9, 
   3.5136155091721096`*^9}, {3.5462991977359405`*^9, 
   3.5462991977359405`*^9}, {3.546299346206148*^9, 3.5462993467661495`*^9}, 
   3.546707289655885*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"a", "-", 
          RowBox[{"a", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}], 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "2"], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, {3.500665322063992*^9, 
   3.500665324003995*^9}, {3.5133769023520374`*^9, 3.513376918972061*^9}, {
   3.5151819816179256`*^9, 3.5151819844727306`*^9}, {3.5467072915219917`*^9, 
   3.546707304122712*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "-", 
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.51337883965475*^9, 
   3.5133788398447504`*^9}, 3.513379001864977*^9, 3.541088893764182*^9, 
   3.5410889501894817`*^9, 3.5463015267292013`*^9, {3.546707309100997*^9, 
   3.546707313713261*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, 
   3.5450645300089574`*^9, 3.545064588069039*^9, 3.5450647701792936`*^9, 
   3.5454973500579624`*^9, 3.545506094250204*^9, 3.5455158087971277`*^9, {
   3.546315535897357*^9, 3.5463155557754946`*^9}, {3.546707200966812*^9, 
   3.5467072165997066`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976398906331725`*^9, 3.497639892598776*^9}, {3.5007815669041595`*^9, 
   3.5007815669041595`*^9}, {3.5053561754188757`*^9, 3.505356175858876*^9}, 
   3.5133768939620256`*^9, 3.5136155132749166`*^9, {3.546299199625943*^9, 
   3.546299199625943*^9}, {3.5462993491061525`*^9, 3.546299349706153*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "2"], "-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", "b"}], 
      RowBox[{"4", "a"}]]}], "]"}], 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "-", 
      FractionBox[
       RowBox[{"\[Pi]", " ", "b"}], 
       RowBox[{"4", "a"}]]}], "]"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.4991295982501345`*^9, 3.4991296038701425`*^9}, {3.5007806832629223`*^9, 
   3.500780689482931*^9}, 3.500781551604138*^9, 3.500781748904414*^9, {
   3.5133769959521685`*^9, 3.5133769962021694`*^9}, 3.5151818902173653`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
      RowBox[{"Pi", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", "a"}], ")"}]}]}]}], "]"}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
       RowBox[{"Pi", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "a"}], ")"}]}]}]}], "]"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.499129642150196*^9, 3.4991296506002073`*^9}, {3.5007807265629826`*^9, 
   3.500780730282988*^9}, {3.5007815769341736`*^9, 3.5007816235942388`*^9}, {
   3.5007817605844307`*^9, 3.5007817609944315`*^9}, {3.5007817924544754`*^9, 
   3.5007818323945312`*^9}, {3.5133788478747616`*^9, 3.5133788480347614`*^9}, 
   3.541088895838986*^9, 3.541088953403087*^9, 3.546301535239213*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, {
   3.5450663345114837`*^9, 3.545066334651484*^9}, 3.545497349207961*^9, {
   3.5455060863601933`*^9, 3.5455060922202015`*^9}, {3.5455063729305944`*^9, 
   3.5455063731005945`*^9}, {3.5455157780793705`*^9, 3.545515783781697*^9}, 
   3.5463155060526505`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"a", "+", "b"}], ">", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, 
   3.5450645300089574`*^9, 3.545064588069039*^9, 3.5450647701792936`*^9, 
   3.5454973500579624`*^9, 3.545506094250204*^9, 3.5455158087971277`*^9, 
   3.546315535897357*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"EllipticF", "[", 
     RowBox[{"x", ",", "n"}], "]"}]}], "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"n", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, {3.497921629815009*^9, 3.497921629815009*^9}, {
   3.49792329284033*^9, 3.4979232943847327`*^9}, {3.5053446395937815`*^9, 
   3.5053446395937815`*^9}, {3.505344713233885*^9, 3.505344713233885*^9}, {
   3.505346510696401*^9, 3.505346510696401*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "2"]}]}], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{"a", "+", "b"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, {3.509893685281507*^9, 3.509893685281507*^9}, {
   3.5151264190002117`*^9, 3.5151264190002117`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4982408987437143`*^9, 3.4982408987437143`*^9}, {3.5043962464162045`*^9, 
   3.5043962850762587`*^9}, {3.504413252610949*^9, 3.5044132530909495`*^9}, {
   3.504413301361017*^9, 3.5044133020910187`*^9}, {3.508348863976375*^9, 
   3.508348864916376*^9}, {3.5130950594779606`*^9, 3.513095060387962*^9}, {
   3.5133771350223637`*^9, 3.513377135282364*^9}, {3.5145979411963615`*^9, 
   3.5145979414963617`*^9}, {3.5145980318864884`*^9, 3.514598032216489*^9}, {
   3.5151812964647226`*^9, 3.515181297213524*^9}, {3.545066161781242*^9, 
   3.545066162341243*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"a", "+", "b"}]]}]]}]}]}], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, 3.505344687743849*^9, 3.5053463635561953`*^9, 
   3.5098471859085083`*^9, 3.50989404465201*^9, 3.515126412682201*^9, 
   3.515167635823696*^9, {3.5157110639834633`*^9, 3.5157110666978683`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", "b"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", 
      RowBox[{"2", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, 3.505344687753849*^9, 
   3.5053463733062086`*^9, {3.5054092959542894`*^9, 3.5054093016142974`*^9}, {
   3.507431779004877*^9, 3.507431782924883*^9}, 3.5098471877485113`*^9, 
   3.50989405898203*^9, 3.5118053931194*^9, 3.514177466743102*^9, {
   3.5151264479070625`*^9, 3.5151264611670856`*^9}, {3.515689278376487*^9, 
   3.5156892815064907`*^9}, {3.5410968967282314`*^9, 3.541096919909872*^9}, {
   3.5450648402393913`*^9, 3.5450648659894276`*^9}, {3.5467380582103424`*^9, 
   3.5467380649077253`*^9}, 3.5473431905210752`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", "b"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Pi", "/", "4"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"2", "*", 
       RowBox[{"b", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}]}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, 3.505344687753849*^9, 
   3.5053463733062086`*^9, {3.5054092959542894`*^9, 3.5054093016142974`*^9}, {
   3.507431779004877*^9, 3.507431782924883*^9}, 3.5098471877485113`*^9, 
   3.50989405898203*^9, 3.5118053931194*^9, 3.514177466743102*^9, 
   3.515126438125846*^9, {3.515689285906497*^9, 3.515689289336502*^9}, {
   3.515711071877077*^9, 3.515711081892295*^9}, {3.541096900129038*^9, 
   3.541096928193487*^9}, {3.545064796859331*^9, 3.5450647972893314`*^9}, 
   3.5450648301393776`*^9, 3.5462955776308727`*^9, 3.5462972093731565`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "+", "b"}], ">", "0"}], ")"}]}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.545064721589226*^9, 
   3.5454973509079638`*^9, 3.5455060961302066`*^9, 3.545515809524169*^9, 
   3.546315537184431*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"f", "[", "z", "]"}]}]}], 
       RowBox[{"a", "+", "b"}]]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354612514423*^9, 
   3.508354612514423*^9}}],

Cell[TextData[{
 "Note: Since ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox["b", 
     RowBox[{"a", "+", "b"}]]}], "=", 
   RowBox[{"1", ">", "0"}]}]]],
 ", rule f1 applies to the resulting integrand."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.497582428440592*^9, 
   3.4975824695406494`*^9}, 3.4975829172612762`*^9, 3.497921629815009*^9, {
   3.4991291005894375`*^9, 3.4991291026694403`*^9}, {3.5067957135723715`*^9, 
   3.5067957287842445`*^9}, {3.51417741964662*^9, 3.5141774204266214`*^9}, {
   3.515025892968045*^9, 3.5150258957342033`*^9}, {3.515194478564375*^9, 
   3.5151944789643755`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4976405001418433`*^9, 3.497640503464649*^9}, {3.4982409098137293`*^9, 
   3.4982409098137293`*^9}, {3.5043962887062635`*^9, 3.504396290556266*^9}, {
   3.5044132557009535`*^9, 3.5044132561509542`*^9}, {3.5044133044510217`*^9, 
   3.504413305251023*^9}, {3.508348868626382*^9, 3.5083488694363823`*^9}, {
   3.5130950627779655`*^9, 3.5130950644079676`*^9}, {3.5133771393823695`*^9, 
   3.51337713965237*^9}, {3.5145979469663696`*^9, 3.51459794723637*^9}, {
   3.5145980356764936`*^9, 3.514598035906494*^9}, {3.5151813011915307`*^9, 
   3.5151813014255314`*^9}, {3.5450661638212447`*^9, 3.545066164471246*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{
        FractionBox["a", 
         RowBox[{"a", "+", "b"}]], "+", 
        RowBox[{
         FractionBox["b", 
          RowBox[{"a", "+", "b"}]], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        FractionBox["a", 
         RowBox[{"a", "+", "b"}]], "+", 
        RowBox[{
         FractionBox["b", 
          RowBox[{"a", "+", "b"}]], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.4976403449059706`*^9, {3.4976403873536453`*^9, 3.4976403923456535`*^9}, {
   3.497921629815009*^9, 3.4979216298306093`*^9}, {3.5053446877738495`*^9, 
   3.5053446877738495`*^9}, {3.509847190318515*^9, 3.509847192628518*^9}, 
   3.5118044003020062`*^9, {3.515167642193705*^9, 3.515167644383708*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"b", "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}]}], "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.4976403184795237`*^9, {3.4979216298306093`*^9, 3.4979216298306093`*^9}, 
   3.4979234149105444`*^9, {3.505344687793849*^9, 3.505344687793849*^9}, {
   3.5098471944485207`*^9, 3.5098471966885233`*^9}, 3.511805396469404*^9, 
   3.514177472234312*^9, {3.541097720378478*^9, 3.541097730799296*^9}, {
   3.545064662019142*^9, 3.545064680279168*^9}, 3.5462955776408725`*^9, 
   3.54629721171316*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["3.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, 3.5450136030448647`*^9, {
   3.5450136641657715`*^9, 3.545013664399772*^9}, 3.5450137702459583`*^9, {
   3.5450606413352613`*^9, 3.5450606506328773`*^9}, {3.545064522708947*^9, 
   3.5450645492289844`*^9}, {3.545064583839033*^9, 3.5450645840990334`*^9}, 
   3.5450660285410557`*^9, {3.5450660990311537`*^9, 3.5450661016011577`*^9}, {
   3.545066337891488*^9, 3.545066338141489*^9}, 3.545497351757964*^9, 
   3.545505795729786*^9, {3.5455059918600607`*^9, 3.5455059920500607`*^9}, {
   3.5455158779400826`*^9, 3.5455158779400826`*^9}, {3.5462949534499984`*^9, 
   3.5462949534499984`*^9}, {3.5462949860700445`*^9, 
   3.5462949906100507`*^9}, {3.546295614880924*^9, 3.546295615080925*^9}, {
   3.5462973612333694`*^9, 3.5462973695733814`*^9}, {3.5462994976863604`*^9, 
   3.546299523796397*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, 
   3.545496835607242*^9, {3.545505444879295*^9, 3.545505445119295*^9}, {
   3.545505639229567*^9, 3.5455056444395742`*^9}, {3.5455068311112356`*^9, 
   3.5455068403012486`*^9}, {3.5455157795484548`*^9, 3.545515785354787*^9}, {
   3.545604160836763*^9, 3.5456041610407743`*^9}, {3.546299449516293*^9, 
   3.5462994497762938`*^9}, {3.5462995291664047`*^9, 3.5462995755064697`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.555.?", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, {
   3.497924019318006*^9, 3.4979240196144066`*^9}, {3.498241234894184*^9, 
   3.4982412543042116`*^9}, 3.504589662077794*^9, {3.5165796831181164`*^9, 
   3.5165797012081413`*^9}}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017335581083407`*^9, 
   3.5017335953768063`*^9}, {3.501733875319298*^9, 3.501733886769718*^9}, 
   3.5087868231739407`*^9, {3.513883533542144*^9, 3.5138835815022106`*^9}, {
   3.5138838785526266`*^9, 3.513883898882655*^9}, {3.5138844660034494`*^9, 
   3.51388446672345*^9}, {3.51657805700584*^9, 3.516578065425852*^9}, {
   3.5463000896571894`*^9, 3.5463000896571894`*^9}, {3.5467260552482157`*^9, 
   3.5467260558792515`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, 
   3.4982412736942387`*^9, {3.503449288357001*^9, 3.5034492910090055`*^9}, {
   3.504589596062498*^9, 3.504589602782508*^9}, {3.5045900841715984`*^9, 
   3.504590086031601*^9}, {3.5136180641471853`*^9, 3.5136180649371867`*^9}, {
   3.514145465634817*^9, 3.514145465634817*^9}, 3.516578098155897*^9, {
   3.516579786628261*^9, 3.516579787068262*^9}, {3.5165799465484853`*^9, 
   3.5165799470384855`*^9}, 3.5165802572589197`*^9, {3.5462999861270447`*^9, 
   3.5462999861270447`*^9}, {3.5463000969872*^9, 3.5463001089872165`*^9}, {
   3.5463174081184425`*^9, 3.546317408568468*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, 3.497640636985284*^9, {3.49764069135378*^9, 
   3.4976406986701927`*^9}, {3.497640801957974*^9, 3.497640818119602*^9}, {
   3.4976415480136843`*^9, 3.497641558013302*^9}, {3.4976416100549936`*^9, 
   3.4976416105853944`*^9}, {3.4979216146205826`*^9, 3.4979216448222356`*^9}, 
   3.4979239295710487`*^9, {3.5053551461074343`*^9, 3.5053551625774574`*^9}, 
   3.5053551976175065`*^9, 3.5053628749424677`*^9, {3.5133794606456194`*^9, 
   3.5133794610156198`*^9}, 3.513379498895673*^9, {3.5151820312260127`*^9, 
   3.515182034798419*^9}, {3.5165776638252892`*^9, 3.5165776818253145`*^9}, {
   3.516577719195367*^9, 3.516577782755456*^9}, 3.516577813575499*^9, {
   3.54630011842723*^9, 3.546300137437256*^9}, {3.548010088610395*^9, 
   3.548010088850395*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, {3.4979216146205826`*^9, 3.4979216448378353`*^9}, 
   3.497923923643038*^9, {3.4982412812142496`*^9, 3.4982412833342524`*^9}, {
   3.5023216899473925`*^9, 3.502321690259393*^9}, {3.5045895838424816`*^9, 
   3.5045895881124873`*^9}, {3.5053551461274347`*^9, 3.5053551625874577`*^9}, 
   3.5053551976375065`*^9, 3.505362881322477*^9, {3.513379488585658*^9, 
   3.513379494735667*^9}, 3.514145459054808*^9, {3.5410884317069707`*^9, 
   3.5410884457625957`*^9}, 3.5455832533222075`*^9, {3.5462999989370623`*^9, 
   3.5463000005470643`*^9}, {3.54630147593913*^9, 3.5463014785491333`*^9}, 
   3.5463015431992245`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, 
   3.545496835607242*^9, {3.545505444879295*^9, 3.545505445119295*^9}, {
   3.545505639229567*^9, 3.5455056444395742`*^9}, {3.5455068311112356`*^9, 
   3.5455068403012486`*^9}, {3.5455157795484548`*^9, 3.545515785354787*^9}, {
   3.545604160836763*^9, 3.5456041610407743`*^9}, {3.546299449516293*^9, 
   3.5462994497762938`*^9}, {3.5462995291664047`*^9, 3.5462995620464506`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.552.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, 
   3.4976416712695007`*^9, 3.497641808362542*^9, 3.49764211453668*^9, {
   3.497924167175066*^9, 3.4979241674870663`*^9}, {3.5053542426761694`*^9, 
   3.50535424295617*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 1 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 ", and ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.502990148351678*^9, 3.5029901655429077`*^9}, 
   3.505345087524409*^9, 3.512064342062512*^9, {3.5454307013060207`*^9, 
   3.545430711346035*^9}, {3.54550558430949*^9, 3.5455056165795355`*^9}, {
   3.548010098040408*^9, 3.548010098790409*^9}, {3.5480103078507023`*^9, 
   3.548010308550703*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.497641822620967*^9, 
   3.4976418815034714`*^9}, {3.498241427414454*^9, 3.498241427414454*^9}, {
   3.504395896295714*^9, 3.50439590067572*^9}, 3.5044706093797717`*^9, 
   3.5044710537703934`*^9, {3.5044821550764217`*^9, 3.504482155386422*^9}, {
   3.504988576070773*^9, 3.5049885764507737`*^9}, {3.506213896034247*^9, 
   3.5062138967830486`*^9}, {3.5062141332678576`*^9, 
   3.5062141507378817`*^9}, {3.5105084879028864`*^9, 3.510508488090087*^9}, {
   3.5130944226480646`*^9, 3.5130944467345066`*^9}, 3.51309510891803*^9, 
   3.514147239737301*^9, {3.514487372506321*^9, 3.5144873727363214`*^9}, {
   3.5165576820821433`*^9, 3.5165576820821433`*^9}, {3.5165582083062663`*^9, 
   3.5165582086338673`*^9}, 3.5165908254196434`*^9, {3.5454161012016726`*^9, 
   3.5454161012016726`*^9}, {3.545430104665186*^9, 3.545430105025186*^9}, {
   3.545505660519597*^9, 3.545505660519597*^9}, {3.5462996004865046`*^9, 
   3.5462996004865046`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.509829149023255*^9, 3.5098292074833364`*^9}, {
   3.510174642911626*^9, 3.51017464554803*^9}, {3.5101749019344807`*^9, 
   3.5101749115128975`*^9}, {3.5151682059644947`*^9, 
   3.5151682096244993`*^9}, {3.5165572858550477`*^9, 
   3.5165572982414694`*^9}, {3.5165573471007557`*^9, 3.51655734967476*^9}, {
   3.5165574453897276`*^9, 3.5165574940930133`*^9}, {3.516557561453932*^9, 
   3.5165575717343493`*^9}, {3.516557624244042*^9, 3.5165576267244463`*^9}, {
   3.545505496799368*^9, 3.545505530739415*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, 3.5114592311065884`*^9, 3.5118056919098177`*^9, 
   3.5141779771176*^9, 3.5145876116205716`*^9, 3.516558062505211*^9, 
   3.541090517116233*^9, 3.541090638890046*^9, {3.541090866307246*^9, 
   3.5410908672432475`*^9}, {3.54109091423053*^9, 3.541090921406543*^9}, {
   3.545491210931056*^9, 3.545491210931056*^9}, {3.545505469249329*^9, 
   3.54550547733934*^9}, {3.545505677859621*^9, 3.5455056788096223`*^9}, 
   3.546295577650872*^9, {3.5462996044465103`*^9, 3.5462996056165113`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["3:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, {
   3.54541627618718*^9, 3.545416318915655*^9}, {3.545416397555393*^9, 
   3.5454163977893934`*^9}, {3.5454168214081373`*^9, 
   3.5454168256513453`*^9}, {3.5454168857582507`*^9, 
   3.5454169106558943`*^9}, {3.5454170438021283`*^9, 
   3.5454170438021283`*^9}, {3.5454172983477755`*^9, 
   3.5454173176294093`*^9}, {3.545417477046089*^9, 3.545417477046089*^9}, 
   3.5454175123801513`*^9, 3.545418173946113*^9, {3.5454188654017277`*^9, 
   3.545418868272133*^9}, 3.5454190264096107`*^9, {3.5454190831157103`*^9, 
   3.545419098481737*^9}, {3.545420016893956*^9, 3.5454200195739603`*^9}, {
   3.5454302777654276`*^9, 3.5454302809754324`*^9}, 3.5454968581472735`*^9, {
   3.5455036760368185`*^9, 3.5455036774768205`*^9}, {3.5455949658741317`*^9, 
   3.5455949660641317`*^9}, {3.5456047607340746`*^9, 3.545604778867112*^9}, {
   3.546301969769821*^9, 3.546302015009885*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.5004296044446*^9, 3.5004296054856596`*^9}, {
   3.5012692292076674`*^9, 3.5012692361876774`*^9}, {3.503000515888104*^9, 
   3.503000515888104*^9}, {3.5030010047587886`*^9, 3.503001015708804*^9}, {
   3.503001063418871*^9, 3.503001064418872*^9}, {3.504243197472898*^9, 
   3.5042431987328997`*^9}, {3.5044146979829726`*^9, 3.5044146985729733`*^9}, 
   3.504482472366866*^9, 3.505193456354334*^9, 3.509828539372401*^9, {
   3.5101745056313844`*^9, 3.5101745056313844`*^9}, {3.5101794376000943`*^9, 
   3.510179438036895*^9}, {3.511720227183525*^9, 3.511720227183525*^9}, {
   3.545417174155957*^9, 3.545417174155957*^9}, {3.5454188726401405`*^9, 
   3.5454188726401405`*^9}, {3.545419213188739*^9, 3.545419215887543*^9}, {
   3.5454200243439665`*^9, 3.5454200243439665`*^9}, {3.5456047933699417`*^9, 
   3.5456047936379566`*^9}, 3.54630199731986*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095014754320154`*^9, 3.5095014757128158`*^9}, {
   3.509501663985547*^9, 3.5095016805839767`*^9}, {3.509828555552424*^9, 
   3.5098285973424826`*^9}, {3.509828656532565*^9, 3.509828698932625*^9}, {
   3.5098287432526865`*^9, 3.5098287837327433`*^9}, {3.5101746549548464`*^9, 
   3.5101746581060524`*^9}, {3.510174939280946*^9, 3.510174959092981*^9}, {
   3.5151682145645065`*^9, 3.5151682184145117`*^9}, {3.5454191112425594`*^9, 
   3.545419113769764*^9}, {3.5456047972231617`*^9, 3.545604800429345*^9}, {
   3.5463019720298243`*^9, 3.5463019738898273`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Defer", "[", "Int", "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, {
   3.509501480299224*^9, 3.5095014852600327`*^9}, {3.5095016962152033`*^9, 
   3.5095017075096235`*^9}, 3.5098286293025274`*^9, {3.509828898462904*^9, 
   3.5098289238329396`*^9}, {3.5098337006312838`*^9, 3.509833704827691*^9}, 
   3.5101745819155183`*^9, {3.510174660804857*^9, 3.5101746635348616`*^9}, {
   3.5101749657229924`*^9, 3.510174983897024*^9}, 3.510179441609301*^9, 
   3.510438752973152*^9, 3.511227636250307*^9, 3.5114939922953677`*^9, 
   3.511806385340789*^9, 3.514403488313138*^9, {3.515197880917452*^9, 
   3.5151978814790525`*^9}, {3.515978349796089*^9, 3.5159783519332933`*^9}, 
   3.5166675221732535`*^9, 3.5168206559364614`*^9, 3.5168238870016394`*^9, 
   3.5170754944729843`*^9, {3.517075645023195*^9, 3.5170756457431955`*^9}, 
   3.541090454410923*^9, 3.541090537708269*^9, 3.541090593571967*^9, {
   3.5419774852844076`*^9, 3.541977492824418*^9}, {3.545418900283389*^9, 
   3.5454189017497916`*^9}, {3.545419127232588*^9, 3.54541915136583*^9}, 
   3.545419192393902*^9, {3.5454192425703907`*^9, 3.545419243584392*^9}, {
   3.54542002674397*^9, 3.545420034433981*^9}, {3.5454210176773586`*^9, 
   3.545421021277364*^9}, {3.5454217048903217`*^9, 3.5454217071303253`*^9}, {
   3.5454217644704056`*^9, 3.5454217689004116`*^9}, {3.5455309252556715`*^9, 
   3.5455309319756804`*^9}, {3.5455950324942245`*^9, 
   3.5455950354242287`*^9}, {3.5456048055556383`*^9, 3.545604816504265*^9}, {
   3.546301980249836*^9, 3.5463019897698493`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["4.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, {3.5463150330395956`*^9, 3.546315033228606*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, 3.5454965509668436`*^9, 3.545496757657133*^9, 
   3.545496990437459*^9, {3.546125024823584*^9, 3.546125025683585*^9}, 
   3.546125194843822*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5144736871714077`*^9, 3.5144736908686147`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["b", "m"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
      RowBox[{"m", "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107893359082437`*^9, 3.5107893412382507`*^9}, 
   3.5107893780883026`*^9, 3.510845655897318*^9, {3.5144732957199206`*^9, 
   3.514473295938321*^9}, {3.5144733271383758`*^9, 3.514473389632086*^9}, {
   3.5144734208321404`*^9, 3.514473425184548*^9}, {3.514473474153034*^9, 
   3.514473504229887*^9}, {3.5151680954543395`*^9, 3.5151680980343432`*^9}, {
   3.5461251777937984`*^9, 3.546125187183811*^9}, {3.5461254243441434`*^9, 
   3.5461254246941442`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"b", "^", "m"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.5144735757092123`*^9, 3.5144736765009894`*^9}, {
   3.514473929112233*^9, 3.5144739317798376`*^9}, {3.514474664049924*^9, 
   3.5144746883547664`*^9}, {3.514474786463339*^9, 3.514474821750601*^9}, {
   3.514480701215327*^9, 3.514480722275364*^9}, {3.5144826692469826`*^9, 
   3.5144826753933935`*^9}, {3.514482761427544*^9, 3.514482763127947*^9}, {
   3.5144839879328985`*^9, 3.514484001598522*^9}, {3.5144840432037954`*^9, 
   3.514484047774604*^9}, {3.514484851062791*^9, 3.5144848577428007`*^9}, {
   3.514493953352398*^9, 3.5144939967024584`*^9}, {3.514494454233099*^9, 
   3.5144944881731462`*^9}, 3.5144963454557467`*^9, {3.5145667215746603`*^9, 
   3.5145667230846624`*^9}, {3.5145668019447727`*^9, 
   3.5145668201047983`*^9}, {3.514566854734847*^9, 3.5145668560148487`*^9}, 
   3.516821193357214*^9, {3.541896074432973*^9, 3.5418960757629747`*^9}, {
   3.5449827290444336`*^9, 3.544982734904442*^9}, 3.546106521254146*^9, {
   3.5461250507836204`*^9, 3.546125089773675*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454238599089427`*^9, 
   3.5454238602689433`*^9}, 3.5454965482568398`*^9, {3.545497042817532*^9, 
   3.545497042817532*^9}, {3.545497076297579*^9, 3.5454970772875805`*^9}, {
   3.545503623646745*^9, 3.5455036255667477`*^9}, {3.546105323118441*^9, 
   3.5461053352552624`*^9}, {3.5463150330395956`*^9, 3.546315033228606*^9}, {
   3.5473155234256926`*^9, 3.5473155342443113`*^9}, {3.547315597120908*^9, 
   3.5473156004600983`*^9}, {3.5473156558352656`*^9, 
   3.5473156567713194`*^9}, {3.5473164933751707`*^9, 3.5473164933751707`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}], "\[Element]", 
        "\[DoubleStruckCapitalZ]"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.4965117206885777`*^9, 3.5192471175756674`*^9, {3.5192587973599553`*^9, 
   3.5192588081399703`*^9}, {3.519321495105319*^9, 3.5193214991925263`*^9}, 
   3.5193247857072587`*^9, {3.5194051897010813`*^9, 3.5194051902791147`*^9}, {
   3.5194055551249824`*^9, 3.5194055708408813`*^9}, {3.519405711316916*^9, 
   3.51940572904193*^9}, {3.519410772192028*^9, 3.5194107776364374`*^9}, {
   3.519413782484516*^9, 3.519413782827717*^9}, {3.519767588664174*^9, 
   3.519767611128214*^9}, {3.5197937941314034`*^9, 3.519793794568204*^9}, {
   3.5197947626591043`*^9, 3.519794764749508*^9}, {3.519794865354085*^9, 
   3.519794874355301*^9}, {3.523218063086026*^9, 3.523218070356036*^9}, {
   3.523316514684347*^9, 3.523316514684347*^9}, {3.5233165475343933`*^9, 
   3.5233165475343933`*^9}, {3.5233184331871357`*^9, 
   3.5233184334271364`*^9}, {3.5273599103435545`*^9, 3.527359910608755*^9}, {
   3.5326424241029196`*^9, 3.53264242435292*^9}, {3.5326584126048727`*^9, 
   3.532658412794873*^9}, {3.532726454021428*^9, 3.5327264542814283`*^9}, {
   3.5327554047263184`*^9, 3.532755404993334*^9}, {3.532798666112293*^9, 
   3.532798676322307*^9}, {3.5328778343810363`*^9, 3.5328778343810363`*^9}, 
   3.5330758294771795`*^9, {3.5330827570868783`*^9, 3.533082757336879*^9}, {
   3.534975097668671*^9, 3.534975097888672*^9}, {3.536863459221404*^9, 
   3.536863459439804*^9}, {3.540264711953947*^9, 3.5402647253239655`*^9}, {
   3.540264783504047*^9, 3.540264783504047*^9}, {3.540502117527218*^9, 
   3.540502117997218*^9}, {3.540502551737826*^9, 3.540502551937826*^9}, {
   3.5449015667548094`*^9, 3.5449015920048447`*^9}, 3.5460201927633896`*^9, {
   3.5460203100335536`*^9, 3.5460203443436017`*^9}, {3.546020448093747*^9, 
   3.5460204510737514`*^9}, 3.5460205170338435`*^9, 3.5460207518641725`*^9, {
   3.5460226623068466`*^9, 3.5460226755968657`*^9}, {3.5460227177169247`*^9, 
   3.5460227177169247`*^9}, {3.546023707982313*^9, 3.546023708262314*^9}, {
   3.546792386446255*^9, 3.5467924010864344`*^9}, {3.546792513166156*^9, 
   3.546792513166156*^9}, {3.5468155143461714`*^9, 3.5468155145261717`*^9}, {
   3.547316201692487*^9, 3.547316219319495*^9}, {3.5473165991182184`*^9, 
   3.5473165991182184`*^9}, {3.547316771379071*^9, 3.5473167909261894`*^9}, 
   3.5473169753797393`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"n", "+", 
         FractionBox["1", "2"]}], "\[Element]", 
        SuperscriptBox["\[DoubleStruckCapitalZ]", "+"]}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.545415619784827*^9, 3.5454156634961042`*^9}, 
   3.5454967587771344`*^9, {3.5461251637537785`*^9, 3.54612516456378*^9}, 
   3.5461253929840994`*^9, {3.546214618327402*^9, 3.5462146288774166`*^9}, {
   3.54731553719248*^9, 3.547315538735568*^9}, {3.547315667657942*^9, 
   3.547315668602996*^9}, 3.5473169596018367`*^9, {3.547317005052437*^9, 
   3.547317005052437*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"f", "[", "z", "]"}]}]], 
     SqrtBox[
      RowBox[{"f", "[", "z", "]"}]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, 
   3.5145721515462685`*^9, {3.545415611111212*^9, 3.545415612296814*^9}, {
   3.5454156443548703`*^9, 3.5454156450100718`*^9}, {3.54612527918394*^9, 
   3.54612529305396*^9}, {3.546125371024069*^9, 3.546125374674074*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"n", "+", 
     FractionBox["1", "2"]}], "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalZ]", "+"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.5117295035766306`*^9, 3.511729505106633*^9}, {
   3.511750898236919*^9, 3.5117508991769204`*^9}, {3.5117555222533927`*^9, 
   3.5117555300634036`*^9}, {3.5118334045968*^9, 3.511833408403207*^9}, 
   3.5145720728661585`*^9, {3.514856031797722*^9, 3.5148560328117237`*^9}, {
   3.5151816617393637`*^9, 3.515181662316565*^9}, {3.545415625915638*^9, 
   3.5454156332008505`*^9}, {3.5454300704751377`*^9, 3.545430071215139*^9}, {
   3.546125159633773*^9, 3.546125160493774*^9}, {3.546214650777447*^9, 
   3.546214650777447*^9}, {3.547315700922845*^9, 3.547315700922845*^9}, {
   3.5473170462477927`*^9, 3.5473170462477927`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]]}], 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.5118158169600077`*^9, 
   3.511815862160071*^9}, 3.511815909280137*^9, {3.5118176520325766`*^9, 
   3.5118176689026003`*^9}, 3.5118179461929884`*^9, {3.511819812927603*^9, 
   3.5118198181376104`*^9}, {3.5118198622576723`*^9, 3.511819864577675*^9}, {
   3.5145719907960434`*^9, 3.51457201659608*^9}, {3.514572326606514*^9, 
   3.514572331676521*^9}, {3.51516810299435*^9, 3.515168104974353*^9}, {
   3.546125202673833*^9, 3.5461252302438717`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "^", 
     RowBox[{"(", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"b", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveIntegerQ", "[", 
     RowBox[{"n", "+", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.5117293456064095`*^9, 3.5117294275865245`*^9}, {3.5117296689768624`*^9, 
   3.5117296728068676`*^9}, {3.5117302889377303`*^9, 3.5117303011477475`*^9}, 
   3.5117466386965055`*^9, {3.511750894036913*^9, 3.511750894676914*^9}, {
   3.5117511267572393`*^9, 3.5117511307372446`*^9}, {3.5117512119573584`*^9, 
   3.511751214027361*^9}, {3.511751883348298*^9, 3.5117518878683043`*^9}, {
   3.5117519413583794`*^9, 3.511751948148389*^9}, {3.5117521986187396`*^9, 
   3.511752203998747*^9}, {3.511755503353366*^9, 3.5117555064233704`*^9}, {
   3.5118335100217853`*^9, 3.5118335340614276`*^9}, 3.5145720383461103`*^9, {
   3.5145721800463085`*^9, 3.5145722335263834`*^9}, {3.5145723389965315`*^9, 
   3.5145723423365355`*^9}, {3.5145724500966864`*^9, 3.514572450266687*^9}, 
   3.516820646406448*^9, {3.5418961167530327`*^9, 3.541896117983034*^9}, {
   3.5449827397744484`*^9, 3.544982749304462*^9}, 3.5461060983374033`*^9, {
   3.5461064994141073`*^9, 3.546106521269746*^9}, 3.546106612139906*^9, 
   3.546125075313655*^9, {3.546125116593713*^9, 3.546125139913745*^9}, {
   3.5462146339374237`*^9, 3.5462146423374357`*^9}, {3.547315350968828*^9, 
   3.5473153548750515`*^9}, {3.5473156828768125`*^9, 3.547315687131056*^9}, 
   3.5473170592375355`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}], "\[Element]", 
        SuperscriptBox["\[DoubleStruckCapitalZ]", "-"]}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.545415619784827*^9, 3.5454157083149824`*^9}, 
   3.5454967634471407`*^9, {3.546125151153761*^9, 3.5461251521137624`*^9}, 
   3.5461253959541035`*^9, {3.5462146659574685`*^9, 3.546214671897477*^9}, {
   3.5473155432078238`*^9, 3.547315544314887*^9}, {3.5473156744953327`*^9, 
   3.547315675358382*^9}, 3.5473169607639036`*^9, {3.547317009933716*^9, 
   3.547317009933716*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"f", "[", "z", "]"}]], 
     SqrtBox[
      RowBox[{"b", " ", 
       RowBox[{"f", "[", "z", "]"}]}]]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, {
   3.5118187344240923`*^9, 3.5118187409841013`*^9}, {3.514569048341924*^9, 
   3.5145690628419447`*^9}, {3.514572319246504*^9, 3.514572319846504*^9}, {
   3.545415686303344*^9, 3.545415693838157*^9}, {3.5461253188439956`*^9, 
   3.546125323414002*^9}, {3.5461253628140574`*^9, 3.546125366284062*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalZ]", "-"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.511729526906664*^9, 3.5117295274366646`*^9}, {
   3.511748932814161*^9, 3.511748933464162*^9}, {3.5117557724437428`*^9, 
   3.5117557724437428`*^9}, {3.511832614206211*^9, 3.511832614206211*^9}, {
   3.511832746213642*^9, 3.511832746213642*^9}, {3.5144963686357794`*^9, 
   3.514496369905781*^9}, {3.5144964549259*^9, 3.5144964623659105`*^9}, {
   3.514496962866611*^9, 3.5144969631666117`*^9}, {3.5144973205371118`*^9, 
   3.514497323707116*^9}, {3.5144981061082115`*^9, 3.514498107108213*^9}, {
   3.51456888104169*^9, 3.51456888104169*^9}, {3.514572358146558*^9, 
   3.5145723624865637`*^9}, {3.514856035354528*^9, 3.51485603646213*^9}, {
   3.5151816723941827`*^9, 3.515181672752983*^9}, {3.54541570104537*^9, 
   3.5454157031357737`*^9}, {3.5454300730151415`*^9, 
   3.5454300739051423`*^9}, {3.5461251557037673`*^9, 3.546125156553768*^9}, {
   3.546214680327489*^9, 3.546214680327489*^9}, {3.5473157085212793`*^9, 
   3.5473157085212793`*^9}, {3.5473170935334973`*^9, 3.5473170935334973`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "+", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]]}], 
      SqrtBox[
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.51174841818344*^9, 
   3.511748420833444*^9}, {3.511748497963552*^9, 3.5117484984135523`*^9}, {
   3.511818294033475*^9, 3.5118183236735168`*^9}, {3.5144968024863863`*^9, 
   3.5144968510064545`*^9}, {3.5144968866465044`*^9, 3.514496913836542*^9}, {
   3.514568305910885*^9, 3.5145683164908996`*^9}, {3.5145683572009563`*^9, 
   3.5145683609609623`*^9}, 3.514568478731127*^9, 3.514568528181196*^9, {
   3.5145685692312536`*^9, 3.5145686286113367`*^9}, {3.5145686608513813`*^9, 
   3.5145686672213907`*^9}, {3.5151681094443593`*^9, 
   3.5151681104843607`*^9}, {3.546125239623885*^9, 3.5461252659839215`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"b", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegativeIntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.511747293362056*^9, 3.5117472971996627`*^9}, {3.5117477460436506`*^9, 
   3.5117477523148623`*^9}, {3.5117479077127256`*^9, 3.511747926872752*^9}, {
   3.5117482704932337`*^9, 3.511748288643259*^9}, {3.511748542813615*^9, 
   3.511748551293627*^9}, {3.511750065125746*^9, 3.5117500670757484`*^9}, {
   3.5117558949839144`*^9, 3.511755900293922*^9}, 3.51183280157814*^9, {
   3.511832873725067*^9, 3.5118328862830887`*^9}, {3.5118329289491634`*^9, 
   3.5118329301035657`*^9}, {3.514496374415787*^9, 3.514496375635789*^9}, {
   3.514496438775877*^9, 3.514496443085883*^9}, {3.514496942236582*^9, 
   3.514496946806588*^9}, {3.514497149116872*^9, 3.5144971791969137`*^9}, 
   3.5144972624770308`*^9, {3.5144973102370973`*^9, 3.5144973301571255`*^9}, {
   3.514497805537791*^9, 3.5144978555678606`*^9}, 3.5144981017882056`*^9, {
   3.5145668229448023`*^9, 3.5145668520048428`*^9}, {3.5145683337309237`*^9, 
   3.514568353430951*^9}, 3.5145688737116795`*^9, {3.514568913051735*^9, 
   3.5145689928618464`*^9}, {3.5145723491465454`*^9, 3.514572351626549*^9}, 
   3.516820655546461*^9, {3.5418961219230394`*^9, 3.5418961224830403`*^9}, {
   3.544982754014468*^9, 3.5449827618644795`*^9}, 3.5461060983530035`*^9, {
   3.5461064994297075`*^9, 3.546106521269746*^9}, 3.546106612139906*^9, 
   3.546125075353655*^9, {3.546125336594021*^9, 3.5461253523540425`*^9}, {
   3.546214683267493*^9, 3.5462146889675007`*^9}, {3.5473153225242014`*^9, 
   3.5473153266344366`*^9}, {3.5473157111854315`*^9, 3.547315718008822*^9}, 
   3.5473171017279663`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
       "\[And]", " ", 
       RowBox[{
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}], "\[NotElement]", 
        "\[DoubleStruckCapitalZ]"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, {3.545064157588436*^9, 
   3.545064173278458*^9}, {3.545064245438559*^9, 3.545064245438559*^9}, {
   3.5450644846488943`*^9, 3.5450644846488943`*^9}, {3.5450645316189594`*^9, 
   3.545064533688963*^9}, 3.545064591839044*^9, 3.5454973483879595`*^9, 
   3.545506097840209*^9, 3.5455157193990145`*^9, 3.5462951690403004`*^9, {
   3.5462964020120263`*^9, 3.5462964133720427`*^9}, 3.5462966455623674`*^9, {
   3.5472311188349724`*^9, 3.54723116715504*^9}, {3.5472318015599303`*^9, 
   3.5472318067199373`*^9}, {3.5472325709010077`*^9, 
   3.5472325766810155`*^9}, {3.5472652760126*^9, 3.547265277682602*^9}, {
   3.547265325642669*^9, 3.547265351422705*^9}, {3.5473157817284665`*^9, 
   3.547315808787014*^9}, {3.547316456343052*^9, 3.5473164563440523`*^9}, 
   3.547316510131129*^9, {3.5473169647091293`*^9, 3.547316965009146*^9}, {
   3.5473170148439965`*^9, 3.5473170148439965`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "x", "]"}]}], ")"}], "n"], 
     SuperscriptBox[
      RowBox[{"f", "[", "x", "]"}], "n"]]}], "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 
   3.5118050348148956`*^9}, {3.5462953719105844`*^9, 
   3.5462953727405853`*^9}, {3.546295419610651*^9, 3.546295448940692*^9}, {
   3.546296444592086*^9, 3.5462964544221*^9}, {3.547231239455141*^9, 
   3.5472312497351556`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}, {3.5454155814555597`*^9, 3.545415582563162*^9}, {
   3.545430066735132*^9, 3.545430067215133*^9}, {3.546125031993594*^9, 
   3.546125032823595*^9}, {3.547265353742708*^9, 3.547265353742708*^9}, {
   3.5473158127892427`*^9, 3.5473158127892427`*^9}, {3.5473164670636654`*^9, 
   3.5473164670636654`*^9}, {3.5473171298465743`*^9, 3.5473171298465743`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}, 3.541101803256009*^9, {3.541115802450629*^9, 
   3.541115829936912*^9}, {3.5411170533806067`*^9, 3.541117065630624*^9}, {
   3.546296428072063*^9, 3.546296438832078*^9}, {3.546296483582141*^9, 
   3.5462964919121523`*^9}, {3.547231194825079*^9, 3.547231229775128*^9}, {
   3.547232589761034*^9, 3.5472325935810394`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}], "/", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9, {
   3.5410976974308376`*^9, 3.5410977100668592`*^9}, {3.5411018263752494`*^9, 
   3.5411018402280736`*^9}, {3.541116030157608*^9, 3.541116035122864*^9}, {
   3.541117072180633*^9, 3.5411170753206377`*^9}, {3.5450643579287167`*^9, 
   3.5450643666987286`*^9}, {3.5450644187188015`*^9, 
   3.5450644238188086`*^9}, {3.5462953176805086`*^9, 3.546295320140512*^9}, {
   3.5462965514222355`*^9, 3.546296585122283*^9}, 3.5462967357824936`*^9, {
   3.547231380239341*^9, 3.5472314258094044`*^9}, 3.5472318122599454`*^9, {
   3.5472326044910545`*^9, 3.547232608911061*^9}, {3.5472327472812543`*^9, 
   3.5472327734712915`*^9}, {3.5472653618527203`*^9, 
   3.5472653696227307`*^9}, {3.547315815603404*^9, 3.547315816334446*^9}, {
   3.5473164515197763`*^9, 3.547316451722788*^9}, 3.5473171399381514`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["5.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454159825478644`*^9, 
   3.54541600849071*^9}, {3.5454161483605556`*^9, 3.545416164506584*^9}, {
   3.5454163555601196`*^9, 3.545416365544137*^9}, {3.5454169374723415`*^9, 
   3.5454169458807564`*^9}, {3.545417574686661*^9, 3.545417598882303*^9}, {
   3.545417754289776*^9, 3.545417754289776*^9}, {3.54541778467863*^9, 
   3.5454177858642316`*^9}, {3.545418093543572*^9, 3.545418093543572*^9}, {
   3.5454192892300725`*^9, 3.5454192892300725`*^9}, {3.5454302686954155`*^9, 
   3.5454302688754153`*^9}, 3.545496843067252*^9, {3.5455036683168077`*^9, 
   3.5455036685068083`*^9}, {3.5455949509541106`*^9, 
   3.5455949511841106`*^9}, {3.5457198152069645`*^9, 
   3.5457198154999814`*^9}, {3.546059442036433*^9, 3.5460594424384565`*^9}, {
   3.5461052970351954`*^9, 3.5461053144604263`*^9}, {3.5461053461908817`*^9, 
   3.5461053471268835`*^9}, {3.546124692073118*^9, 3.5461246922431183`*^9}, {
   3.546191618490012*^9, 3.546191618990013*^9}, {3.5461930417920046`*^9, 
   3.546193042822006*^9}, {3.546199128980527*^9, 3.5461991297205276`*^9}, {
   3.546199707031336*^9, 3.5461997072613363`*^9}, {3.546315037540853*^9, 
   3.546315037820869*^9}, 3.5463152177901626`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454159825478644`*^9, 
   3.54541600849071*^9}, {3.5454161483605556`*^9, 3.545416164506584*^9}, {
   3.5454163555601196`*^9, 3.545416365544137*^9}, {3.5454169374723415`*^9, 
   3.5454169458807564`*^9}, {3.545417574686661*^9, 3.545417598882303*^9}, {
   3.545417754289776*^9, 3.545417754289776*^9}, {3.54541778467863*^9, 
   3.5454177858642316`*^9}, {3.545418093543572*^9, 3.545418093543572*^9}, {
   3.5454192892300725`*^9, 3.5454192892300725`*^9}, {3.5454302686954155`*^9, 
   3.5454302688754153`*^9}, 3.545496843067252*^9, {3.5455036683168077`*^9, 
   3.5455036685068083`*^9}, {3.5455949509541106`*^9, 
   3.5455949511841106`*^9}, {3.5457198152069645`*^9, 
   3.5457198154999814`*^9}, {3.546059442036433*^9, 3.5460594424384565`*^9}, {
   3.5461052970351954`*^9, 3.5461053144604263`*^9}, {3.5461053461908817`*^9, 
   3.5461053471268835`*^9}, {3.546124692073118*^9, 3.5461246922431183`*^9}, {
   3.546191618490012*^9, 3.546191618990013*^9}, {3.5461930417920046`*^9, 
   3.546193042822006*^9}, {3.546199128980527*^9, 3.5461991297205276`*^9}, {
   3.546199707031336*^9, 3.5461997072613363`*^9}, {3.546315037540853*^9, 
   3.546315037820869*^9}, {3.5463152228574524`*^9, 3.5463152303418803`*^9}, {
   3.547415118421036*^9, 3.547415118826637*^9}, {3.5480976263826227`*^9, 
   3.548097640232642*^9}, {3.5480980186531715`*^9, 3.5480980191131725`*^9}, 
   3.5481778156537595`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, 3.5454973450079556`*^9, {
   3.5454985936197033`*^9, 3.5454986135597315`*^9}, {3.5454987287398925`*^9, 
   3.545498734959901*^9}, 3.5454992694506493`*^9, 3.5455015297338133`*^9, 
   3.5455018032341967`*^9, 3.5455018638142815`*^9, {3.545501914164352*^9, 
   3.5455019220743628`*^9}, {3.5455024566751113`*^9, 
   3.5455024745051365`*^9}, {3.545502723515485*^9, 3.54550272724549*^9}, {
   3.545607251646547*^9, 3.5456072547447243`*^9}, {3.5456154995202985`*^9, 
   3.5456155180833597`*^9}, {3.545615605164341*^9, 3.5456156097026005`*^9}, {
   3.5456157101093435`*^9, 3.545615719889903*^9}, {3.5456158791160097`*^9, 
   3.5456158815921516`*^9}, {3.5456159667900248`*^9, 
   3.5456159681611032`*^9}, {3.545616362933683*^9, 3.5456163631596956`*^9}, {
   3.5456164161897287`*^9, 3.545616426060293*^9}, 3.5460551721230836`*^9, 
   3.5461915240998797`*^9, 3.5461918033502707`*^9, 3.5461930481420135`*^9, 
   3.5462009332730527`*^9, 3.5462016152640076`*^9, 3.5463157036909547`*^9, {
   3.5465384364433966`*^9, 3.5465384376033983`*^9}, {3.5469012978469825`*^9, 
   3.5469013047269917`*^9}, 3.5469058115133014`*^9, 3.5469058658233776`*^9, {
   3.546926483556588*^9, 3.5469264933846054`*^9}, {3.5474198675085*^9, 
   3.547419868038901*^9}, {3.548097495292439*^9, 3.548097513612465*^9}, {
   3.5480980195731726`*^9, 3.5480980200231733`*^9}, 3.548177817198162*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.509987368148217*^9, {3.5104261125494456`*^9, 3.510426116279451*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}], "z"], "\[Equal]", 
   RowBox[{"b", "+", 
    FractionBox["a", "z"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.5166724284966736`*^9, 3.51667246652954*^9}, {
   3.544997603799053*^9, 3.5449976318635025`*^9}, {3.5456073837761045`*^9, 
   3.5456074329989195`*^9}, {3.5456074895631547`*^9, 
   3.5456074915202665`*^9}, {3.5456158281470947`*^9, 3.545615853651553*^9}, {
   3.5456165778619757`*^9, 3.545616600080247*^9}, {3.5462016814041*^9, 
   3.5462016845341043`*^9}, {3.546905902823429*^9, 3.5469059108934402`*^9}, {
   3.5480977228027573`*^9, 3.5480977502727957`*^9}}],

Cell["\<\
Note: Although this is just a special case of the following rule, it is \
simpler and saves a trivial step.\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.5130948677012463`*^9, 3.513094868777648*^9}, {3.5130985654428687`*^9, 
   3.5130985665528708`*^9}, {3.5130991696337147`*^9, 
   3.5130991703437157`*^9}, {3.514149257920127*^9, 3.514149258420127*^9}, {
   3.5145964170042276`*^9, 3.5145964181642294`*^9}, {3.5417300030496244`*^9, 
   3.541730003455225*^9}, {3.548530949543024*^9, 3.54853106087318*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, 3.509938528846196*^9, {
   3.5099390241689568`*^9, 3.509939026446561*^9}, {3.5099391248983335`*^9, 
   3.509939129625142*^9}, {3.5101741545371675`*^9, 3.5101741545371675`*^9}, {
   3.5101804637230964`*^9, 3.510180464175497*^9}, {3.5104307281279087`*^9, 
   3.5104307283379087`*^9}, {3.510596793572122*^9, 3.5105967962521257`*^9}, {
   3.5105973346061244`*^9, 3.5105973348661246`*^9}, {3.5105983595375595`*^9, 
   3.5105983595375595`*^9}, {3.511721168434842*^9, 3.511721168434842*^9}, {
   3.512153856312028*^9, 3.512153856982029*^9}, {3.5121539269621267`*^9, 
   3.512153929892131*^9}, 3.513052839510186*^9, 3.514838602356208*^9, {
   3.545498534859621*^9, 3.5454985353796215`*^9}, {3.54549891314015*^9, 
   3.5454989145401525`*^9}, {3.546105915634282*^9, 3.546105915634282*^9}, {
   3.5469058925234146`*^9, 3.5469058925234146`*^9}, 3.547419933529815*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "b"}]}], " ", "x"}]}], " ",
   "+", 
  RowBox[{"a", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, 
   3.507580775876561*^9, {3.5075808517266674`*^9, 3.5075808618066816`*^9}, {
   3.507771267886224*^9, 3.507771338306322*^9}, {3.5077750940895863`*^9, 
   3.5077750969995904`*^9}, {3.5077754105500293`*^9, 3.5077754262100515`*^9}, 
   3.5077754729201164`*^9, {3.5077759620108013`*^9, 3.5077759784608245`*^9}, {
   3.5077776770532026`*^9, 3.5077777072532444`*^9}, {3.509985239743236*^9, 
   3.50998526384327*^9}, {3.509987215038003*^9, 3.509987346898187*^9}, 
   3.5104260735393915`*^9, {3.510428784095187*^9, 3.510428803355214*^9}, {
   3.5104289858954697`*^9, 3.5104289956154833`*^9}, {3.5104512488532076`*^9, 
   3.5104512676132336`*^9}, 3.5104513282733183`*^9, {3.5104525757750654`*^9, 
   3.51045259385509*^9}, {3.510453876910889*^9, 3.510453922550953*^9}, {
   3.510454085761182*^9, 3.510454091071189*^9}, {3.5104541579412823`*^9, 
   3.510454168161297*^9}, {3.510530323854356*^9, 3.510530330164365*^9}, {
   3.510611025794151*^9, 3.510611090050664*^9}, 3.5130296375354767`*^9, {
   3.51302977621972*^9, 3.513029778341324*^9}, {3.5146863659895983`*^9, 
   3.514686382307227*^9}, {3.5146867096738024`*^9, 3.5146867264438314`*^9}, {
   3.5148299940067673`*^9, 3.514830002346779*^9}, {3.514830047986843*^9, 
   3.5148300908769026`*^9}, {3.515187578650267*^9, 3.5151875974302936`*^9}, {
   3.5455017850941715`*^9, 3.5455018359142427`*^9}, {3.545607266296385*^9, 
   3.545607267808471*^9}, {3.545607596375264*^9, 3.5456075987734013`*^9}, {
   3.545615548917124*^9, 3.5456155698413205`*^9}, {3.5456156902972097`*^9, 
   3.545615700853814*^9}, {3.5456157358138137`*^9, 3.545615746525426*^9}, {
   3.545615893294821*^9, 3.545615897229046*^9}, {3.54561644802955*^9, 
   3.545616499650502*^9}, {3.5456165536185894`*^9, 3.5456165558037143`*^9}, {
   3.546201642024045*^9, 3.54620166694408*^9}, {3.5469013095569987`*^9, 
   3.546901318197011*^9}, {3.547419868834502*^9, 3.547419870238505*^9}, {
   3.548097523072478*^9, 3.54809757473255*^9}, {3.5480977691328225`*^9, 
   3.548097771142825*^9}, {3.548098020453174*^9, 3.548098021313175*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "x"}], " ", "+", " ", 
    RowBox[{"a", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.507486395872465*^9, 3.50748644954254*^9}, {
   3.5074944725478563`*^9, 3.507494494559495*^9}, {3.5074946945677853`*^9, 
   3.5074946980877905`*^9}, {3.507494901148075*^9, 3.5074949419981318`*^9}, {
   3.5074957249818935`*^9, 3.5074957317835054`*^9}, {3.507498957682372*^9, 
   3.507498975294803*^9}, 3.5075767853545046`*^9, 3.507580831786639*^9, {
   3.5075809662868276`*^9, 3.5075809692668324`*^9}, {3.5077712489761972`*^9, 
   3.5077712551362057`*^9}, {3.5077717557849126`*^9, 3.507771816284997*^9}, 
   3.507775224829769*^9, {3.507775455140092*^9, 3.5077754653101063`*^9}, 
   3.5077757871805563`*^9, {3.507775916570738*^9, 3.5077759642408047`*^9}, 
   3.507776008880867*^9, {3.50777771104325*^9, 3.5077777236732674`*^9}, {
   3.5099853835154386`*^9, 3.509985429525503*^9}, {3.5099854711155615`*^9, 
   3.5099854898355875`*^9}, {3.50998619167657*^9, 3.5099861963665767`*^9}, {
   3.5099874380583153`*^9, 3.509987492538391*^9}, {3.51042615829951*^9, 
   3.5104261867395496`*^9}, 3.5104262188695946`*^9, {3.510426269739666*^9, 
   3.5104262761096745`*^9}, {3.5104290794356003`*^9, 
   3.5104290888356133`*^9}, {3.5104291536757045`*^9, 3.510429159565713*^9}, {
   3.5104292694358664`*^9, 3.510429275025874*^9}, {3.5104293070859194`*^9, 
   3.5104293377959623`*^9}, 3.510451422603451*^9, {3.5104515553536367`*^9, 
   3.51045158679368*^9}, 3.5104518165940027`*^9, {3.5104518510140505`*^9, 
   3.510451852984053*^9}, {3.5104520740643625`*^9, 3.5104520772343674`*^9}, {
   3.5104522225545707`*^9, 3.510452235864589*^9}, {3.5104526595251827`*^9, 
   3.5104527673753333`*^9}, {3.5104536273705397`*^9, 
   3.5104536289005423`*^9}, {3.510453910900937*^9, 3.5104539149709425`*^9}, {
   3.5104539640810113`*^9, 3.5104539889210463`*^9}, {3.5104542120713587`*^9, 
   3.51045435582156*^9}, {3.5105298808437357`*^9, 3.510529881153736*^9}, {
   3.510530346304387*^9, 3.5105303713644223`*^9}, {3.510599863079664*^9, 
   3.5105998667696695`*^9}, {3.510600124900031*^9, 3.510600127900035*^9}, {
   3.5106054943864355`*^9, 3.5106054979900417`*^9}, {3.5106059737876773`*^9, 
   3.5106059774380836`*^9}, {3.510608000184437*^9, 3.5106080045836444`*^9}, {
   3.51060840628435*^9, 3.510608409139155*^9}, {3.5106111149639072`*^9, 
   3.5106111844620295`*^9}, 3.5106112168320866`*^9, {3.5106112484377418`*^9, 
   3.5106112639753695`*^9}, 3.5106116786084976`*^9, {3.513022655494813*^9, 
   3.5130226559628134`*^9}, 3.5130232039761763`*^9, 3.513029881223504*^9, {
   3.513030062027822*^9, 3.513030064336626*^9}, {3.5130304180672474`*^9, 
   3.513030466801733*^9}, {3.5130308460771995`*^9, 3.5130308478088026`*^9}, {
   3.5146673699537354`*^9, 3.5146673893437624`*^9}, {3.514667606319686*^9, 
   3.514667654991771*^9}, {3.5146698303307924`*^9, 3.5146698317971954`*^9}, {
   3.514670305663508*^9, 3.5146703358835506`*^9}, {3.5146704479137073`*^9, 
   3.5146704630337286`*^9}, 3.5146709820744553`*^9, {3.5146759715354824`*^9, 
   3.5146760019655247`*^9}, {3.51467676301659*^9, 3.5146767697566*^9}, {
   3.5146859006703806`*^9, 3.5146859603716855`*^9}, {3.514686011914176*^9, 
   3.5146860166409845`*^9}, {3.5146863874552364`*^9, 
   3.5146864315877137`*^9}, {3.5146875848857403`*^9, 3.514687614057791*^9}, {
   3.5148248808272715`*^9, 3.514824884967277*^9}, {3.514824916447321*^9, 
   3.514824919087325*^9}, {3.514825054837515*^9, 3.5148250635975275`*^9}, {
   3.514828109601799*^9, 3.514828113021804*^9}, {3.514828162133874*^9, 
   3.514828163773876*^9}, {3.5148284380665493`*^9, 3.5148284440465574`*^9}, {
   3.5148300119167924`*^9, 3.5148300156267977`*^9}, {3.5148302555571337`*^9, 
   3.5148303032572002`*^9}, 3.514830361697282*^9, {3.5454920420258284`*^9, 
   3.5454920420358286`*^9}, {3.545499027990311*^9, 3.545499039540327*^9}, {
   3.5455023247949266`*^9, 3.5455023261349287`*^9}, {3.545502385005011*^9, 
   3.5455024065650415`*^9}, {3.545584799878375*^9, 3.545584858868458*^9}, 
   3.5455848936785064`*^9, {3.545585117028819*^9, 3.5455851240588293`*^9}, 
   3.545587888748579*^9, {3.54560763877769*^9, 3.5456077075256214`*^9}, {
   3.5456156602564917`*^9, 3.545615664662744*^9}, {3.545615759567172*^9, 
   3.5456157843105874`*^9}, {3.5456159067435904`*^9, 3.545615910180787*^9}, {
   3.5456166161211643`*^9, 3.545616657400525*^9}, {3.54612490765342*^9, 
   3.54612490765342*^9}, {3.546124948943478*^9, 3.546124948953478*^9}, {
   3.546201698174124*^9, 3.5462017113341417`*^9}, {3.5469013411670427`*^9, 
   3.546901396797121*^9}, 3.5469027785190554`*^9, {3.5469063492740545`*^9, 
   3.546906352554059*^9}, 3.546926475428974*^9, {3.5474198708469057`*^9, 
   3.5474198717673073`*^9}, {3.5479153404259334`*^9, 3.547915342723065*^9}, {
   3.5480973942922974`*^9, 3.548097394722298*^9}, {3.5480974306523485`*^9, 
   3.548097433272352*^9}, {3.548097682842702*^9, 3.5480977141227455`*^9}, {
   3.5480977895528507`*^9, 3.548097791992854*^9}, 3.548098021823176*^9, {
   3.5480980733432484`*^9, 3.5480980738532486`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "\[NotEqual]", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, {3.545059739482077*^9, 
   3.5450597467048903`*^9}, {3.545060027396183*^9, 3.545060028035784*^9}, {
   3.545060112853133*^9, 3.545060112853133*^9}, {3.5450601569544106`*^9, 
   3.5450601580464125`*^9}, {3.5450602208677225`*^9, 3.545060232349343*^9}, {
   3.5450606692749104`*^9, 3.5450606695869107`*^9}, 3.5454973450079556`*^9, {
   3.5454985936197033`*^9, 3.5454986135597315`*^9}, {3.5454987287398925`*^9, 
   3.545498734959901*^9}, 3.5454992694506493`*^9, 3.5455015297338133`*^9, 
   3.5455018032341967`*^9, 3.5455018638142815`*^9, {3.545501914164352*^9, 
   3.5455019220743628`*^9}, {3.5455024566751113`*^9, 
   3.5455024745051365`*^9}, {3.545502723515485*^9, 3.54550272724549*^9}, {
   3.545607251646547*^9, 3.5456072547447243`*^9}, {3.5456154995202985`*^9, 
   3.5456155180833597`*^9}, {3.545615605164341*^9, 3.5456156097026005`*^9}, {
   3.5456157101093435`*^9, 3.545615719889903*^9}, {3.5456158791160097`*^9, 
   3.5456158815921516`*^9}, {3.5456159667900248`*^9, 
   3.5456159681611032`*^9}, {3.545616362933683*^9, 3.5456163631596956`*^9}, {
   3.5456164161897287`*^9, 3.545616426060293*^9}, 3.5460551721230836`*^9, 
   3.5461915240998797`*^9, 3.5461918033502707`*^9, 3.5461930481420135`*^9, 
   3.5462009332730527`*^9, 3.5462016152640076`*^9, 3.5463157036909547`*^9, {
   3.5465384364433966`*^9, 3.5465384376033983`*^9}, {3.5469012978469825`*^9, 
   3.5469013047269917`*^9}, 3.5469058115133014`*^9, 3.5469058658233776`*^9, {
   3.546926483556588*^9, 3.5469264933846054`*^9}, {3.5474198675085*^9, 
   3.547419868038901*^9}, 3.548097497382442*^9, {3.5480976454226494`*^9, 
   3.5480976664426785`*^9}, {3.548098022563177*^9, 3.548098023053178*^9}, 
   3.548177819226166*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.509987368148217*^9, {3.5104261125494456`*^9, 3.510426116279451*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "m"], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}], ")"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["z", "m"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", 
      RowBox[{"m", "+", "1"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.5166724284966736`*^9, 3.51667246652954*^9}, {
   3.544997603799053*^9, 3.5449976318635025`*^9}, {3.5456073837761045`*^9, 
   3.5456074329989195`*^9}, {3.5456074895631547`*^9, 
   3.5456074915202665`*^9}, {3.5456158281470947`*^9, 3.545615853651553*^9}, {
   3.5456165778619757`*^9, 3.545616600080247*^9}, {3.5462016814041*^9, 
   3.5462016845341043`*^9}, {3.546905902823429*^9, 3.5469059108934402`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[NotEqual]", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, 3.509938528846196*^9, {
   3.5099390241689568`*^9, 3.509939026446561*^9}, {3.5099391248983335`*^9, 
   3.509939129625142*^9}, {3.5101741545371675`*^9, 3.5101741545371675`*^9}, {
   3.5101804637230964`*^9, 3.510180464175497*^9}, {3.5104307281279087`*^9, 
   3.5104307283379087`*^9}, {3.510596793572122*^9, 3.5105967962521257`*^9}, {
   3.5105973346061244`*^9, 3.5105973348661246`*^9}, {3.5105983595375595`*^9, 
   3.5105983595375595`*^9}, {3.511721168434842*^9, 3.511721168434842*^9}, {
   3.512153856312028*^9, 3.512153856982029*^9}, {3.5121539269621267`*^9, 
   3.512153929892131*^9}, 3.513052839510186*^9, 3.514838602356208*^9, {
   3.545498534859621*^9, 3.5454985353796215`*^9}, {3.54549891314015*^9, 
   3.5454989145401525`*^9}, {3.546105915634282*^9, 3.546105915634282*^9}, {
   3.5469058925234146`*^9, 3.5469058925234146`*^9}, 3.547419933529815*^9, {
   3.5480978505129366`*^9, 3.548097880222978*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, 
   3.507580775876561*^9, {3.5075808517266674`*^9, 3.5075808618066816`*^9}, {
   3.507771267886224*^9, 3.507771338306322*^9}, {3.5077750940895863`*^9, 
   3.5077750969995904`*^9}, {3.5077754105500293`*^9, 3.5077754262100515`*^9}, 
   3.5077754729201164`*^9, {3.5077759620108013`*^9, 3.5077759784608245`*^9}, {
   3.5077776770532026`*^9, 3.5077777072532444`*^9}, {3.509985239743236*^9, 
   3.50998526384327*^9}, {3.509987215038003*^9, 3.509987346898187*^9}, 
   3.5104260735393915`*^9, {3.510428784095187*^9, 3.510428803355214*^9}, {
   3.5104289858954697`*^9, 3.5104289956154833`*^9}, {3.5104512488532076`*^9, 
   3.5104512676132336`*^9}, 3.5104513282733183`*^9, {3.5104525757750654`*^9, 
   3.51045259385509*^9}, {3.510453876910889*^9, 3.510453922550953*^9}, {
   3.510454085761182*^9, 3.510454091071189*^9}, {3.5104541579412823`*^9, 
   3.510454168161297*^9}, {3.510530323854356*^9, 3.510530330164365*^9}, {
   3.510611025794151*^9, 3.510611090050664*^9}, 3.5130296375354767`*^9, {
   3.51302977621972*^9, 3.513029778341324*^9}, {3.5146863659895983`*^9, 
   3.514686382307227*^9}, {3.5146867096738024`*^9, 3.5146867264438314`*^9}, {
   3.5148299940067673`*^9, 3.514830002346779*^9}, {3.514830047986843*^9, 
   3.5148300908769026`*^9}, {3.515187578650267*^9, 3.5151875974302936`*^9}, {
   3.5455017850941715`*^9, 3.5455018359142427`*^9}, {3.545607266296385*^9, 
   3.545607267808471*^9}, {3.545607596375264*^9, 3.5456075987734013`*^9}, {
   3.545615548917124*^9, 3.5456155698413205`*^9}, {3.5456156902972097`*^9, 
   3.545615700853814*^9}, {3.5456157358138137`*^9, 3.545615746525426*^9}, {
   3.545615893294821*^9, 3.545615897229046*^9}, {3.54561644802955*^9, 
   3.545616499650502*^9}, {3.5456165536185894`*^9, 3.5456165558037143`*^9}, {
   3.546201642024045*^9, 3.54620166694408*^9}, {3.5469013095569987`*^9, 
   3.546901318197011*^9}, {3.547419868834502*^9, 3.547419870238505*^9}, {
   3.548098023823179*^9, 3.548098025563181*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], ",", "x"}], "]"}]}], 
    " ", "+", " ", 
    RowBox[{"b", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.507486395872465*^9, 3.50748644954254*^9}, {
   3.5074944725478563`*^9, 3.507494494559495*^9}, {3.5074946945677853`*^9, 
   3.5074946980877905`*^9}, {3.507494901148075*^9, 3.5074949419981318`*^9}, {
   3.5074957249818935`*^9, 3.5074957317835054`*^9}, {3.507498957682372*^9, 
   3.507498975294803*^9}, 3.5075767853545046`*^9, 3.507580831786639*^9, {
   3.5075809662868276`*^9, 3.5075809692668324`*^9}, {3.5077712489761972`*^9, 
   3.5077712551362057`*^9}, {3.5077717557849126`*^9, 3.507771816284997*^9}, 
   3.507775224829769*^9, {3.507775455140092*^9, 3.5077754653101063`*^9}, 
   3.5077757871805563`*^9, {3.507775916570738*^9, 3.5077759642408047`*^9}, 
   3.507776008880867*^9, {3.50777771104325*^9, 3.5077777236732674`*^9}, {
   3.5099853835154386`*^9, 3.509985429525503*^9}, {3.5099854711155615`*^9, 
   3.5099854898355875`*^9}, {3.50998619167657*^9, 3.5099861963665767`*^9}, {
   3.5099874380583153`*^9, 3.509987492538391*^9}, {3.51042615829951*^9, 
   3.5104261867395496`*^9}, 3.5104262188695946`*^9, {3.510426269739666*^9, 
   3.5104262761096745`*^9}, {3.5104290794356003`*^9, 
   3.5104290888356133`*^9}, {3.5104291536757045`*^9, 3.510429159565713*^9}, {
   3.5104292694358664`*^9, 3.510429275025874*^9}, {3.5104293070859194`*^9, 
   3.5104293377959623`*^9}, 3.510451422603451*^9, {3.5104515553536367`*^9, 
   3.51045158679368*^9}, 3.5104518165940027`*^9, {3.5104518510140505`*^9, 
   3.510451852984053*^9}, {3.5104520740643625`*^9, 3.5104520772343674`*^9}, {
   3.5104522225545707`*^9, 3.510452235864589*^9}, {3.5104526595251827`*^9, 
   3.5104527673753333`*^9}, {3.5104536273705397`*^9, 
   3.5104536289005423`*^9}, {3.510453910900937*^9, 3.5104539149709425`*^9}, {
   3.5104539640810113`*^9, 3.5104539889210463`*^9}, {3.5104542120713587`*^9, 
   3.51045435582156*^9}, {3.5105298808437357`*^9, 3.510529881153736*^9}, {
   3.510530346304387*^9, 3.5105303713644223`*^9}, {3.510599863079664*^9, 
   3.5105998667696695`*^9}, {3.510600124900031*^9, 3.510600127900035*^9}, {
   3.5106054943864355`*^9, 3.5106054979900417`*^9}, {3.5106059737876773`*^9, 
   3.5106059774380836`*^9}, {3.510608000184437*^9, 3.5106080045836444`*^9}, {
   3.51060840628435*^9, 3.510608409139155*^9}, {3.5106111149639072`*^9, 
   3.5106111844620295`*^9}, 3.5106112168320866`*^9, {3.5106112484377418`*^9, 
   3.5106112639753695`*^9}, 3.5106116786084976`*^9, {3.513022655494813*^9, 
   3.5130226559628134`*^9}, 3.5130232039761763`*^9, 3.513029881223504*^9, {
   3.513030062027822*^9, 3.513030064336626*^9}, {3.5130304180672474`*^9, 
   3.513030466801733*^9}, {3.5130308460771995`*^9, 3.5130308478088026`*^9}, {
   3.5146673699537354`*^9, 3.5146673893437624`*^9}, {3.514667606319686*^9, 
   3.514667654991771*^9}, {3.5146698303307924`*^9, 3.5146698317971954`*^9}, {
   3.514670305663508*^9, 3.5146703358835506`*^9}, {3.5146704479137073`*^9, 
   3.5146704630337286`*^9}, 3.5146709820744553`*^9, {3.5146759715354824`*^9, 
   3.5146760019655247`*^9}, {3.51467676301659*^9, 3.5146767697566*^9}, {
   3.5146859006703806`*^9, 3.5146859603716855`*^9}, {3.514686011914176*^9, 
   3.5146860166409845`*^9}, {3.5146863874552364`*^9, 
   3.5146864315877137`*^9}, {3.5146875848857403`*^9, 3.514687614057791*^9}, {
   3.5148248808272715`*^9, 3.514824884967277*^9}, {3.514824916447321*^9, 
   3.514824919087325*^9}, {3.514825054837515*^9, 3.5148250635975275`*^9}, {
   3.514828109601799*^9, 3.514828113021804*^9}, {3.514828162133874*^9, 
   3.514828163773876*^9}, {3.5148284380665493`*^9, 3.5148284440465574`*^9}, {
   3.5148300119167924`*^9, 3.5148300156267977`*^9}, {3.5148302555571337`*^9, 
   3.5148303032572002`*^9}, 3.514830361697282*^9, {3.5454920420258284`*^9, 
   3.5454920420358286`*^9}, {3.545499027990311*^9, 3.545499039540327*^9}, {
   3.5455023247949266`*^9, 3.5455023261349287`*^9}, {3.545502385005011*^9, 
   3.5455024065650415`*^9}, {3.545584799878375*^9, 3.545584858868458*^9}, 
   3.5455848936785064`*^9, {3.545585117028819*^9, 3.5455851240588293`*^9}, 
   3.545587888748579*^9, {3.54560763877769*^9, 3.5456077075256214`*^9}, {
   3.5456156602564917`*^9, 3.545615664662744*^9}, {3.545615759567172*^9, 
   3.5456157843105874`*^9}, {3.5456159067435904`*^9, 3.545615910180787*^9}, {
   3.5456166161211643`*^9, 3.545616657400525*^9}, {3.54612490765342*^9, 
   3.54612490765342*^9}, {3.546124948943478*^9, 3.546124948953478*^9}, {
   3.546201698174124*^9, 3.5462017113341417`*^9}, {3.5469013411670427`*^9, 
   3.546901396797121*^9}, 3.5469027785190554`*^9, {3.5469063492740545`*^9, 
   3.546906352554059*^9}, 3.546926475428974*^9, {3.5474198708469057`*^9, 
   3.5474198717673073`*^9}, {3.5479153404259334`*^9, 3.547915342723065*^9}, 
   3.548097379682277*^9, {3.54809783206291*^9, 3.548097843282926*^9}, {
   3.5480980271131835`*^9, 3.5480980304331884`*^9}, {3.5480980744232492`*^9, 
   3.5480980756832514`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, 
   3.5449734027198133`*^9, {3.544973705703545*^9, 3.5449737123023567`*^9}, {
   3.5449743847103376`*^9, 3.5449743847103376`*^9}, {3.5449897190542192`*^9, 
   3.5449897371142445`*^9}, 3.54501330464754*^9, 3.5450140205483975`*^9, {
   3.5450140745556927`*^9, 3.545014074867693*^9}, {3.545014174442668*^9, 
   3.5450141765018716`*^9}, 3.5450143633121996`*^9, {3.5450664467216406`*^9, 
   3.5450664468916407`*^9}, {3.5450708578278165`*^9, 3.545070858737818*^9}, {
   3.5454157832263145`*^9, 3.5454158086387587`*^9}, {3.5454159825478644`*^9, 
   3.54541600849071*^9}, {3.5454302617354054`*^9, 3.5454302618654056`*^9}, 
   3.5454968316872363`*^9, {3.5455036591867948`*^9, 3.545503659346795*^9}, {
   3.545719271536868*^9, 3.5457192717468805`*^9}, {3.5460594393562803`*^9, 
   3.5460594398653092`*^9}, {3.5461052955219927`*^9, 3.546105342478075*^9}, {
   3.5461067465029416`*^9, 3.5461067466901417`*^9}, {3.546191611830003*^9, 
   3.5461916123600035`*^9}, {3.5461960374161987`*^9, 3.546196045076209*^9}, {
   3.546196224796461*^9, 3.546196225006461*^9}, 3.5462008183828917`*^9, {
   3.546200898673004*^9, 3.5462008988630047`*^9}, {3.5462062345756645`*^9, 
   3.5462062347856646`*^9}, 3.5463152369822607`*^9, {3.546537887452628*^9, 
   3.546537900732647*^9}, {3.546538613023644*^9, 3.5465386133936443`*^9}, 
   3.548177925321952*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159062169304`*^9, 3.5454159331113777`*^9}, 
   3.54549683416724*^9, 3.5461062300796347`*^9, {3.5461064168431625`*^9, 
   3.5461064441432104`*^9}, 3.5461960406562033`*^9, {3.5462067693364134`*^9, 
   3.546206792716446*^9}, 3.54631573298063*^9, {3.5465333983763437`*^9, 
   3.546533398676344*^9}, {3.54653356727658*^9, 3.546533568866582*^9}, {
   3.5465380353828354`*^9, 3.5465380353828354`*^9}, 3.5481779689396286`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence ",
 "3",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   SuperscriptBox["a", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", 
   RowBox[{"2", "a", " ", "b"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", 
   SuperscriptBox["b", "2"]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.504923521959998*^9, 3.504923555010044*^9}, 3.504923770360346*^9, 
   3.505345123254459*^9, 3.5120643645025434`*^9, {3.5454306300659213`*^9, 
   3.5454306300659213`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[GreaterEqual]", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.5004296044446*^9, 3.5004296054856596`*^9}, {
   3.500564276738323*^9, 3.500564276738323*^9}, {3.500564478977479*^9, 
   3.500564478977479*^9}, {3.5012690944074793`*^9, 3.501269096907482*^9}, {
   3.502989419757598*^9, 3.5029894266684093`*^9}, {3.504382491914279*^9, 
   3.5043824931842804`*^9}, 3.5044145181527205`*^9, 3.5044145651527863`*^9, {
   3.5048326294605317`*^9, 3.5048326318105345`*^9}, {3.504832848270838*^9, 
   3.504832848820839*^9}, {3.5048395473922195`*^9, 3.504839551752225*^9}, {
   3.5048396769524*^9, 3.504839677692402*^9}, {3.508452034081811*^9, 
   3.508452034081811*^9}, 3.5098354484687543`*^9, 3.509911360347663*^9, {
   3.5101827988991985`*^9, 3.5101828019568033`*^9}, {3.5101832031707087`*^9, 
   3.5101832041847105`*^9}, {3.5117201893934717`*^9, 
   3.5117201893934717`*^9}, {3.513095241718216*^9, 3.513095242088216*^9}, 
   3.514142335340435*^9, {3.5141424490905943`*^9, 3.51414246048061*^9}, {
   3.514743996101736*^9, 3.5147439975317383`*^9}, {3.5147440486318097`*^9, 
   3.514744051131813*^9}, {3.5147478342170925`*^9, 3.5147478342170925`*^9}, {
   3.514750376522465*^9, 3.5147503771424665`*^9}, {3.514846444067275*^9, 
   3.514846444067275*^9}, {3.516667472845967*^9, 3.516667473703968*^9}, {
   3.51684679198973*^9, 3.516846798265088*^9}, {3.545415861632052*^9, 
   3.545415862724054*^9}, {3.545430100045179*^9, 3.54543010057518*^9}, {
   3.5461064498996205`*^9, 3.5461064498996205`*^9}, {3.5462067963764515`*^9, 
   3.5462067963764515`*^9}, {3.546533430096388*^9, 3.546533430396388*^9}, {
   3.5465335834566026`*^9, 3.5465335834566026`*^9}, {3.5465380436628466`*^9, 
   3.5465380436628466`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"m", "+", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "2"}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5098355380753117`*^9, 3.509835661752329*^9}, {3.509835695323588*^9, 
   3.509835698927194*^9}, {3.50983577051572*^9, 3.5098358512614617`*^9}, {
   3.5101827368266892`*^9, 3.510182745344304*^9}, {3.5101829999523516`*^9, 
   3.510183019686386*^9}, {3.5141418979198227`*^9, 3.5141419241998596`*^9}, {
   3.5147435787611513`*^9, 3.5147435797411532`*^9}, {3.5147476814772243`*^9, 
   3.514747716062485*^9}, {3.5151681708944454`*^9, 3.5151681725644474`*^9}, {
   3.5168440232983694`*^9, 3.51684405670028*^9}, {3.5168440956495075`*^9, 
   3.5168441158936653`*^9}, 3.546106235056043*^9, {3.5461063609170647`*^9, 
   3.546106405517543*^9}, 3.5461064579336348`*^9, 3.5462068181864815`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}, {
   3.5147491445027356`*^9, 3.514749148342741*^9}, {3.5147494086131053`*^9, 
   3.5147494108531084`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"b", "^", "2"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "2"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "*", 
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "+", 
              RowBox[{"b", "^", "2"}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "+", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.5098354697627916`*^9, 3.5098355203848805`*^9}, 3.5098359872937007`*^9, {
   3.5098960849679213`*^9, 3.5098960888835287`*^9}, {3.510182753081918*^9, 
   3.510182757356325*^9}, {3.510182792409587*^9, 3.51018279393839*^9}, {
   3.5101831393977966`*^9, 3.510183166900645*^9}, 3.5101832074919157`*^9, {
   3.511230925630887*^9, 3.511231030416271*^9}, {3.511231196884164*^9, 
   3.51123121187579*^9}, {3.51137244511103*^9, 3.5113724654451933`*^9}, {
   3.5141421386201596`*^9, 3.5141421590801883`*^9}, {3.51414236028047*^9, 
   3.5141423608904705`*^9}, {3.5141424184805517`*^9, 
   3.5141424322505703`*^9}, {3.5141460785056753`*^9, 
   3.5141460939756975`*^9}, {3.5147439520716743`*^9, 3.514743957471682*^9}, {
   3.5147439903217278`*^9, 3.51474399196173*^9}, {3.514747841127905*^9, 
   3.5147478750579643`*^9}, {3.5147491159326954`*^9, 3.514749138692727*^9}, {
   3.5147494142431135`*^9, 3.514749424923128*^9}, {3.5147503475624247`*^9, 
   3.5147503486024265`*^9}, {3.5147503951024914`*^9, 3.514750400342499*^9}, {
   3.514750467732593*^9, 3.514750472272599*^9}, {3.514845069856061*^9, 
   3.5148450718840647`*^9}, {3.514846430214451*^9, 3.514846438903666*^9}, {
   3.5159782709847507`*^9, 3.5159782725447536`*^9}, {3.516667438541507*^9, 
   3.5166674656699543`*^9}, 3.516820655696461*^9, {3.5168437743921328`*^9, 
   3.5168437759472218`*^9}, {3.5168442302392054`*^9, 3.516844262995079*^9}, {
   3.5168467726686244`*^9, 3.5168467756947975`*^9}, {3.516846975037199*^9, 
   3.5168469753042145`*^9}, 3.5410904438965044`*^9, 3.541090513902627*^9, 
   3.5410906443968563`*^9, {3.5454912109010563`*^9, 3.545491210911056*^9}, {
   3.5460408169830155`*^9, 3.5460408196330194`*^9}, 3.5460411154434333`*^9, {
   3.5461059982476273`*^9, 3.5461060224900703`*^9}, 3.546106098384203*^9, {
   3.546106499460908*^9, 3.546106521316546*^9}, {3.546106582843054*^9, 
   3.546106645742365*^9}, {3.546106706426471*^9, 3.546106716020488*^9}, {
   3.546206742026375*^9, 3.546206744186378*^9}, {3.5462068004164567`*^9, 
   3.546206808326468*^9}, 3.546206847336522*^9, {3.5465334341363935`*^9, 
   3.546533434406394*^9}, 3.5465335859866056`*^9, 3.546538046732851*^9, 
   3.5479576181733294`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"m", "<", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.545496832817238*^9, {3.546106225945627*^9, 3.5461062803429227`*^9}, 
   3.5461960392762012`*^9, {3.5462067741964197`*^9, 3.5462067744464207`*^9}, 
   3.546208197008412*^9, 3.5463157402110434`*^9, 3.5465334384263997`*^9, 
   3.548177970062831*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence ",
 "4",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   SuperscriptBox["a", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", 
   RowBox[{"2", "a", " ", "b"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", 
   SuperscriptBox["b", "2"]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.504923521959998*^9, 3.504923555010044*^9}, 3.504923770360346*^9, {
   3.504924121650838*^9, 3.504924125290843*^9}, 3.505345087524409*^9, 
   3.512064374152557*^9, {3.545430563525828*^9, 3.545430563525828*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511720157673427*^9, 3.5117201786434565`*^9}, {3.514744003801747*^9, 
   3.5147440340117893`*^9}, {3.5147478169478626`*^9, 
   3.5147478169478626`*^9}, {3.514750371932459*^9, 3.5147503725724597`*^9}, {
   3.516667478009576*^9, 3.5166674796787786`*^9}, {3.516817799992463*^9, 
   3.516817803002467*^9}, {3.5168465845798664`*^9, 3.516846584748876*^9}, {
   3.5168467054147778`*^9, 3.5168467143122864`*^9}, {3.5454158569364433`*^9, 
   3.545415858231246*^9}, {3.545430095675173*^9, 3.5454300964251738`*^9}, {
   3.5461062883457365`*^9, 3.5461062883457365`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "1"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "1"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.5147476258631268`*^9, 3.514747668217201*^9}, {
   3.515168162984434*^9, 3.515168166514439*^9}, {3.5168172892217484`*^9, 
   3.516817329061804*^9}, {3.5168173611018486`*^9, 3.5168174045619097`*^9}, 
   3.546106238332049*^9, {3.54610630159016*^9, 3.5461063479534416`*^9}, 
   3.546533458646428*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "*", 
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"a", "^", "2"}], "+", 
                 RowBox[{"b", "^", "2"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.5141423751504908`*^9, 
   3.5141423757704916`*^9}, {3.5147439123716187`*^9, 3.514743933871649*^9}, 
   3.5147446642726717`*^9, {3.514747728448907*^9, 3.5147478089606485`*^9}, {
   3.5147490781026425`*^9, 3.514749100622674*^9}, {3.5147503434924192`*^9, 
   3.51475034434242*^9}, {3.5147503886824827`*^9, 3.514750391992487*^9}, {
   3.5148450753940706`*^9, 3.5148450784048758`*^9}, 3.5148464258932433`*^9, {
   3.515978258507929*^9, 3.5159782601459317`*^9}, {3.516667408215053*^9, 
   3.5166674330346966`*^9}, 3.516817705502331*^9, {3.516817855572541*^9, 
   3.516817866932557*^9}, {3.5168430219180937`*^9, 3.5168430349398384`*^9}, {
   3.5168430993135204`*^9, 3.5168431185036182`*^9}, {3.516843294539687*^9, 
   3.516843311431653*^9}, {3.5168435329023204`*^9, 3.516843534695423*^9}, {
   3.516846645594356*^9, 3.5168466906729345`*^9}, 3.541090442320902*^9, {
   3.5410905022494063`*^9, 3.541090505775013*^9}, {3.545491210881056*^9, 
   3.545491210891056*^9}, {3.546040807493002*^9, 3.5460408098630056`*^9}, 
   3.5460411063934207`*^9, {3.546105998216427*^9, 3.54610602247447*^9}, 
   3.5461060983530035`*^9, {3.5461064994453077`*^9, 3.546106521300946*^9}, {
   3.546106582749454*^9, 3.5461066307663383`*^9}, {3.5461066669272017`*^9, 
   3.5461066820124283`*^9}, 3.54620686705655*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["3.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "\[NotEqual]", "2"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, {
   3.5449740914142227`*^9, 3.544974113394661*^9}, {3.544974297599785*^9, 
   3.5449743180826206`*^9}, 3.545013646990142*^9, 3.5454968080172033`*^9, {
   3.5460546827523985`*^9, 3.5460546942424145`*^9}, {3.546054727652461*^9, 
   3.5460547381924763`*^9}, {3.5460547979225597`*^9, 3.546054804832569*^9}, {
   3.546054941882761*^9, 3.5460549474927692`*^9}, 3.5461915423799057`*^9, {
   3.5461915817099605`*^9, 3.5461915819499607`*^9}, 3.5461961103163004`*^9, {
   3.546196164656377*^9, 3.5461961874164085`*^9}, 3.546197012837564*^9, {
   3.5462005531025205`*^9, 3.5462005600625305`*^9}, {3.546209916120819*^9, 
   3.546209916120819*^9}, 3.546315250839053*^9, {3.5481778714082575`*^9, 
   3.5481778830302777`*^9}, {3.5481779301735606`*^9, 3.5481779523255997`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, {
   3.5449740914142227`*^9, 3.544974113394661*^9}, {3.544974297599785*^9, 
   3.5449743180826206`*^9}, 3.545013646990142*^9, 3.5454968080172033`*^9, {
   3.5460546827523985`*^9, 3.5460546942424145`*^9}, {3.546054727652461*^9, 
   3.5460547381924763`*^9}, {3.5460547979225597`*^9, 3.546054804832569*^9}, {
   3.546054941882761*^9, 3.5460549474927692`*^9}, 3.5461915423799057`*^9, {
   3.5461915817099605`*^9, 3.5461915819499607`*^9}, 3.5461961103163004`*^9, {
   3.546196164656377*^9, 3.5461961874164085`*^9}, 3.546197012837564*^9, {
   3.5462005531025205`*^9, 3.5462005600625305`*^9}, 3.546315233972088*^9, {
   3.546537994952779*^9, 3.5465380149828067`*^9}, {3.5465386159836483`*^9, 
   3.546538616183648*^9}, {3.546538663693715*^9, 3.5465386673137197`*^9}, {
   3.548177889379489*^9, 3.548177896914302*^9}, {3.5481779982364798`*^9, 
   3.548178004928892*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.4965117206885777`*^9, 3.5192471175756674`*^9, {3.5192587973599553`*^9, 
   3.5192588081399703`*^9}, {3.519321495105319*^9, 3.5193214991925263`*^9}, 
   3.5193247857072587`*^9, {3.5194051897010813`*^9, 3.5194051902791147`*^9}, {
   3.5194055551249824`*^9, 3.5194055708408813`*^9}, {3.519405711316916*^9, 
   3.51940572904193*^9}, {3.519410772192028*^9, 3.5194107776364374`*^9}, {
   3.519413782484516*^9, 3.519413782827717*^9}, {3.519767588664174*^9, 
   3.519767611128214*^9}, {3.5197937941314034`*^9, 3.519793794568204*^9}, {
   3.5197947626591043`*^9, 3.519794764749508*^9}, {3.519794865354085*^9, 
   3.519794874355301*^9}, {3.523218063086026*^9, 3.523218070356036*^9}, {
   3.523316514684347*^9, 3.523316514684347*^9}, {3.5233165475343933`*^9, 
   3.5233165475343933`*^9}, {3.5233184331871357`*^9, 
   3.5233184334271364`*^9}, {3.5273599103435545`*^9, 3.527359910608755*^9}, {
   3.5326424241029196`*^9, 3.53264242435292*^9}, {3.5326584126048727`*^9, 
   3.532658412794873*^9}, {3.532726454021428*^9, 3.5327264542814283`*^9}, {
   3.5327554047263184`*^9, 3.532755404993334*^9}, {3.532798666112293*^9, 
   3.532798676322307*^9}, {3.5328778343810363`*^9, 3.5328778343810363`*^9}, 
   3.5330758294771795`*^9, {3.5330827570868783`*^9, 3.533082757336879*^9}, {
   3.534975097668671*^9, 3.534975097888672*^9}, {3.536863459221404*^9, 
   3.536863459439804*^9}, {3.540264711953947*^9, 3.5402647253239655`*^9}, {
   3.540264783504047*^9, 3.540264783504047*^9}, {3.540502117527218*^9, 
   3.540502117997218*^9}, {3.540502551737826*^9, 3.540502551937826*^9}, {
   3.5449015667548094`*^9, 3.5449015920048447`*^9}, {3.544901714065016*^9, 
   3.544901727955035*^9}, 3.544911958524931*^9, {3.5449122781717815`*^9, 
   3.5449122781717815`*^9}, {3.5455187047402697`*^9, 
   3.5455187052402706`*^9}, {3.545518923250576*^9, 3.545518930270586*^9}, 
   3.545520507632794*^9, {3.545529645239874*^9, 3.545529645239874*^9}, {
   3.5455298056500983`*^9, 3.5455298100201044`*^9}, {3.545576232782379*^9, 
   3.545576234112381*^9}, {3.5455766240529265`*^9, 3.54557662626293*^9}, {
   3.5455767774631414`*^9, 3.5455767774631414`*^9}, 3.5455787391558876`*^9, {
   3.54558369792283*^9, 3.54558369792283*^9}, 3.545594489353464*^9, {
   3.545594748353827*^9, 3.545594748953828*^9}, {3.5455949452441025`*^9, 
   3.5455949460241036`*^9}, {3.545596656906499*^9, 3.545596657126499*^9}, {
   3.545596769036656*^9, 3.545596769036656*^9}, {3.546055330183305*^9, 
   3.546055331763307*^9}, {3.546056658255164*^9, 3.546056659885166*^9}, {
   3.546059263352213*^9, 3.546059265128315*^9}, 3.5461915558399243`*^9, {
   3.5461997661014185`*^9, 3.5461997661014185`*^9}, 3.546200542232505*^9, {
   3.5462010127931643`*^9, 3.5462010129631643`*^9}, {3.546205617934801*^9, 
   3.546205632094821*^9}, 3.546315693455369*^9, {3.5465325685451813`*^9, 
   3.5465325685451813`*^9}, {3.5465392871545877`*^9, 3.546539298064603*^9}, {
   3.546543658868208*^9, 3.5465436699282236`*^9}, {3.5481780127913055`*^9, 
   3.548178013680507*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 8 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.504905059830614*^9, 3.5049051008006716`*^9}, {
   3.5049062442122726`*^9, 3.5049062459122753`*^9}, 3.505345087554409*^9, 
   3.5120642138723326`*^9, {3.513276979592985*^9, 3.513276981292988*^9}, {
   3.5147754897687864`*^9, 3.5147754924207907`*^9}, {3.515187407180027*^9, 
   3.5151874102100315`*^9}, {3.545590336281943*^9, 3.5455903388632736`*^9}, {
   3.5455906008904057`*^9, 3.5455906214425817`*^9}, 3.5455907444744587`*^9, {
   3.548010309860705*^9, 3.548010310300705*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]],
 " , then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018083840990562`*^9, 
   3.5018084166251135`*^9}, {3.501909321191126*^9, 3.5019093296931405`*^9}, {
   3.5019839735447097`*^9, 3.5019839735447097`*^9}, {3.5023141785029993`*^9, 
   3.502314184165809*^9}, {3.5044889120340166`*^9, 3.504488913014018*^9}, {
   3.5044895507549105`*^9, 3.504489551014911*^9}, 3.5046347745607986`*^9, 
   3.504639967338069*^9, {3.504640184428373*^9, 3.504640184428373*^9}, {
   3.504642080291027*^9, 3.504642107451065*^9}, {3.5136572146507573`*^9, 
   3.5136572345207853`*^9}, {3.515020577353009*^9, 3.5150206093718405`*^9}, {
   3.516581087830083*^9, 3.5165810976000967`*^9}, {3.5165888639388065`*^9, 
   3.5165888651088085`*^9}, {3.54558997173391*^9, 3.5455899737400246`*^9}, {
   3.545591196198854*^9, 3.5455912226088905`*^9}, {3.545609031973376*^9, 
   3.5456090340914965`*^9}, {3.5465393362746563`*^9, 
   3.5465393362746563`*^9}, {3.5465393899447317`*^9, 
   3.5465393901347322`*^9}, {3.546543678738236*^9, 3.546543678738236*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018080658428974`*^9, 3.501808079789322*^9}, {3.5018081845435057`*^9, 
   3.501808206165144*^9}, {3.5018082365851974`*^9, 3.501808240376004*^9}, {
   3.5019090910439215`*^9, 3.501909180416478*^9}, {3.5019092487601986`*^9, 
   3.501909263205824*^9}, {3.513310738333043*^9, 3.5133107581450777`*^9}, {
   3.5136563411395345`*^9, 3.5136563434595375`*^9}, {3.5151868255592127`*^9, 
   3.5151868309792204`*^9}, {3.5165811299001417`*^9, 3.516581145900164*^9}, {
   3.516581246990306*^9, 3.516581253790315*^9}, 3.5455898387472067`*^9, {
   3.5455899133734703`*^9, 3.5455899303174086`*^9}, {3.5455911509487906`*^9, 
   3.545591182528835*^9}, 3.546539398824744*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"a", "*", 
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 3.5018079845979548`*^9}, 
   3.501808368327429*^9, {3.5018084216015224`*^9, 3.501808427217532*^9}, {
   3.501819528072632*^9, 3.50181953253424*^9}, {3.5018203432520638`*^9, 
   3.501820344032065*^9}, {3.501881265548032*^9, 3.5018812668180337`*^9}, 
   3.5019094303913174`*^9, {3.5019094896870213`*^9, 3.5019094990938377`*^9}, 
   3.501909788474346*^9, {3.501952314796136*^9, 3.5019523154061365`*^9}, {
   3.50195238883624*^9, 3.501952414636276*^9}, {3.5023141622789707`*^9, 
   3.5023141666469784`*^9}, 3.504640147588321*^9, {3.505156055586641*^9, 
   3.5051560561666417`*^9}, {3.513310809921569*^9, 3.5133108268631983`*^9}, {
   3.513443376187376*^9, 3.5134433763373766`*^9}, {3.5136568597602606`*^9, 
   3.51365687359028*^9}, {3.513656910050331*^9, 3.5136569129003353`*^9}, {
   3.515020222395707*^9, 3.5150202815780916`*^9}, {3.5150203401634426`*^9, 
   3.51502035410324*^9}, {3.515020430528611*^9, 3.515020436192935*^9}, {
   3.515020525289031*^9, 3.51502052894024*^9}, {3.5152795782802167`*^9, 
   3.5152795811002207`*^9}, {3.516581465630612*^9, 3.5165814698006177`*^9}, 
   3.5165888581087985`*^9, 3.541089177466281*^9, 3.5410892713316455`*^9, 
   3.545583327762312*^9, 3.5455860322101*^9, {3.5455912822889743`*^9, 
   3.5455913159390216`*^9}, {3.545591695749553*^9, 3.545591704069565*^9}, {
   3.5456090208697405`*^9, 3.545609023013863*^9}, {3.546539315794628*^9, 
   3.5465393556246834`*^9}, {3.5465436842082434`*^9, 3.546543686278247*^9}, {
   3.548178081587426*^9, 3.548178082398628*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.4965117206885777`*^9, 3.5192471175756674`*^9, {3.5192587973599553`*^9, 
   3.5192588081399703`*^9}, {3.519321495105319*^9, 3.5193214991925263`*^9}, 
   3.5193247857072587`*^9, {3.5194051897010813`*^9, 3.5194051902791147`*^9}, {
   3.5194055551249824`*^9, 3.5194055708408813`*^9}, {3.519405711316916*^9, 
   3.51940572904193*^9}, {3.519410772192028*^9, 3.5194107776364374`*^9}, {
   3.519413782484516*^9, 3.519413782827717*^9}, {3.519767588664174*^9, 
   3.519767611128214*^9}, {3.5197937941314034`*^9, 3.519793794568204*^9}, {
   3.5197947626591043`*^9, 3.519794764749508*^9}, {3.519794865354085*^9, 
   3.519794874355301*^9}, {3.523218063086026*^9, 3.523218070356036*^9}, {
   3.523316514684347*^9, 3.523316514684347*^9}, {3.5233165475343933`*^9, 
   3.5233165475343933`*^9}, {3.5233184331871357`*^9, 
   3.5233184334271364`*^9}, {3.5273599103435545`*^9, 3.527359910608755*^9}, {
   3.5326424241029196`*^9, 3.53264242435292*^9}, {3.5326584126048727`*^9, 
   3.532658412794873*^9}, {3.532726454021428*^9, 3.5327264542814283`*^9}, {
   3.5327554047263184`*^9, 3.532755404993334*^9}, {3.532798666112293*^9, 
   3.532798676322307*^9}, {3.5328778343810363`*^9, 3.5328778343810363`*^9}, 
   3.5330758294771795`*^9, {3.5330827570868783`*^9, 3.533082757336879*^9}, {
   3.534975097668671*^9, 3.534975097888672*^9}, {3.536863459221404*^9, 
   3.536863459439804*^9}, {3.540264711953947*^9, 3.5402647253239655`*^9}, {
   3.540264783504047*^9, 3.540264783504047*^9}, {3.540502117527218*^9, 
   3.540502117997218*^9}, {3.540502551737826*^9, 3.540502551937826*^9}, {
   3.5449015667548094`*^9, 3.5449015920048447`*^9}, {3.544901714065016*^9, 
   3.544901727955035*^9}, 3.544911958524931*^9, {3.5449122781717815`*^9, 
   3.5449122781717815`*^9}, {3.5455187047402697`*^9, 
   3.5455187052402706`*^9}, {3.545518923250576*^9, 3.545518930270586*^9}, 
   3.545520507632794*^9, {3.545529645239874*^9, 3.545529645239874*^9}, {
   3.5455298056500983`*^9, 3.5455298100201044`*^9}, {3.545576232782379*^9, 
   3.545576234112381*^9}, {3.5455766240529265`*^9, 3.54557662626293*^9}, {
   3.5455767774631414`*^9, 3.5455767774631414`*^9}, 3.5455787391558876`*^9, {
   3.54558369792283*^9, 3.54558369792283*^9}, 3.545594489353464*^9, {
   3.545594748353827*^9, 3.545594748953828*^9}, {3.5455949452441025`*^9, 
   3.5455949460241036`*^9}, {3.545596656906499*^9, 3.545596657126499*^9}, {
   3.545596769036656*^9, 3.545596769036656*^9}, {3.546055330183305*^9, 
   3.546055331763307*^9}, {3.546056658255164*^9, 3.546056659885166*^9}, {
   3.546059263352213*^9, 3.546059265128315*^9}, 3.5461915558399243`*^9, {
   3.5461997661014185`*^9, 3.5461997661014185`*^9}, 3.546200542232505*^9, {
   3.5462010127931643`*^9, 3.5462010129631643`*^9}, {3.546205617934801*^9, 
   3.546205632094821*^9}, 3.546315693455369*^9, {3.5465325685451813`*^9, 
   3.5465325685451813`*^9}, {3.5465392908945932`*^9, 
   3.5465392913945937`*^9}, {3.5465437007682667`*^9, 
   3.5465437070582757`*^9}, {3.5481780167069125`*^9, 3.5481780177521143`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.551.1 inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, {
   3.4979864571349983`*^9, 3.4979864574937987`*^9}, {3.505354465216481*^9, 
   3.5053544654264812`*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 2 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "a"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "b"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]],
 ", and ",
 Cell[BoxData[
  RowBox[{"m", "\[Equal]", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.501729652057078*^9}, {3.5029994366665936`*^9, 
   3.502999483496659*^9}, 3.5029995988368206`*^9, 3.5053451043744326`*^9, 
   3.512064350982525*^9, {3.5454308824962745`*^9, 3.5454308914262867`*^9}, {
   3.545716086802712*^9, 3.545716086802712*^9}, {3.545716933554144*^9, 
   3.545716933554144*^9}, {3.548010311360707*^9, 3.548010311690707*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 3 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, 3.5053451233044586`*^9, 3.5120642388423676`*^9, {
   3.545576495082746*^9, 3.5455765281027927`*^9}, {3.545594710173774*^9, 
   3.545594712783777*^9}, {3.548010109300424*^9, 3.548010110070425*^9}, {
   3.548010312720709*^9, 3.548010313100709*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.5004322533111067`*^9, 
   3.5004322794606023`*^9}, {3.5030203943207865`*^9, 
   3.5030203943207865`*^9}, {3.5043646078512945`*^9, 3.504364638711338*^9}, 
   3.504471249250667*^9, {3.504983297263383*^9, 3.504983298043384*^9}, {
   3.505185059347052*^9, 3.5051850634142847`*^9}, {3.510010655210175*^9, 
   3.510010661460184*^9}, {3.5105052330331697`*^9, 3.510505233813171*^9}, {
   3.512186750070178*^9, 3.51218675138058*^9}, {3.512254288430264*^9, 
   3.512254290224267*^9}, 3.5122690611683536`*^9, {3.5130527066400003`*^9, 
   3.5130527081400023`*^9}, {3.5146063962581987`*^9, 3.514606396468199*^9}, {
   3.5146464410883884`*^9, 3.514646442367591*^9}, {3.514649252462927*^9, 
   3.514649254662531*^9}, {3.514649331024665*^9, 3.514649332132267*^9}, {
   3.514650269428713*^9, 3.514650269428713*^9}, {3.5146527184176073`*^9, 
   3.5146527186776075`*^9}, {3.514839598647603*^9, 3.514839599187604*^9}, {
   3.514842893279436*^9, 3.514842893279436*^9}, 3.516552160896055*^9, {
   3.516552825434822*^9, 3.5165528261056232`*^9}, {3.5165560194164267`*^9, 
   3.5165560202432284`*^9}, {3.516590317298932*^9, 3.5165903179789333`*^9}, {
   3.5455765935628843`*^9, 3.5455766009728947`*^9}, {3.5455766489129615`*^9, 
   3.5455766489129615`*^9}, {3.545576789523158*^9, 3.545576789523158*^9}, {
   3.5455837005028334`*^9, 3.5455837005028334`*^9}, {3.5455947444638214`*^9, 
   3.5455947450638227`*^9}, {3.545596759116642*^9, 3.5455967635166483`*^9}, {
   3.546205678984887*^9, 3.546205678984887*^9}, {3.546543712278283*^9, 
   3.546543712278283*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, 
   3.4979862241517887`*^9, {3.497986268845867*^9, 3.4979862970039167`*^9}, 
   3.4979902514328623`*^9, 3.5053446405637827`*^9, {3.505344690713853*^9, 
   3.505344714183886*^9}, 3.505352022693062*^9, {3.509895269213724*^9, 
   3.5098952711637273`*^9}, {3.5122692616086345`*^9, 3.512269267248642*^9}, {
   3.515188024323316*^9, 3.515188026363319*^9}, {3.516551821731059*^9, 
   3.5165518580747232`*^9}, {3.5165519661609135`*^9, 3.5165520026337776`*^9}, 
   3.516552122941189*^9, {3.516552341113172*^9, 3.516552355215597*^9}, 
   3.5165527682027216`*^9, {3.5455765405528097`*^9, 3.545576569942851*^9}, {
   3.545594486773461*^9, 3.5455945392735343`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4979862253061905`*^9, {
   3.497986271107871*^9, 3.497986297799518*^9}, 3.497986386903675*^9, 
   3.4986794582767816`*^9, {3.500419863725463*^9, 3.5004198652605505`*^9}, 
   3.5004202566819386`*^9, {3.500432258158384*^9, 3.5004322592084436`*^9}, 
   3.503020185000493*^9, 3.503020369830752*^9, {3.5030725476090527`*^9, 
   3.5030725694590836`*^9}, 3.503876142483889*^9, {3.505185046002289*^9, 
   3.5051850551548123`*^9}, 3.505344640573783*^9, {3.5053446907338533`*^9, 
   3.505344714193886*^9}, 3.505352025233065*^9, 3.5087829424446387`*^9, {
   3.509895272053728*^9, 3.509895275953734*^9}, 3.510433804704217*^9, 
   3.510513659779171*^9, 3.511807932152954*^9, {3.5121872577122717`*^9, 
   3.512187260473477*^9}, {3.5122693811788015`*^9, 3.5122693823488035`*^9}, 
   3.5130467260581713`*^9, 3.5130480309114447`*^9, {3.5144150721536956`*^9, 
   3.514415073159753*^9}, 3.5144740613848653`*^9, 3.5146137080368123`*^9, 
   3.5146497442693906`*^9, {3.514650251285881*^9, 3.514650252190683*^9}, 
   3.514842982948394*^9, 3.516552174312079*^9, 3.516552233577783*^9, {
   3.516560441226583*^9, 3.516560442318585*^9}, {3.51656050240749*^9, 
   3.516560503437092*^9}, 3.5410902439697533`*^9, 3.5410961737973623`*^9, 
   3.5410962680995274`*^9, {3.5455767928731627`*^9, 3.545576814273193*^9}, {
   3.545581036459104*^9, 3.545581037019105*^9}, {3.545581107879204*^9, 
   3.545581111439209*^9}, {3.545581145159256*^9, 3.545581155619271*^9}, 
   3.5455837025528364`*^9, 3.545585543269416*^9, {3.545594572493581*^9, 
   3.545594612163636*^9}, {3.545596739226614*^9, 3.5455967491866283`*^9}, {
   3.546124908273421*^9, 3.5461249082834206`*^9}, {3.5461249495534787`*^9, 
   3.5461249495634785`*^9}, {3.5462059190952225`*^9, 
   3.5462059210052257`*^9}, {3.5465437168882895`*^9, 3.546543718708292*^9}, 
   3.5473432373811407`*^9, {3.548178087577837*^9, 3.5481780883422384`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, {
   3.5449740914142227`*^9, 3.544974113394661*^9}, {3.544974297599785*^9, 
   3.5449743180826206`*^9}, 3.545013646990142*^9, 3.5454968080172033`*^9, {
   3.5460546827523985`*^9, 3.5460546942424145`*^9}, {3.546054727652461*^9, 
   3.5460547381924763`*^9}, {3.5460547979225597`*^9, 3.546054804832569*^9}, {
   3.546054941882761*^9, 3.5460549474927692`*^9}, 3.5461915423799057`*^9, {
   3.5461915817099605`*^9, 3.5461915819499607`*^9}, 3.5461961103163004`*^9, {
   3.546196164656377*^9, 3.5461961874164085`*^9}, 3.546197012837564*^9, {
   3.5462005531025205`*^9, 3.5462005600625305`*^9}, {3.546209916120819*^9, 
   3.546209916120819*^9}, 3.546315250839053*^9, {3.548177890908292*^9, 
   3.548177891095492*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, {3.54499756760699*^9, 3.5449975737066*^9}, {
   3.544998829914407*^9, 3.544998830117207*^9}, 3.5454967731271544`*^9, 
   3.5455888003097982`*^9, 3.5460547400024786`*^9, 3.5461915282898855`*^9, 
   3.5461929509218774`*^9, 3.5461931858622065`*^9, {3.5461934507925773`*^9, 
   3.5461934509125776`*^9}, 3.5462103314614*^9, 3.5463158337863955`*^9, {
   3.546315866715279*^9, 3.546315866944292*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["z", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "b"], "-", 
    FractionBox["a", 
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.5166724284966736`*^9, 3.51667246652954*^9}, {
   3.544997603799053*^9, 3.5449976318635025`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.5084342812040005`*^9, 
   3.513377426312771*^9, 3.514598964197794*^9, 3.514861832535917*^9, 
   3.5151814359289675`*^9, {3.5449819212033024`*^9, 3.5449819218033037`*^9}, {
   3.5449906023954563`*^9, 3.5449906023954563`*^9}, 3.545588815516595*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "b"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.500427423095834*^9, 3.5004274236088634`*^9}, {3.5004275574055157`*^9, 
   3.5004276042171936`*^9}, {3.5004328122050734`*^9, 3.500432862882972*^9}, 
   3.500577560076061*^9, {3.5005776542858267`*^9, 3.5005776585134335`*^9}, {
   3.5005778782474194`*^9, 3.5005778816794252`*^9}, {3.5005831554094906`*^9, 
   3.500583168763114*^9}, {3.5083582601079473`*^9, 3.5083582791879745`*^9}, {
   3.5084321966550684`*^9, 3.508432242745133*^9}, {3.508435338515481*^9, 
   3.5084353396954823`*^9}, {3.5098472024485316`*^9, 
   3.5098472051185355`*^9}, {3.515167836293977*^9, 3.51516784604399*^9}, 
   3.5159777406654205`*^9, {3.5166723560345464`*^9, 3.5166724183722563`*^9}, 
   3.544997759206526*^9, {3.5449977999693975`*^9, 3.5449978189078307`*^9}, 
   3.545067683873373*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "b"}], " ", "-", " ", 
    RowBox[{
     RowBox[{"a", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5004276750552454`*^9, 3.5004276923832364`*^9}, {3.500427741061021*^9, 
   3.5004277415710497`*^9}, 3.5004329174270916`*^9, {3.500432950987011*^9, 
   3.500433005771145*^9}, {3.5005779794447966`*^9, 3.5005780180236645`*^9}, 
   3.500578063248144*^9, 3.500578099767808*^9, {3.5005832139251933`*^9, 
   3.500583240086439*^9}, {3.5083587271786013`*^9, 3.5083587379086165`*^9}, {
   3.508358813958723*^9, 3.508358816458727*^9}, {3.508432384255331*^9, 
   3.508432444825416*^9}, {3.5084330622062807`*^9, 3.5084330632262816`*^9}, {
   3.5084353403254833`*^9, 3.508435341415485*^9}, {3.5098472081385393`*^9, 
   3.5098472109985437`*^9}, {3.516672495249191*^9, 3.516672499991599*^9}, {
   3.516672547649683*^9, 3.516672555777297*^9}, {3.5449838311659765`*^9, 
   3.5449838325859785`*^9}, 3.5449980561374474`*^9, {3.5449980913623095`*^9, 
   3.5449981028751297`*^9}, {3.5449981342779846`*^9, 3.544998141890798*^9}, 
   3.5450676861433764`*^9, 3.545588809263237*^9, {3.5461249077034197`*^9, 
   3.54612490771342*^9}, {3.546124948993478*^9, 3.546124949003478*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.5449979068763857`*^9, {3.54499883159921*^9, 
   3.54499883177081*^9}, {3.5450711521182284`*^9, 3.5450711580382366`*^9}, 
   3.5454967768371596`*^9, 3.5460548083325744`*^9, 3.546191534369894*^9, 
   3.5461955167054696`*^9, 3.5461956055655937`*^9, 3.546210166451169*^9, 
   3.546211338892811*^9, 3.5463158328063393`*^9, {3.5463158682603674`*^9, 
   3.5463158684293776`*^9}, 3.5465316301538677`*^9, 3.5465424581965275`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["z", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]], "\[Equal]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]], "b"], "-", 
    FractionBox["a", 
     RowBox[{"b", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.5166724284966736`*^9, 3.51667246652954*^9}, {
   3.5449976402719173`*^9, 3.544997641145519*^9}, {3.5450712053383026`*^9, 
   3.5450712400083513`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.5084342812040005`*^9, 
   3.513377426312771*^9, 3.514598964197794*^9, 3.514861832535917*^9, 
   3.5151814359289675`*^9, {3.5449819212033024`*^9, 3.5449819218033037`*^9}, {
   3.5449906023954563`*^9, 3.5449906023954563`*^9}, 3.5465424619565325`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.500427423095834*^9, 3.5004274236088634`*^9}, {3.5004275574055157`*^9, 
   3.5004276042171936`*^9}, {3.5004328122050734`*^9, 3.500432862882972*^9}, 
   3.500577560076061*^9, {3.5005776542858267`*^9, 3.5005776585134335`*^9}, {
   3.5005778782474194`*^9, 3.5005778816794252`*^9}, {3.5005831554094906`*^9, 
   3.500583168763114*^9}, {3.5083582601079473`*^9, 3.5083582791879745`*^9}, {
   3.5084321966550684`*^9, 3.508432242745133*^9}, {3.508435338515481*^9, 
   3.5084353396954823`*^9}, {3.5098472024485316`*^9, 
   3.5098472051185355`*^9}, {3.515167836293977*^9, 3.51516784604399*^9}, 
   3.5159777406654205`*^9, {3.5166723560345464`*^9, 3.5166724183722563`*^9}, {
   3.5449978875323515`*^9, 3.544997897531969*^9}, {3.5450711604882402`*^9, 
   3.54507118896828*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"a", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5004276750552454`*^9, 3.5004276923832364`*^9}, {3.500427741061021*^9, 
   3.5004277415710497`*^9}, 3.5004329174270916`*^9, {3.500432950987011*^9, 
   3.500433005771145*^9}, {3.5005779794447966`*^9, 3.5005780180236645`*^9}, 
   3.500578063248144*^9, 3.500578099767808*^9, {3.5005832139251933`*^9, 
   3.500583240086439*^9}, {3.5083587271786013`*^9, 3.5083587379086165`*^9}, {
   3.508358813958723*^9, 3.508358816458727*^9}, {3.508432384255331*^9, 
   3.508432444825416*^9}, {3.5084330622062807`*^9, 3.5084330632262816`*^9}, {
   3.5084353403254833`*^9, 3.508435341415485*^9}, {3.5098472081385393`*^9, 
   3.5098472109985437`*^9}, {3.516672495249191*^9, 3.516672499991599*^9}, {
   3.516672547649683*^9, 3.516672555777297*^9}, {3.5449838311659765`*^9, 
   3.5449838325859785`*^9}, 3.5449977109400415`*^9, {3.5449979171724033`*^9, 
   3.544997929590025*^9}, {3.5450712581383767`*^9, 3.54507130316844*^9}, 
   3.5450912440023603`*^9, {3.5461249078534203`*^9, 3.5461249078634205`*^9}, {
   3.546124949133478*^9, 3.546124949143478*^9}, 3.546542464946537*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["3.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", 
       RowBox[{"-", "1"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, {
   3.5449740914142227`*^9, 3.544974113394661*^9}, {3.544974297599785*^9, 
   3.5449743180826206`*^9}, 3.545013646990142*^9, 3.5454968080172033`*^9, {
   3.5460546827523985`*^9, 3.5460546942424145`*^9}, {3.546054727652461*^9, 
   3.5460547381924763`*^9}, {3.5460547979225597`*^9, 3.546054804832569*^9}, {
   3.546054941882761*^9, 3.5460549474927692`*^9}, 3.5461915423799057`*^9, {
   3.5461915817099605`*^9, 3.5461915819499607`*^9}, 3.5461961103163004`*^9, {
   3.546196164656377*^9, 3.5461961874164085`*^9}, 3.546197012837564*^9, {
   3.5462005531025205`*^9, 3.5462005600625305`*^9}, {3.546209916120819*^9, 
   3.546209916120819*^9}, 3.546315250839053*^9, {3.546539583965003*^9, 
   3.546539614555046*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.4965117206885777`*^9, 3.5192471175756674`*^9, {3.5192587973599553`*^9, 
   3.5192588081399703`*^9}, {3.519321495105319*^9, 3.5193214991925263`*^9}, 
   3.5193247857072587`*^9, {3.5194051897010813`*^9, 3.5194051902791147`*^9}, {
   3.5194055551249824`*^9, 3.5194055708408813`*^9}, {3.519405711316916*^9, 
   3.51940572904193*^9}, {3.519410772192028*^9, 3.5194107776364374`*^9}, {
   3.519413782484516*^9, 3.519413782827717*^9}, {3.519767588664174*^9, 
   3.519767611128214*^9}, {3.5197937941314034`*^9, 3.519793794568204*^9}, {
   3.5197947626591043`*^9, 3.519794764749508*^9}, {3.519794865354085*^9, 
   3.519794874355301*^9}, {3.523218063086026*^9, 3.523218070356036*^9}, {
   3.523316514684347*^9, 3.523316514684347*^9}, {3.5233165475343933`*^9, 
   3.5233165475343933`*^9}, {3.5233184331871357`*^9, 
   3.5233184334271364`*^9}, {3.5273599103435545`*^9, 3.527359910608755*^9}, {
   3.5326424241029196`*^9, 3.53264242435292*^9}, {3.5326584126048727`*^9, 
   3.532658412794873*^9}, {3.532726454021428*^9, 3.5327264542814283`*^9}, {
   3.5327554047263184`*^9, 3.532755404993334*^9}, {3.532798666112293*^9, 
   3.532798676322307*^9}, {3.5328778343810363`*^9, 3.5328778343810363`*^9}, 
   3.5330758294771795`*^9, {3.5330827570868783`*^9, 3.533082757336879*^9}, {
   3.534975097668671*^9, 3.534975097888672*^9}, {3.536863459221404*^9, 
   3.536863459439804*^9}, {3.540264711953947*^9, 3.5402647253239655`*^9}, {
   3.540264783504047*^9, 3.540264783504047*^9}, {3.540502117527218*^9, 
   3.540502117997218*^9}, {3.540502551737826*^9, 3.540502551937826*^9}, {
   3.5449015667548094`*^9, 3.5449015920048447`*^9}, {3.544901714065016*^9, 
   3.544901727955035*^9}, 3.544911958524931*^9, {3.5449122781717815`*^9, 
   3.5449122781717815`*^9}, {3.5455187047402697`*^9, 
   3.5455187052402706`*^9}, {3.545518923250576*^9, 3.545518930270586*^9}, 
   3.545520507632794*^9, {3.545529645239874*^9, 3.545529645239874*^9}, {
   3.5455298056500983`*^9, 3.5455298100201044`*^9}, {3.545576232782379*^9, 
   3.545576234112381*^9}, {3.5455787349658823`*^9, 3.545578737405885*^9}, {
   3.5455925746507835`*^9, 3.5455925850107985`*^9}, {3.5455949478441067`*^9, 
   3.545594947984106*^9}, {3.5455966616065054`*^9, 3.545596661876506*^9}, {
   3.5460553332533092`*^9, 3.5460553344733105`*^9}, {3.5460566614051685`*^9, 
   3.546056663145171*^9}, {3.546059266411388*^9, 3.546059267393444*^9}, 
   3.546191557179926*^9, 3.546209912600814*^9, {3.546315835044468*^9, 
   3.546315839645731*^9}, {3.5465395890850105`*^9, 3.546539592065015*^9}, {
   3.5465396501250963`*^9, 3.546539663885115*^9}, {3.548178144611537*^9, 
   3.5481781519747505`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 7 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.504905059830614*^9, 3.5049051008006716`*^9}, {
   3.5049062442122726`*^9, 3.5049062459122753`*^9}, 3.505345087554409*^9, 
   3.5120642138723326`*^9, {3.513276979592985*^9, 3.513276981292988*^9}, {
   3.5147754897687864`*^9, 3.5147754924207907`*^9}, {3.515187407180027*^9, 
   3.5151874102100315`*^9}, {3.545590336281943*^9, 3.5455903388632736`*^9}, {
   3.5455906008904057`*^9, 3.5455906214425817`*^9}, {3.5480103140207105`*^9, 
   3.548010314380711*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[Equal]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, 3.501812773952368*^9, {
   3.5018130124143867`*^9, 3.501813024192407*^9}, {3.5019838990946054`*^9, 
   3.5019838990946054`*^9}, {3.502313537248273*^9, 3.502313540056278*^9}, {
   3.5032786865960426`*^9, 3.5032786865960426`*^9}, {3.5044889074240103`*^9, 
   3.5044889083740115`*^9}, {3.5044895485049076`*^9, 3.504489548704908*^9}, 
   3.504634772030795*^9, {3.5046385957061486`*^9, 3.504638598326152*^9}, {
   3.5046401693283515`*^9, 3.50464017514836*^9}, {3.513608365525629*^9, 
   3.513608365525629*^9}, 3.5136563676795716`*^9, {3.51365715249067*^9, 
   3.5136571548506737`*^9}, {3.516580809709694*^9, 3.5165808219197106`*^9}, {
   3.5165888909288445`*^9, 3.5165888916588454`*^9}, {3.5455899656415615`*^9, 
   3.545589967494667*^9}, {3.54559076137965*^9, 3.545590772488285*^9}, {
   3.5455908140271063`*^9, 3.5455908272605677`*^9}, {3.5455909389964366`*^9, 
   3.545590940544525*^9}, {3.546539693805157*^9, 3.546539699255165*^9}, {
   3.5481781585423613`*^9, 3.5481781585423613`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.51330998524172*^9, 3.513310050184634*^9}, {
   3.5133101228963623`*^9, 3.5133101670756397`*^9}, {3.5133102640142097`*^9, 
   3.513310371139598*^9}, {3.5136563252795124`*^9, 3.5136563276995153`*^9}, {
   3.5151867442090993`*^9, 3.5151867502591076`*^9}, 3.5165805874793825`*^9, {
   3.516580641599458*^9, 3.51658065009947*^9}, {3.5165806845495186`*^9, 
   3.516580708119551*^9}, 3.516580995399954*^9, 3.545589835340012*^9, {
   3.5455898894586487`*^9, 3.5455899037204647`*^9}, 3.545590636117896*^9, {
   3.5455906799786215`*^9, 3.5455907174839272`*^9}, 3.5455911472687855`*^9, 
   3.546539716565189*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{
     RowBox[{"n", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018131102889585`*^9, 3.501813151972232*^9}, {
   3.501813189599498*^9, 3.501813190332699*^9}, 3.5018608913295975`*^9, {
   3.501881991209048*^9, 3.5018819919590487`*^9}, 3.501983907934618*^9, {
   3.5023135306806617`*^9, 3.502313531320263*^9}, 3.502313932521767*^9, {
   3.50327869079245*^9, 3.5032786910264506`*^9}, 3.50328228357796*^9, {
   3.504638590276141*^9, 3.504638590506141*^9}, 3.5046397563877735`*^9, {
   3.504640119538282*^9, 3.504640131848299*^9}, {3.5051560518666353`*^9, 
   3.5051560525466366`*^9}, {3.513310388939229*^9, 3.513310421964487*^9}, {
   3.513608369566036*^9, 3.5136083698936367`*^9}, {3.513656455929695*^9, 
   3.5136564647497077`*^9}, {3.516588770868676*^9, 3.516588772118678*^9}, 
   3.5410891721778717`*^9, 3.541089263516032*^9, 3.545583327762312*^9, 
   3.5455860321701*^9, {3.545590883846282*^9, 3.5455909188712854`*^9}, {
   3.545591288548983*^9, 3.5455912889689837`*^9}, {3.5465396297750673`*^9, 
   3.546539632515071*^9}, {3.546539747195232*^9, 3.5465397526652393`*^9}, {
   3.548178107358672*^9, 3.548178108606674*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", "<", 
        RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.4965117206885777`*^9, 3.5192471175756674`*^9, {3.5192587973599553`*^9, 
   3.5192588081399703`*^9}, {3.519321495105319*^9, 3.5193214991925263`*^9}, 
   3.5193247857072587`*^9, {3.5194051897010813`*^9, 3.5194051902791147`*^9}, {
   3.5194055551249824`*^9, 3.5194055708408813`*^9}, {3.519405711316916*^9, 
   3.51940572904193*^9}, {3.519410772192028*^9, 3.5194107776364374`*^9}, {
   3.519413782484516*^9, 3.519413782827717*^9}, {3.519767588664174*^9, 
   3.519767611128214*^9}, {3.5197937941314034`*^9, 3.519793794568204*^9}, {
   3.5197947626591043`*^9, 3.519794764749508*^9}, {3.519794865354085*^9, 
   3.519794874355301*^9}, {3.523218063086026*^9, 3.523218070356036*^9}, {
   3.523316514684347*^9, 3.523316514684347*^9}, {3.5233165475343933`*^9, 
   3.5233165475343933`*^9}, {3.5233184331871357`*^9, 
   3.5233184334271364`*^9}, {3.5273599103435545`*^9, 3.527359910608755*^9}, {
   3.5326424241029196`*^9, 3.53264242435292*^9}, {3.5326584126048727`*^9, 
   3.532658412794873*^9}, {3.532726454021428*^9, 3.5327264542814283`*^9}, {
   3.5327554047263184`*^9, 3.532755404993334*^9}, {3.532798666112293*^9, 
   3.532798676322307*^9}, {3.5328778343810363`*^9, 3.5328778343810363`*^9}, 
   3.5330758294771795`*^9, {3.5330827570868783`*^9, 3.533082757336879*^9}, {
   3.534975097668671*^9, 3.534975097888672*^9}, {3.536863459221404*^9, 
   3.536863459439804*^9}, {3.540264711953947*^9, 3.5402647253239655`*^9}, {
   3.540264783504047*^9, 3.540264783504047*^9}, {3.540502117527218*^9, 
   3.540502117997218*^9}, {3.540502551737826*^9, 3.540502551937826*^9}, {
   3.5449015667548094`*^9, 3.5449015920048447`*^9}, {3.544901714065016*^9, 
   3.544901727955035*^9}, 3.544911958524931*^9, {3.5449122781717815`*^9, 
   3.5449122781717815`*^9}, {3.5455187047402697`*^9, 
   3.5455187052402706`*^9}, {3.545518923250576*^9, 3.545518930270586*^9}, 
   3.545520507632794*^9, {3.545529645239874*^9, 3.545529645239874*^9}, {
   3.5455298056500983`*^9, 3.5455298100201044`*^9}, {3.545576232782379*^9, 
   3.545576234112381*^9}, {3.5455787349658823`*^9, 3.545578737405885*^9}, {
   3.5455925746507835`*^9, 3.5455925850107985`*^9}, {3.5455949478441067`*^9, 
   3.545594947984106*^9}, {3.5455966616065054`*^9, 3.545596661876506*^9}, {
   3.5460553332533092`*^9, 3.5460553344733105`*^9}, {3.5460566614051685`*^9, 
   3.546056663145171*^9}, {3.546059266411388*^9, 3.546059267393444*^9}, 
   3.546191557179926*^9, 3.546209912600814*^9, {3.546315835044468*^9, 
   3.546315839645731*^9}, {3.5465395890850105`*^9, 3.546539592065015*^9}, {
   3.548178162255168*^9, 3.548178166186375*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.551.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.4979864629538083`*^9, 3.4979864631566086`*^9}, {
   3.505354450536461*^9, 3.505354450786461*^9}}],

Cell[TextData[{
 "Derivation: Recurrence 1 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, 3.505345087554409*^9, 3.5120642144023333`*^9, {
   3.5455763598025565`*^9, 3.5455763991826115`*^9}, {3.5455923006504*^9, 
   3.5455923155804214`*^9}, {3.5480101995905504`*^9, 3.5480102067705603`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5105052297883635`*^9, 
   3.5105052302875643`*^9}, {3.512186737480956*^9, 3.51218673982096*^9}, {
   3.512254301019486*^9, 3.512254302283088*^9}, 3.512269040108324*^9, {
   3.5130526959899855`*^9, 3.5130526974799876`*^9}, {3.5144328618769655`*^9, 
   3.5144328644041696`*^9}, {3.514612683661013*^9, 3.5146126839574137`*^9}, {
   3.514839541717523*^9, 3.5148395419375234`*^9}, {3.516553407655444*^9, 
   3.516553423973073*^9}, {3.5165560160468206`*^9, 3.5165560163900213`*^9}, 
   3.5165903139089274`*^9, {3.545576209372346*^9, 3.5455762197223606`*^9}, {
   3.545576267002427*^9, 3.5455762671924267`*^9}, {3.5455925789107895`*^9, 
   3.545592579770791*^9}, {3.548178170226782*^9, 3.548178170226782*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, 
   3.4979862241517887`*^9, {3.497986268845867*^9, 3.4979862970039167`*^9}, 
   3.4979902514328623`*^9, 3.5053446405637827`*^9, {3.505344690713853*^9, 
   3.505344714183886*^9}, 3.505352022693062*^9, {3.509895269213724*^9, 
   3.5098952711637273`*^9}, {3.5122692616086345`*^9, 3.512269267248642*^9}, {
   3.515188024323316*^9, 3.515188026363319*^9}, {3.516551821731059*^9, 
   3.5165518580747232`*^9}, {3.5165519661609135`*^9, 3.5165520026337776`*^9}, 
   3.516552122941189*^9, {3.516552341113172*^9, 3.516552355215597*^9}, 
   3.5165527682027216`*^9, {3.5165530664828453`*^9, 3.5165530855148783`*^9}, {
   3.516553126870551*^9, 3.516553157540205*^9}, {3.545576086822174*^9, 
   3.5455761241522264`*^9}, 3.54557620502234*^9, {3.5455923280404387`*^9, 
   3.5455923986905375`*^9}, {3.545719460754691*^9, 3.54571946667703*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, 3.510433803854216*^9, 
   3.5105126206769457`*^9, 3.511808081063163*^9, {3.51218729646274*^9, 
   3.5121872973831415`*^9}, 3.5130466567580743`*^9, 3.5130480542714767`*^9, {
   3.514432838336524*^9, 3.5144328412381287`*^9}, 3.5144740905881166`*^9, 
   3.514613689160779*^9, {3.5165555422003884`*^9, 3.516555563619226*^9}, 
   3.5410902396641455`*^9, 3.54109616682415*^9, 3.5410962611263156`*^9, {
   3.5455761395922484`*^9, 3.5455761481322603`*^9}, {3.545576180412306*^9, 
   3.5455761956523266`*^9}, {3.5455809352489624`*^9, 3.545580939498968*^9}, {
   3.5455810333890996`*^9, 3.5455810340591006`*^9}, 3.5455855432194157`*^9, {
   3.545592432150584*^9, 3.54559247903065*^9}, 3.5455925231307116`*^9, {
   3.5457194734034147`*^9, 3.5457194825339365`*^9}, {3.546124908303421*^9, 
   3.5461249083134212`*^9}, {3.546124949583479*^9, 3.546124949593479*^9}, {
   3.5481781161570873`*^9, 3.548178117295889*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["4.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "\[NotEqual]", "2"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, {
   3.5449740914142227`*^9, 3.544974113394661*^9}, {3.544974297599785*^9, 
   3.5449743180826206`*^9}, 3.545013646990142*^9, 3.5454968080172033`*^9, {
   3.5460546827523985`*^9, 3.5460546942424145`*^9}, {3.546054727652461*^9, 
   3.5460547381924763`*^9}, {3.5460547979225597`*^9, 3.546054804832569*^9}, {
   3.546054941882761*^9, 3.5460549474927692`*^9}, 3.5461915423799057`*^9, {
   3.5461915817099605`*^9, 3.5461915819499607`*^9}, 3.5461961103163004`*^9, {
   3.546196164656377*^9, 3.5461961874164085`*^9}, 3.546197012837564*^9, {
   3.5462005531025205`*^9, 3.5462005600625305`*^9}, {3.546200741352784*^9, 
   3.546200755932804*^9}, {3.546209930530839*^9, 3.546209930530839*^9}, 
   3.5463152518321095`*^9, {3.5481783405946817`*^9, 3.548178342232684*^9}, {
   3.5481786150459633`*^9, 3.5481786150459633`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{
       RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
       RowBox[{"n", "\[NotEqual]", "2"}]}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, {
   3.54541627618718*^9, 3.545416318915655*^9}, {3.545416397555393*^9, 
   3.5454163977893934`*^9}, {3.5454168214081373`*^9, 
   3.5454168256513453`*^9}, {3.5454168914054604`*^9, 3.545416903979083*^9}, {
   3.5454169758952093`*^9, 3.545416976082409*^9}, {3.5454170486069365`*^9, 
   3.5454170486069365`*^9}, 3.5454968423372517`*^9, {3.545610761413294*^9, 
   3.54561076239135*^9}, {3.546061556769389*^9, 3.546061575684471*^9}, {
   3.5460616158377676`*^9, 3.5460616160207777`*^9}, {3.5460622992488565`*^9, 
   3.5460622992488565`*^9}, 3.5461915595099297`*^9, {3.5462000367717977`*^9, 
   3.5462000367717977`*^9}, 3.5462007576728067`*^9, {3.5462017312041698`*^9, 
   3.54620173143417*^9}, 3.5463157048570213`*^9, {3.5465328013055077`*^9, 
   3.5465328013055077`*^9}, {3.5465372255317016`*^9, 3.546537225741702*^9}, {
   3.5465442461790304`*^9, 3.5465442613390512`*^9}, {3.5481783436678867`*^9, 
   3.5481783511871*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 2 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "\[Equal]", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.501729725689207*^9, 
   3.5017297313520174`*^9}, 3.501729800304138*^9, 3.5053451043644323`*^9, 
   3.512064350632524*^9, {3.5454312604468036`*^9, 3.545431265626811*^9}, {
   3.5454365113581195`*^9, 3.5454365133981223`*^9}, {3.5454370225788355`*^9, 
   3.5454370600388875`*^9}, {3.5454372465891485`*^9, 
   3.5454372507491546`*^9}, {3.546061585209016*^9, 3.546061595460602*^9}, {
   3.5480101149704323`*^9, 3.5480101157804327`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.5084342812040005`*^9, 
   3.513377426312771*^9, 3.514598964197794*^9, 3.514861832535917*^9, 
   3.5151814359289675`*^9, {3.516670127883032*^9, 3.5166701666334996`*^9}, 
   3.5166731186418858`*^9, 3.5166737399657774`*^9, {3.516826945697586*^9, 
   3.5168269464556303`*^9}, {3.5168298428992968`*^9, 
   3.5168298460284758`*^9}, {3.516830093084607*^9, 3.516830093767646*^9}, {
   3.5168315412404366`*^9, 3.516831542411504*^9}, {3.5454167748732557`*^9, 
   3.5454167748732557`*^9}, {3.5454301270852165`*^9, 3.545430127905218*^9}, {
   3.546061621159072*^9, 3.5460616220271215`*^9}, {3.54606231540178*^9, 
   3.54606231540178*^9}, {3.5462000405918026`*^9, 3.5462000405918026`*^9}, {
   3.5465328062855144`*^9, 3.5465328062855144`*^9}, {3.546575542255299*^9, 
   3.546575542255299*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095014754320154`*^9, 3.5095014757128158`*^9}, {
   3.509501663985547*^9, 3.5095016805839767`*^9}, {3.509828555552424*^9, 
   3.5098285973424826`*^9}, {3.509828656532565*^9, 3.509828698932625*^9}, {
   3.5098287432526865`*^9, 3.5098287837327433`*^9}, {3.5101746549548464`*^9, 
   3.5101746581060524`*^9}, {3.510174939280946*^9, 3.510174959092981*^9}, {
   3.5151682145645065`*^9, 3.5151682184145117`*^9}, {3.5168286510391264`*^9, 
   3.516828722449211*^9}, {3.5168287554080963`*^9, 3.51682883397459*^9}, {
   3.5168289004323907`*^9, 3.516828908860873*^9}, {3.546061610382456*^9, 
   3.5460616538609424`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{"a", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.5006670128563595`*^9, 
   3.500667030256384*^9}, {3.5006756721584826`*^9, 3.5006757072485313`*^9}, 
   3.5006761770891895`*^9, {3.500676504879648*^9, 3.500676511719658*^9}, {
   3.500676615389803*^9, 3.50067662058981*^9}, {3.50067712041051*^9, 
   3.500677157770562*^9}, 3.500684516250436*^9, {3.508358781038677*^9, 
   3.508358787338686*^9}, {3.5083588719288044`*^9, 3.508358881988818*^9}, {
   3.508378414067792*^9, 3.5083784269778104`*^9}, {3.508378464587863*^9, 
   3.508378467637867*^9}, {3.5083785093179255`*^9, 3.50837851959794*^9}, {
   3.5083787060882015`*^9, 3.5083787263182297`*^9}, 3.508380619208137*^9, {
   3.5084371686080427`*^9, 3.508437170918046*^9}, {3.5098473915587964`*^9, 
   3.5098473943488007`*^9}, {3.516670197973955*^9, 3.5166702183163905`*^9}, 
   3.5166702884229136`*^9, {3.516671215630943*^9, 3.516671306891103*^9}, 
   3.516821192477213*^9, {3.5168269411143246`*^9, 3.5168269420183764`*^9}, {
   3.51682905775939*^9, 3.5168290945344925`*^9}, {3.516829817695855*^9, 
   3.516829818269888*^9}, {3.5168303150543027`*^9, 3.5168303381576242`*^9}, {
   3.541091080823223*^9, 3.5410910917744417`*^9}, {3.541091131039711*^9, 
   3.541091139182925*^9}, 3.5454170718041773`*^9, {3.545610768452697*^9, 
   3.545610769279744*^9}, {3.5460408620730786`*^9, 3.546040865113083*^9}, 
   3.5460411680035067`*^9, {3.546061660886344*^9, 3.546061700103587*^9}, {
   3.546062320345063*^9, 3.5460623238792653`*^9}, {3.5461249083334208`*^9, 
   3.546124908343421*^9}, {3.5461249496134787`*^9, 3.546124949623479*^9}, {
   3.5465328106055202`*^9, 3.5465328156755276`*^9}, 3.5465755443753023`*^9, {
   3.548178360172716*^9, 3.548178360983917*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
      RowBox[{"n", "<", "0"}]]]], "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519250976620308*^9, 3.5192509795375133`*^9}, 3.5192520188581386`*^9, {
   3.5193215829334736`*^9, 3.519321595725496*^9}, {3.5194112531544743`*^9, 
   3.5194112537784753`*^9}, {3.519411537636574*^9, 3.519411568711828*^9}, {
   3.519793882583559*^9, 3.519793883878361*^9}, {3.5214731238817034`*^9, 
   3.521473124371704*^9}, {3.523316505044334*^9, 3.523316505044334*^9}, {
   3.5233184226511183`*^9, 3.523318422861119*^9}, 3.5328367822219863`*^9, {
   3.5328742732655816`*^9, 3.5328742968684235`*^9}, {3.532874332701686*^9, 
   3.532874341843302*^9}, {3.532874546156861*^9, 3.532874552443672*^9}, {
   3.5328756408887835`*^9, 3.5328756426671867`*^9}, {3.5328756840852594`*^9, 
   3.532875690340871*^9}, {3.5328775995694237`*^9, 3.532877607619038*^9}, {
   3.5330804511936502`*^9, 3.5330804511936502`*^9}, {3.5330827213068285`*^9, 
   3.5330827218568287`*^9}, {3.5368634501889877`*^9, 
   3.5368634503449883`*^9}, {3.537654628221073*^9, 3.537654628221073*^9}, {
   3.5376556650325246`*^9, 3.5376556690825305`*^9}, {3.5376558319727583`*^9, 
   3.537655832122759*^9}, {3.5403190180369616`*^9, 3.540319018277975*^9}, {
   3.540320078404611*^9, 3.5403200969116697`*^9}, {3.54497301407633*^9, 
   3.5449730147315316`*^9}, {3.5449730455259857`*^9, 3.54497310485289*^9}, {
   3.5449740914142227`*^9, 3.544974113394661*^9}, {3.544974297599785*^9, 
   3.5449743180826206`*^9}, 3.545013646990142*^9, 3.5454968080172033`*^9, {
   3.5460546827523985`*^9, 3.5460546942424145`*^9}, {3.546054727652461*^9, 
   3.5460547381924763`*^9}, {3.5460547979225597`*^9, 3.546054804832569*^9}, {
   3.546054941882761*^9, 3.5460549474927692`*^9}, 3.5461915423799057`*^9, {
   3.5461915817099605`*^9, 3.5461915819499607`*^9}, 3.5461961103163004`*^9, {
   3.546196164656377*^9, 3.5461961874164085`*^9}, 3.546197012837564*^9, {
   3.5462005531025205`*^9, 3.5462005600625305`*^9}, {3.546200741352784*^9, 
   3.546200755932804*^9}, {3.546209930530839*^9, 3.546209930530839*^9}, 
   3.5463152518321095`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, {
   3.54541627618718*^9, 3.545416318915655*^9}, {3.545416397555393*^9, 
   3.5454163977893934`*^9}, {3.5454168214081373`*^9, 
   3.5454168256513453`*^9}, {3.5454168857582507`*^9, 
   3.5454169106558943`*^9}, {3.5454170438021283`*^9, 3.5454170438021283`*^9}, 
   3.5454968409272494`*^9, {3.5456107421021895`*^9, 3.5456107421021895`*^9}, {
   3.5460577210359974`*^9, 3.546057728804442*^9}, {3.546058009681507*^9, 
   3.546058009994525*^9}, {3.5460585305733004`*^9, 3.546058532331401*^9}, 
   3.546191529269887*^9, 3.546192951841879*^9, 3.5461931882922096`*^9, {
   3.5461934535825815`*^9, 3.546193453752581*^9}, 3.546210369981454*^9, {
   3.546211308412768*^9, 3.546211308652768*^9}, {3.546315890759654*^9, 
   3.5463158927497683`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.501729725689207*^9, 
   3.5017297313520174`*^9}, 3.501729800304138*^9, 3.5053451043644323`*^9, 
   3.512064350632524*^9, {3.5454312604468036`*^9, 3.545431265626811*^9}, {
   3.5454365113581195`*^9, 3.5454365133981223`*^9}, {3.5454370225788355`*^9, 
   3.5454370600388875`*^9}, {3.5454372465891485`*^9, 
   3.5454372507491546`*^9}, {3.5454373013392253`*^9, 3.545437305479231*^9}, {
   3.5460578522675037`*^9, 3.5460578551986713`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["z", "b"], "-", 
    FractionBox[
     RowBox[{"a", " ", "z"}], 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]], "Input",
  CellChangeTimes->{{3.546057940587555*^9, 3.546057942676675*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.5084342812040005`*^9, 
   3.513377426312771*^9, 3.514598964197794*^9, 3.514861832535917*^9, 
   3.5151814359289675`*^9, {3.516670127883032*^9, 3.5166701666334996`*^9}, 
   3.5166731186418858`*^9, 3.5166737399657774`*^9, {3.516826945697586*^9, 
   3.5168269464556303`*^9}, {3.5168300872452726`*^9, 3.516830089791418*^9}, {
   3.516831534936076*^9, 3.5168315360301385`*^9}, {3.5454167796156645`*^9, 
   3.5454167796156645`*^9}, {3.545430121495209*^9, 3.54543012225521*^9}, {
   3.546057865091237*^9, 3.546057872016633*^9}, {3.546057910320824*^9, 
   3.546057912621956*^9}, {3.5460579509051456`*^9, 3.546057987389232*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.5084342812040005`*^9, 
   3.513377426312771*^9, 3.514598964197794*^9, 3.514861832535917*^9, 
   3.5151814359289675`*^9, {3.516670127883032*^9, 3.5166701666334996`*^9}, 
   3.5166731186418858`*^9, 3.5166737399657774`*^9, {3.516826945697586*^9, 
   3.5168269464556303`*^9}, {3.5168300872452726`*^9, 3.516830089791418*^9}, {
   3.516831534936076*^9, 3.5168315360301385`*^9}, {3.5454167796156645`*^9, 
   3.5454167796156645`*^9}, {3.545430121495209*^9, 3.54543012225521*^9}, 
   3.546057877469945*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"b", " ", "d"}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["a", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095014754320154`*^9, 3.5095014757128158`*^9}, {
   3.509501663985547*^9, 3.5095016805839767`*^9}, {3.509828555552424*^9, 
   3.5098285973424826`*^9}, {3.509828656532565*^9, 3.509828698932625*^9}, {
   3.5098287432526865`*^9, 3.5098287837327433`*^9}, {3.5101746549548464`*^9, 
   3.5101746581060524`*^9}, {3.510174939280946*^9, 3.510174959092981*^9}, {
   3.5151682145645065`*^9, 3.5151682184145117`*^9}, {3.5168286510391264`*^9, 
   3.516828722449211*^9}, {3.5168287554080963`*^9, 3.51682883397459*^9}, {
   3.5168289004323907`*^9, 3.516828908860873*^9}, {3.5168293823899574`*^9, 
   3.516829496504484*^9}, {3.5168295653514223`*^9, 3.5168295660404615`*^9}, {
   3.5168297784096084`*^9, 3.516829780900751*^9}, {3.546057737848959*^9, 
   3.5460577631254053`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d"}], ")"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"a", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.5006670128563595`*^9, 
   3.500667030256384*^9}, {3.5006756721584826`*^9, 3.5006757072485313`*^9}, 
   3.5006761770891895`*^9, {3.500676504879648*^9, 3.500676511719658*^9}, {
   3.500676615389803*^9, 3.50067662058981*^9}, {3.50067712041051*^9, 
   3.500677157770562*^9}, 3.500684516250436*^9, {3.508358781038677*^9, 
   3.508358787338686*^9}, {3.5083588719288044`*^9, 3.508358881988818*^9}, {
   3.508378414067792*^9, 3.5083784269778104`*^9}, {3.508378464587863*^9, 
   3.508378467637867*^9}, {3.5083785093179255`*^9, 3.50837851959794*^9}, {
   3.5083787060882015`*^9, 3.5083787263182297`*^9}, 3.508380619208137*^9, {
   3.5084371686080427`*^9, 3.508437170918046*^9}, {3.5098473915587964`*^9, 
   3.5098473943488007`*^9}, {3.516670197973955*^9, 3.5166702183163905`*^9}, 
   3.5166702884229136`*^9, {3.516671215630943*^9, 3.516671306891103*^9}, 
   3.516821192477213*^9, {3.5168269411143246`*^9, 3.5168269420183764`*^9}, {
   3.51682905775939*^9, 3.5168290945344925`*^9}, 3.5168298608623247`*^9, {
   3.516832081331328*^9, 3.516832085810584*^9}, {3.541091078264818*^9, 
   3.54109109637645*^9}, 3.5454170786213894`*^9, {3.5456107850896482`*^9, 
   3.5456107858136897`*^9}, {3.546040830073034*^9, 3.5460408325030375`*^9}, 
   3.5460411417534704`*^9, {3.5460577703628187`*^9, 3.5460578033187037`*^9}, {
   3.5460580214231787`*^9, 3.5460580285335855`*^9}, {3.5461249077334204`*^9, 
   3.54612490774342*^9}, {3.546124949023478*^9, 3.546124949023478*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964645213514385`*^9, 
   3.5192470594155855`*^9, {3.519247288125906*^9, 3.5192473207459517`*^9}, {
   3.519247363296011*^9, 3.519247363796012*^9}, 3.519258420199427*^9, 
   3.5192584863895197`*^9, {3.519320760160028*^9, 3.519320767367241*^9}, 
   3.5193299099191504`*^9, {3.5193300315093203`*^9, 3.519330031709321*^9}, {
   3.5193323099968634`*^9, 3.5193324414114943`*^9}, {3.5193327317904043`*^9, 
   3.519332762148057*^9}, {3.519340455685931*^9, 3.519340463318947*^9}, 
   3.519340635545749*^9, {3.5193422478304834`*^9, 3.519342248704085*^9}, {
   3.519342492766513*^9, 3.519342493156514*^9}, {3.519345750301442*^9, 
   3.5193457505978427`*^9}, 3.519346263464343*^9, {3.519349307658399*^9, 
   3.519349310965605*^9}, {3.519352294781488*^9, 3.5193522950014887`*^9}, {
   3.5194134359455075`*^9, 3.519413446054325*^9}, {3.5194134908888044`*^9, 
   3.5194134927764077`*^9}, {3.5194141847624226`*^9, 
   3.5194142323581066`*^9}, {3.5195392931088047`*^9, 3.51953929576081*^9}, 
   3.5195394267074394`*^9, {3.5196773980538087`*^9, 3.5196774025801287`*^9}, 
   3.5214730195115576`*^9, {3.5214731380617237`*^9, 3.521473193531801*^9}, {
   3.521474138193124*^9, 3.5214741420331287`*^9}, {3.5214741988932085`*^9, 
   3.5214742007232113`*^9}, {3.523316621154496*^9, 3.523316621154496*^9}, {
   3.523316677984576*^9, 3.523316677984576*^9}, {3.523318504907651*^9, 
   3.523318504907651*^9}, {3.5233186383938627`*^9, 3.5233186383938627`*^9}, {
   3.527359904961545*^9, 3.527359905959947*^9}, {3.5326425332730722`*^9, 
   3.532642533473073*^9}, {3.5326427746632795`*^9, 3.53264277491288*^9}, {
   3.5326584214048853`*^9, 3.5326584216348853`*^9}, {3.5327156387673616`*^9, 
   3.5327156467558184`*^9}, {3.532715729333542*^9, 3.53271573123365*^9}, 
   3.5328460582169604`*^9, {3.5328745920833416`*^9, 3.5328746294142075`*^9}, {
   3.532875067275776*^9, 3.532875067650177*^9}, {3.532875139909504*^9, 
   3.532875150829523*^9}, {3.537656121233163*^9, 3.537656121443164*^9}, 
   3.540263906712819*^9, {3.5402639787229204`*^9, 3.5402639788829203`*^9}, {
   3.540319178473138*^9, 3.5403191846574917`*^9}, {3.540319223359705*^9, 
   3.5403192458899937`*^9}, {3.5403196532852955`*^9, 
   3.5403196542853527`*^9}, {3.5404234472634363`*^9, 
   3.5404234474974365`*^9}, {3.5404266413502464`*^9, 3.540426641755847*^9}, {
   3.540427707752519*^9, 3.5404277079553194`*^9}, {3.544238816041692*^9, 
   3.544238816041692*^9}, {3.544972902988535*^9, 3.544972921755368*^9}, 
   3.5449740982158346`*^9, 3.5449744158947926`*^9, {3.5449778031390886`*^9, 
   3.5449778251343465`*^9}, 3.544977917559617*^9, 3.5449779627882037`*^9, 
   3.544978006651713*^9, {3.5449918948372655`*^9, 3.5449919232873054`*^9}, {
   3.544991979387384*^9, 3.544991982507388*^9}, 3.544992738708447*^9, {
   3.5449930027088165`*^9, 3.5449930028388166`*^9}, 3.545003033111788*^9, {
   3.5450034681341515`*^9, 3.545003468352552*^9}, 3.545013424767751*^9, {
   3.5451009044378967`*^9, 3.545100915607912*^9}, {3.54541557020794*^9, 
   3.5454155892399735`*^9}, {3.5454159491014056`*^9, 3.545415954795416*^9}, 
   3.5454160835424414`*^9, {3.545416120483307*^9, 3.545416120483307*^9}, {
   3.54541627618718*^9, 3.545416318915655*^9}, {3.545416397555393*^9, 
   3.5454163977893934`*^9}, {3.5454168214081373`*^9, 
   3.5454168256513453`*^9}, {3.5454168914054604`*^9, 3.545416903979083*^9}, {
   3.5454169758952093`*^9, 3.545416976082409*^9}, {3.5454170486069365`*^9, 
   3.5454170486069365`*^9}, 3.5454968423372517`*^9, {3.545610761413294*^9, 
   3.54561076239135*^9}, {3.546061556769389*^9, 3.546061575684471*^9}, {
   3.5460616158377676`*^9, 3.5460616160207777`*^9}, {3.5460622992488565`*^9, 
   3.5460622992488565`*^9}, 3.5461915595099297`*^9, {3.5462000367717977`*^9, 
   3.5462000367717977`*^9}, 3.546209934510844*^9, {3.546210260621301*^9, 
   3.5462102929613466`*^9}, {3.5462105900817623`*^9, 3.546210603741781*^9}, 
   3.546210639771832*^9, {3.546315894728881*^9, 3.5463158959339504`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 2 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"m", "\[Equal]", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.501729725689207*^9, 
   3.5017297313520174`*^9}, 3.501729800304138*^9, 3.5053451043644323`*^9, 
   3.512064350632524*^9, {3.5454312604468036`*^9, 3.545431265626811*^9}, {
   3.5454365113581195`*^9, 3.5454365133981223`*^9}, {3.5454370225788355`*^9, 
   3.5454370600388875`*^9}, {3.5454372465891485`*^9, 
   3.5454372507491546`*^9}, {3.546061585209016*^9, 3.546061595460602*^9}, {
   3.5462106570618563`*^9, 3.5462106680918713`*^9}, {3.5480102136805696`*^9, 
   3.5480102143105707`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.